/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.editor.css.contentassist.model.SpecificationElement;
import com.aptana.editor.css.contentassist.model.ValueElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PseudoClassElement
extends BaseElement<Property> {
    private static final String VALUES_PROPERTY = "values";
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private List<SpecificationElement> _specifications;
    private List<ValueElement> _values;

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public void addValue(ValueElement value) {
        if (value != null) {
            if (this._values == null) {
                this._values = new ArrayList<ValueElement>();
            }
            this._values.add(value);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this._values = IndexUtil.createList(object.get(VALUES_PROPERTY), ValueElement.class);
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public List<SpecificationElement> getSpecifications() {
        return CollectionsUtil.getListValue(this._specifications);
    }

    public List<ValueElement> getValues() {
        return CollectionsUtil.getListValue(this._values);
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
        out.add(VALUES_PROPERTY, this.getValues());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PseudoClassElement)) {
            return false;
        }
        PseudoClassElement other = (PseudoClassElement)obj;
        return ObjectUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static enum Property implements IPropertyInformation<PseudoClassElement>
    {
        NAME(Messages.PseudoClassElement_NameLabel){

            public Object getPropertyValue(PseudoClassElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

