/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class ColorGroupElement
extends BaseElement<Property> {
    private Index index;
    private List<String> members;

    public ColorGroupElement(Index index) {
        this.index = index;
        this.setName(Messages.ColorGroupElement_ColorElementName);
    }

    public List<String> getColors() {
        if (this.members == null) {
            CSSIndexQueryHelper queryHelper = new CSSIndexQueryHelper();
            Set<String> colors = queryHelper.getColors(this.index);
            this.members = !CollectionsUtil.isEmpty(colors) ? new ArrayList<String>(colors) : Collections.emptyList();
        }
        return this.members;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    static enum Property implements IPropertyInformation<ColorGroupElement>
    {
        NAME(Messages.ColorGroupElement_NameLabel){

            public Object getPropertyValue(ColorGroupElement node) {
                return node.getName();
            }
        }
        ,
        COUNT(Messages.ColorGroupElement_CountLabel){

            public Object getPropertyValue(ColorGroupElement node) {
                return node.getColors().size();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

