/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.EnumSet;
import java.util.Set;

public class CSSElement
extends BaseElement<Property> {
    private Index index;

    public CSSElement(Index index) {
        this.index = index;
        this.setName(Messages.CSSElement_ElementName);
    }

    public Index getIndex() {
        return this.index;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    static enum Property implements IPropertyInformation<CSSElement>
    {
        NAME(Messages.CSSElement_NameLabel){

            public Object getPropertyValue(CSSElement node) {
                return node.getName();
            }
        }
        ,
        INDEX(Messages.CSSElement_IndexLabel){

            public Object getPropertyValue(CSSElement node) {
                return node.getIndex().toString();
            }
        }
        ,
        INDEX_FILE(Messages.CSSElement_IndexFileLabel){

            public Object getPropertyValue(CSSElement node) {
                return node.getIndex().getIndexFile().getAbsolutePath();
            }
        }
        ,
        INDEX_FILE_SIZE(Messages.CSSElement_IndexFileSizeLabel){

            public Object getPropertyValue(CSSElement node) {
                return node.getIndex().getIndexFile().length();
            }
        }
        ,
        CHILD_COUNT(Messages.CSSElement_ChildCountLabel){

            public Object getPropertyValue(CSSElement node) {
                return 3;
            }
        }
        ,
        VERSION(Messages.CSSElement_VersionLabel){

            public Object getPropertyValue(CSSElement node) {
                return 14.1212;
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

