/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.contentassist.model.ICSSMetadataElement;
import com.aptana.editor.css.contentassist.model.UserAgentElement;
import com.aptana.index.core.IndexDocument;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class BaseElement<P extends Enum<P>>
implements ICSSMetadataElement,
JSON.Convertible,
IndexDocument,
IPropertySource {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String EXAMPLE_PROPERTY = "example";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String NAME_PROPERTY = "name";
    private String _name;
    private List<UserAgentElement> _userAgents;
    private String _description;
    private String _example;
    private List<String> _documents;

    public void addDocument(String document) {
        if (document != null && document.length() > 0) {
            if (this._documents == null) {
                this._documents = new ArrayList<String>();
            }
            this._documents.add(document);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == null) {
                this._userAgents = new ArrayList<UserAgentElement>();
            }
            this._userAgents.add(userAgent);
        }
    }

    public void fromJSON(Map object) {
        this.setName(StringUtil.getStringValue(object.get(NAME_PROPERTY)));
        this.setDescription(StringUtil.getStringValue(object.get(DESCRIPTION_PROPERTY)));
        this.setExample(StringUtil.getStringValue(object.get(EXAMPLE_PROPERTY)));
        this._userAgents = IndexUtil.createList(object.get(USER_AGENTS_PROPERTY), UserAgentElement.class);
    }

    @Override
    public String getDescription() {
        return StringUtil.getStringValue((Object)this._description);
    }

    public List<String> getDocuments() {
        return CollectionsUtil.getListValue(this._documents);
    }

    public Object getEditableValue() {
        return null;
    }

    @Override
    public String getExample() {
        return StringUtil.getStringValue((Object)this._example);
    }

    @Override
    public String getName() {
        return StringUtil.getStringValue((Object)this._name);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (Enum p : this.getPropertyInfoSet()) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)p, ((IPropertyInformation)p).getHeader());
            String category = ((IPropertyInformation)p).getCategory();
            if (!StringUtil.isEmpty((String)category)) {
                descriptor.setCategory(category);
            }
            result.add(descriptor);
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    protected Set<P> getPropertyInfoSet() {
        return Collections.emptySet();
    }

    public Object getPropertyValue(Object id) {
        Object result = null;
        if (id instanceof IPropertyInformation) {
            result = ((IPropertyInformation)id).getPropertyValue((Object)this);
        }
        return result;
    }

    @Override
    public List<String> getUserAgentNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (UserAgentElement ua : this.getUserAgents()) {
            result.add(ua.getPlatform());
        }
        return result;
    }

    public Map<String, String> getUserAgentsNameWithVersion() {
        HashMap<String, String> userAgents = new HashMap<String, String>();
        for (UserAgentElement userAgent : this.getUserAgents()) {
            userAgents.put(userAgent.getPlatform(), userAgent.getVersion());
        }
        return userAgents;
    }

    @Override
    public List<UserAgentElement> getUserAgents() {
        return CollectionsUtil.getListValue(this._userAgents);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public void toJSON(JSON.Output out) {
        out.add(NAME_PROPERTY, (Object)this.getName());
        out.add(DESCRIPTION_PROPERTY, (Object)this.getDescription());
        out.add(EXAMPLE_PROPERTY, (Object)this.getExample());
        out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
    }
}

