/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.index;

import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.index.core.Index;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CSSIndexCacher {
    private static CSSIndexCacher instance;
    private static Map<PropertyElement, List<PropertyElement>> parent2SubProperties;
    private static Kryo kryo;

    static {
        parent2SubProperties = new ConcurrentHashMap<PropertyElement, List<PropertyElement>>();
        kryo = new Kryo();
        kryo.setClassLoader(CSSIndexCacher.class.getClassLoader());
        kryo.setAutoReset(true);
    }

    private CSSIndexCacher() {
    }

    public static CSSIndexCacher getInstance() {
        if (instance == null) {
            instance = new CSSIndexCacher();
        }
        return instance;
    }

    public List<PropertyElement> getSubProperties(PropertyElement parentProperty) {
        if (parentProperty != null) {
            return parent2SubProperties.get(parentProperty);
        }
        return null;
    }

    public void setSubProperties(PropertyElement parentProperty, List<PropertyElement> subProperties) {
        parent2SubProperties.put(parentProperty, subProperties);
    }

    public void deSerialize(Index index) {
        Input input = null;
        try {
            File indexFile = this.getIndexFile(index, false);
            if (!indexFile.exists()) {
                return;
            }
            try {
                input = new Input((InputStream)new FileInputStream(indexFile));
                Object obj = kryo.readClassAndObject(input);
                if (obj instanceof ConcurrentHashMap) {
                    parent2SubProperties = (ConcurrentHashMap)obj;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        finally {
            kryo.reset();
            if (input != null) {
                input.close();
            }
        }
    }

    public boolean isExistCache() {
        return !parent2SubProperties.isEmpty();
    }

    public void save() {
        Output output = null;
        try {
            try {
                Index index = CSSIndexQueryHelper.getIndex();
                output = new Output((OutputStream)new FileOutputStream(this.getIndexFile(index, true)));
                kryo.writeClassAndObject(output, parent2SubProperties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    File indexfile = this.getIndexFile(CSSIndexQueryHelper.getIndex(), true);
                    indexfile.createNewFile();
                    output = new Output((OutputStream)new FileOutputStream(indexfile));
                    kryo.writeClassAndObject(output, parent2SubProperties);
                }
                catch (IOException iOException) {}
                kryo.reset();
                if (output != null) {
                    output.close();
                }
            }
        }
        finally {
            kryo.reset();
            if (output != null) {
                output.close();
            }
        }
    }

    public File getIndexFile(Index index, boolean create) {
        String fileName = index.getIndexFile().getAbsolutePath();
        File indexFile = new File(fileName = String.valueOf(fileName) + ".db");
        if (!indexFile.exists() && create) {
            try {
                indexFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return indexFile;
    }
}

