/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.index;

import beaver.Symbol;
import com.aptana.build.util.BuildHelper;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.CSSColors;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.parsing.CSSFlexScanner;
import com.aptana.editor.css.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSTermNode;
import com.aptana.index.core.AbstractRemoteFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.index.service.IndexRequest;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class CSSFileIndexingParticipant
extends AbstractRemoteFileIndexingParticipant {
    private static final Pattern fgHexColorPattern = Pattern.compile("^#[a-fA-F0-9]{3}([a-fA-F0-9]{3})?$");

    public void requestIndex(IndexRequest request, IProgressMonitor monitor) {
        block18: {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                URI uri = request.getIndexURI();
                File file = new File(uri);
                if (!file.exists()) {
                    return;
                }
                try {
                    String content = request.readContents();
                    IParseRootNode ast = null;
                    try {
                        ParseResult result = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (String)content);
                        if (result != null) {
                            ast = result.getRootNode();
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                    }
                    if (ast != null) {
                        int[] counts = new int[]{0};
                        this.walkNode((IParseNode)ast, request.isNeedSleep(), counts);
                        break block18;
                    }
                    CSSFlexScanner scanner = new CSSFlexScanner();
                    scanner.setSource(content);
                    int length = content.length();
                    block12: while (length > 0) {
                        --length;
                        Symbol token = scanner.nextToken();
                        if (token.getId() == 0) {
                            break;
                        }
                        switch (token.getId()) {
                            case 18: {
                                String clazz = token.value.toString();
                                if (Character.isDigit((clazz = clazz.substring(1)).charAt(0))) continue block12;
                                this.addIndex("css.class", clazz);
                                continue block12;
                            }
                            case 19: {
                                String hash = token.value.toString();
                                hash = hash.substring(1);
                                this.addIndex("css.identifier", hash);
                                continue block12;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                }
            }
            finally {
                sub.done();
            }
        }
    }

    public void walkNode(IParseNode current, boolean isFullBuild, int[] counts) {
        CSSTermNode term;
        String value;
        if (current == null) {
            return;
        }
        if (isFullBuild) {
            counts[0] = counts[0] + 1;
            BuildHelper.sleepLoop((String)"CSS_INDEX_TYPE", (int)counts[0]);
        }
        if (current instanceof CSSAttributeSelectorNode) {
            CSSAttributeSelectorNode cssAttributeSelectorNode = (CSSAttributeSelectorNode)current;
            String text = cssAttributeSelectorNode.getText();
            if (!StringUtil.isEmpty((String)text) && text.charAt(0) == '.') {
                this.addIndex("css.class", text.substring(1));
            } else if (!StringUtil.isEmpty((String)text) && text.charAt(0) == '#') {
                this.addIndex("css.identifier", text.substring(1));
            }
        }
        if (current instanceof CSSTermNode && CSSFileIndexingParticipant.isColor(value = (term = (CSSTermNode)current).getText())) {
            this.addIndex("css.color", CSSColors.to6CharHexWithLeadingHash(value.trim()));
        }
        if (current instanceof CSSRuleNode) {
            CSSSelectorNode child;
            CSSRuleNode cssRuleNode = (CSSRuleNode)current;
            CSSSelectorNode[] cSSSelectorNodeArray = cssRuleNode.getSelectors();
            int n = cSSSelectorNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                child = cSSSelectorNodeArray[n2];
                this.walkNode((IParseNode)child, isFullBuild, counts);
                ++n2;
            }
            cSSSelectorNodeArray = cssRuleNode.getChildren();
            n = cSSSelectorNodeArray.length;
            n2 = 0;
            while (n2 < n) {
                child = cSSSelectorNodeArray[n2];
                this.walkNode((IParseNode)child, isFullBuild, counts);
                ++n2;
            }
        } else {
            IParseNode[] iParseNodeArray = current.getChildren();
            int n = iParseNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IParseNode child = iParseNodeArray[n3];
                this.walkNode(child, isFullBuild, counts);
                ++n3;
            }
        }
    }

    static boolean isColor(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        if (CSSColors.namedColorExists(value)) {
            return true;
        }
        if (value.charAt(0) == '#' && (value.length() == 4 || value.length() == 7)) {
            return fgHexColorPattern.matcher(value).matches();
        }
        return false;
    }

    public boolean isEnableType(BuildContextType contextType) {
        return contextType == BuildContextType.CSS || contextType == BuildContextType.ALL;
    }

    public void setIndexResult(Map<String, Set<String>> indexResult) {
        this.indexResult = indexResult;
    }

    public Map<String, Set<String>> getIndexResult() {
        return this.indexResult;
    }
}

