/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist;

import com.aptana.build.util.AssistHelper;
import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.IAsyncable;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.ProposalShowInfo;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.extensions.ISpecialValueListLocationType;
import com.aptana.editor.common.extensions.SpecialValueLocationType;
import com.aptana.editor.common.scripting.snippets.SnippetType;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSFunctions;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.CSSContextInformation;
import com.aptana.editor.css.contentassist.CSSContextInformationValidator;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.CSSPx2RemProposal;
import com.aptana.editor.css.contentassist.Location;
import com.aptana.editor.css.contentassist.LocationType;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.CSSFunctionElement;
import com.aptana.editor.css.contentassist.model.ElementElement;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.PseudoClassElement;
import com.aptana.editor.css.contentassist.model.PseudoElementElement;
import com.aptana.editor.css.contentassist.model.SpecificationElement;
import com.aptana.editor.css.contentassist.model.ValueElement;
import com.aptana.editor.css.htmlext.IAttrName;
import com.aptana.editor.css.htmlext.IPrefixAttributeSelectors;
import com.aptana.editor.css.internal.text.CSSModelFormatter;
import com.aptana.editor.css.parsing.CSSTokenScanner;
import com.aptana.editor.css.parsing.ast.CSSCharSetNode;
import com.aptana.editor.css.parsing.ast.CSSFontFaceNode;
import com.aptana.editor.css.parsing.ast.CSSFunctionNode;
import com.aptana.editor.css.parsing.ast.CSSImportNode;
import com.aptana.editor.css.parsing.ast.CSSInvokeNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSMediaBodyNode;
import com.aptana.editor.css.parsing.ast.CSSMediaExpressNode;
import com.aptana.editor.css.parsing.ast.CSSMediaQueryNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSPageRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.css.parsing.ast.CSSRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSSupportsConditionInParensNode;
import com.aptana.editor.css.parsing.ast.CSSSupportsRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSTermListNode;
import com.aptana.editor.css.parsing.ast.CSSTermNode;
import com.aptana.editor.css.parsing.ast.CSSTerminalNode;
import com.aptana.editor.css.parsing.lexer.CSSLexemeProvider;
import com.aptana.editor.css.parsing.lexer.CSSTokenType;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import com.aptana.ui.util.DisplayUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class CSSContentAssistProcessor
extends CommonContentAssistProcessor
implements IAsyncable {
    public static final Image ELEMENT_ICON = CSSPlugin.getImage("/icons/assistant/element.png");
    public static final Image SELECTOR_ICON = CSSPlugin.getImage("/icons/assistant/selector.png");
    public static final Image PROPERTY_ICON = CSSPlugin.getImage("/icons/assistant/property.png");
    private static final String regEx = "[\u4e00-\u9fa5]";
    public static final Pattern pat = Pattern.compile("[\u4e00-\u9fa5]");
    public static final Pattern pxPattern = Pattern.compile("(\\d*\\.?\\d+)px?$");
    private static final String PROPERTY_VALUES_IMPORTANT = "!important";
    private IContextInformationValidator _validator;
    private CSSIndexQueryHelper _queryHelper;
    private Lexeme<CSSTokenType> _currentLexeme;
    private IRange _replaceRange;
    private Point _selectRange;
    private IParseNode _activeAstNode;
    protected IDocument subDocument = null;
    protected IDocument document = null;
    private IRange _activeRange;
    private boolean showSnippetProposals;
    private boolean autoActivated;
    private LocationType locationType;
    private boolean needComputeLocationType = true;

    public boolean isAutoActivated() {
        return this.autoActivated;
    }

    public void setAutoActivated(boolean autoActivated) {
        this.autoActivated = autoActivated;
    }

    public CSSContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
        this._queryHelper = editor != null && "com.aptana.editor.html.NViewEditor".equals(editor.getClass().getName()) ? new CSSIndexQueryHelper(URI.create("css.metadata:/nview")) : new CSSIndexQueryHelper();
    }

    public CSSContentAssistProcessor(AbstractThemeableEditor editor, IRange activeRange) {
        this(editor);
        this._activeRange = activeRange;
    }

    protected void addAllElementProposals(List<ICompletionProposal> proposals, int offset) {
        List<ElementElement> elements = this._queryHelper.getElements();
        if (elements != null) {
            for (ElementElement element : elements) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation(element);
                CommonCompletionProposal proposal = this.addProposal(CompletionProposalType.ELEMENT, element.getName(), element.getName(), ELEMENT_ICON, description, element.getUserAgentsNameWithVersion(), "", null, offset, 0, 0, false);
                if (proposal == null) continue;
                proposals.add((ICompletionProposal)proposal);
            }
        }
    }

    protected void addAllPropertyProposals(Location location, List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset, char activationChar, boolean autofix) {
        List<PropertyElement> properties = this._queryHelper.getProperties();
        if (properties != null) {
            CommonCompletionProposal proposal;
            boolean isApplyNeedReContentAssist;
            String description;
            Point point;
            int index;
            Lexeme nextLexeme;
            boolean needpostfix;
            Point selectPoint = null;
            String postfix = ": ";
            boolean needSemicolon = false;
            boolean bl = needpostfix = autofix;
            if (this._currentLexeme != null) {
                switch ((CSSTokenType)((Object)this._currentLexeme.getType())) {
                    case RCURLY: 
                    case COLON: {
                        this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                        this._replaceRange = this._currentLexeme;
                        break;
                    }
                    case SEMICOLON: {
                        Lexeme p = lexemeProvider.getLexemeFromOffset(offset - 1);
                        if (p != null && p.getType() == CSSTokenType.IDENTIFIER) {
                            this._currentLexeme = p;
                            this._replaceRange = this._currentLexeme;
                            break;
                        }
                        this._currentLexeme = null;
                        this._replaceRange = null;
                        break;
                    }
                    case LCURLY: {
                        this._replaceRange = null;
                        break;
                    }
                    default: {
                        if (this._currentLexeme.contains(offset) || this._currentLexeme.getEndingOffset() == offset - 1) break;
                        this._replaceRange = null;
                    }
                }
            }
            if ((nextLexeme = lexemeProvider.getLexeme((index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme != null ? this._currentLexeme.getEndingOffset() : offset)) + (this._currentLexeme != null ? 1 : 0))) != null && nextLexeme.getType() == CSSTokenType.COLON) {
                try {
                    int nowline = this.editor.getDocument().getLineOfOffset(offset);
                    int nextline = this.editor.getDocument().getLineOfOffset(nextLexeme.getStartingOffset());
                    needpostfix = nowline != nextline;
                    selectPoint = this.getPropertyValuePoint(lexemeProvider, offset, index);
                    if (selectPoint == null && nextLexeme.getEndingOffset() + 1 < this.document.getLength()) {
                        selectPoint = new Point(nextLexeme.getEndingOffset() + 1, 0);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                }
            } else if (this._currentLexeme != null && this._currentLexeme.getType() == CSSTokenType.COLON) {
                needpostfix = false;
            }
            if (needpostfix && selectPoint == null && (this._currentLexeme == null || this._currentLexeme.getType() != CSSTokenType.SEMICOLON && this._currentLexeme.getEndingOffset() < offset) && (nextLexeme == null || nextLexeme.getType() != CSSTokenType.SEMICOLON)) {
                needSemicolon = true;
            }
            if (!needpostfix) {
                postfix = "";
            }
            int linkedCursorPosition = 0;
            if (needSemicolon) {
                postfix = String.valueOf(postfix) + ";";
                linkedCursorPosition = activationChar == ' ' ? (this._currentLexeme == null ? offset : this._currentLexeme.getEndingOffset()) : (this._currentLexeme == null ? offset : this._currentLexeme.getEndingOffset()) + 1;
            } else {
                Point semicolonPoint = this.getPropertyValueSemicolonPoint(lexemeProvider, offset, index);
                if (semicolonPoint != null) {
                    linkedCursorPosition = semicolonPoint.x;
                }
            }
            String nowValue = null;
            if (selectPoint != null && this._replaceRange != null) {
                int replaceOffset = this._replaceRange.getStartingOffset();
                int replaceLength = this._replaceRange.getLength();
                try {
                    nowValue = this.document.get(replaceOffset, replaceLength);
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                }
            }
            for (PropertyElement property : properties) {
                point = selectPoint;
                description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation(property);
                boolean bl2 = isApplyNeedReContentAssist = this.checkNeedReContentAssist(point, needpostfix, property.getName(), activationChar) && autofix;
                if (property.getName().equals(nowValue)) {
                    point = null;
                    isApplyNeedReContentAssist = false;
                }
                if ((proposal = this.addProposal(CompletionProposalType.ATTRIBUTE, property.getName(), String.valueOf(property.getName()) + postfix, PROPERTY_ICON, description, property.getUserAgentsNameWithVersion(), "", point, offset, needSemicolon ? -1 : 0, linkedCursorPosition, isApplyNeedReContentAssist)) == null) continue;
                this.setProposalShowInfo(property, proposal);
                proposals.add((ICompletionProposal)proposal);
            }
            if (!autofix) {
                for (PropertyElement property : this._queryHelper.getMediaQueryProperties()) {
                    point = selectPoint;
                    description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation(property);
                    boolean bl3 = isApplyNeedReContentAssist = this.checkNeedReContentAssist(point, needpostfix, property.getName(), activationChar) && autofix;
                    if (property.getName().equals(nowValue)) {
                        point = null;
                        isApplyNeedReContentAssist = false;
                    }
                    if ((proposal = this.addProposal(CompletionProposalType.ATTRIBUTE, property.getName(), String.valueOf(property.getName()) + postfix, PROPERTY_ICON, description, property.getUserAgentsNameWithVersion(), "", point, offset, needSemicolon ? -1 : 0, linkedCursorPosition, isApplyNeedReContentAssist)) == null) continue;
                    this.setProposalShowInfo(property, proposal);
                    proposals.add((ICompletionProposal)proposal);
                }
            }
        }
    }

    private boolean checkNeedReContentAssist(Point point, boolean needpostfix, String dispalyName, char activationChar) {
        boolean isApplyNeedReContentAssist = true;
        if (!this.isAutoActivated()) {
            return isApplyNeedReContentAssist;
        }
        isApplyNeedReContentAssist = this.checkNeedReContentAssist(dispalyName, activationChar, true);
        if (isApplyNeedReContentAssist) {
            isApplyNeedReContentAssist = point != null || needpostfix;
        }
        return isApplyNeedReContentAssist;
    }

    private boolean checkNeedReContentAssist(String dispalyName, char activationChar, boolean isProperty) {
        return true;
    }

    private Point getPropertyValuePoint(ILexemeProvider<CSSTokenType> lexemeProvider, int offset, int index) {
        Lexeme now = lexemeProvider.getLexemeFromOffset(offset);
        if (now == null) {
            return null;
        }
        int start = 0;
        int end = 0;
        int i = 2;
        while (i <= lexemeProvider.size() - 1) {
            Lexeme nextLexeme = lexemeProvider.getLexeme(index + i);
            if (nextLexeme != null && nextLexeme.getType() != CSSTokenType.SEMICOLON) {
                LocationType location = this.getInsideLocationType(lexemeProvider, nextLexeme.getStartingOffset(), false).getLocationType();
                if (location != LocationType.INSIDE_VALUE) break;
                if (i == 2) {
                    start = nextLexeme.getStartingOffset();
                }
            } else {
                if (nextLexeme == null || nextLexeme.getType() != CSSTokenType.COLON) break;
                end = 0;
                break;
            }
            end = nextLexeme.getEndingOffset();
            ++i;
        }
        if (end != 0) {
            block9: {
                if (this.document.getLineOfOffset(offset) == this.document.getLineOfOffset(start)) break block9;
                return null;
            }
            try {
                return new Point(start, end - start + 1);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    private Point getPropertyValueSemicolonPoint(ILexemeProvider<CSSTokenType> lexemeProvider, int offset, int index) {
        Lexeme now = lexemeProvider.getLexemeFromOffset(offset);
        if (now == null) {
            return null;
        }
        int start = 0;
        int end = 0;
        int i = 2;
        while (i <= lexemeProvider.size() - 1) {
            Lexeme nextLexeme = lexemeProvider.getLexeme(index + i);
            if (nextLexeme != null && nextLexeme.getType() == CSSTokenType.SEMICOLON) {
                start = nextLexeme.getStartingOffset();
                end = nextLexeme.getEndingOffset();
                break;
            }
            if (nextLexeme != null && nextLexeme.getType() == CSSTokenType.COLON) {
                end = 0;
                break;
            }
            ++i;
        }
        if (end != 0) {
            block8: {
                if (this.document.getLineOfOffset(offset) == this.document.getLineOfOffset(start)) break block8;
                return null;
            }
            try {
                this.document.get(start + 1, 1);
                return new Point(start, end);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    protected void addClasses(List<ICompletionProposal> proposals, int offset) {
        HashSet result = new HashSet();
        ISpecialListHandler classHandler = (ISpecialListHandler)SPEC_MAPS.get("ClassString");
        IRange replaceRange = this._replaceRange;
        if (replaceRange == null) {
            replaceRange = new Range(offset);
        }
        classHandler.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
        for (ICompletionProposal c : result) {
            if (!(c instanceof CommonCompletionProposal)) continue;
            CommonCompletionProposal proposal = (CommonCompletionProposal)c;
            String name = "." + proposal.getPrefixCompletionText(this.document, offset);
            proposal.setReplacementString(name);
            proposal.setDisplayString(name);
            proposals.add((ICompletionProposal)proposal);
            proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
        }
    }

    protected void addIDs(List<ICompletionProposal> proposals, int offset) {
        HashSet result = new HashSet();
        ISpecialListHandler IDHander = (ISpecialListHandler)SPEC_MAPS.get("IDString");
        IRange replaceRange = this._replaceRange;
        if (replaceRange == null) {
            replaceRange = new Range(offset);
        }
        IDHander.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
        for (ICompletionProposal c : result) {
            if (!(c instanceof CommonCompletionProposal)) continue;
            CommonCompletionProposal proposal = (CommonCompletionProposal)c;
            String name = "#" + proposal.getPrefixCompletionText(this.document, offset);
            proposal.setReplacementString(name);
            proposal.setDisplayString(name);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private void addInsideRuleProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset, char activationChar, boolean autofix) {
        Location location = this.getInsideLocationType(lexemeProvider, offset);
        this.locationType = location.getLocationType();
        if (this.locationType == LocationType.ERROR && lexemeProvider.size() == 0) {
            this.locationType = LocationType.INSIDE_PROPERTY;
        }
        switch (this.locationType) {
            case INSIDE_PROPERTY: {
                this.showSnippetProposals = this._activeRange == null;
                this.addAllPropertyProposals(location, proposals, lexemeProvider, offset, activationChar, autofix);
                break;
            }
            case INSIDE_VALUE: {
                HashSet<ICompletionProposal> set = new HashSet<ICompletionProposal>();
                this.addPropertyValues(location, set, lexemeProvider, offset, activationChar);
                proposals.addAll(set);
                break;
            }
        }
    }

    private void addOutsideRuleProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        block21: {
            block20: {
                Lexeme previous;
                if (this._currentLexeme != null && this._currentLexeme.getType() == CSSTokenType.LCURLY) {
                    this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                    this._replaceRange = this._currentLexeme;
                }
                if (this._currentLexeme != null) {
                    switch ((CSSTokenType)((Object)this._currentLexeme.getType())) {
                        case COLON: 
                        case COMMA: 
                        case WAVY: 
                        case LBRACKET: 
                        case PLUS: 
                        case GREATER: {
                            if (this._currentLexeme.getEndingOffset() >= offset) {
                                this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                                this._replaceRange = this._currentLexeme;
                                if (this.needIncludes(this._currentLexeme)) break;
                                this._replaceRange = null;
                                break;
                            }
                            this._replaceRange = null;
                            break;
                        }
                        case RCURLY: {
                            this._currentLexeme = null;
                            this._replaceRange = null;
                            ++offset;
                            break;
                        }
                        case IDENTIFIER: 
                        case ELEMENT: {
                            if (offset != this._currentLexeme.getStartingOffset()) break;
                            this._currentLexeme = lexemeProvider.getLexemeFromOffset(this._currentLexeme.getStartingOffset() - 1);
                            if (this._currentLexeme != null && this._currentLexeme.getType() == CSSTokenType.COLON) break;
                            this._currentLexeme = null;
                            this._replaceRange = null;
                            break;
                        }
                        case RBRACKET: 
                        case RPAREN: {
                            this._replaceRange = null;
                            if (offset > this._currentLexeme.getStartingOffset()) break;
                            this._currentLexeme = lexemeProvider.getLexemeFromOffset(this._currentLexeme.getStartingOffset() - 1);
                            if (this._currentLexeme == null || this._currentLexeme.getType() != CSSTokenType.IDENTIFIER && this._currentLexeme.getType() != CSSTokenType.ID && this._currentLexeme.getType() != CSSTokenType.CLASS && this._currentLexeme.getType() != CSSTokenType.MINUS) break;
                            this._replaceRange = this._currentLexeme;
                        }
                    }
                }
                if (this._currentLexeme == null) break block20;
                Lexeme switchLexeme = this._currentLexeme;
                if (switchLexeme.getType() == CSSTokenType.IDENTIFIER && (previous = lexemeProvider.getLexemeFromOffset(this._currentLexeme.getStartingOffset() - 1)) != null && (previous.getType() == CSSTokenType.COLON || previous.getType() == CSSTokenType.LPAREN || previous.getType() == CSSTokenType.LBRACKET)) {
                    switchLexeme = previous;
                }
                switch ((CSSTokenType)((Object)switchLexeme.getType())) {
                    case CLASS: {
                        this.addClasses(proposals, offset);
                        break;
                    }
                    case ID: {
                        this.addIDs(proposals, offset);
                        break;
                    }
                    case COLON: {
                        previous = lexemeProvider.getLexemeFromOffset(switchLexeme.getStartingOffset() - 1);
                        if (previous != null && previous.getType() == CSSTokenType.COLON) {
                            this.addPseudoElementProposals(proposals, offset);
                            break;
                        }
                        this.addPseudoClassProposals(proposals, offset);
                        break;
                    }
                    case LPAREN: {
                        String pseudoClassName = null;
                        Lexeme lex = lexemeProvider.getLexemeFromOffset(switchLexeme.getStartingOffset() - 1);
                        if (lex.getType() == CSSTokenType.IDENTIFIER) {
                            pseudoClassName = lex.getText();
                        }
                        this.addPseudoClassArguments(pseudoClassName, proposals, offset);
                        if ("not".equalsIgnoreCase(pseudoClassName)) {
                            this.addAllElementProposals(proposals, offset);
                            break;
                        }
                        break block21;
                    }
                    case RPAREN: {
                        break;
                    }
                    default: {
                        this.addAllElementProposals(proposals, offset);
                        break;
                    }
                }
                break block21;
            }
            this.addAllElementProposals(proposals, offset);
        }
    }

    private void addOutsideAttributeProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        Lexeme<CSSTokenType> lexeme = this.getOutsideAttributeTagName(lexemeProvider, offset);
        HashSet result = new HashSet();
        ISpecialListHandler IDHander = (ISpecialListHandler)SPEC_MAPS.get("AttrString");
        if (lexeme != null) {
            ((IPrefixAttributeSelectors)IDHander).setPrefix(lexeme.getText());
        } else {
            ((IPrefixAttributeSelectors)IDHander).setPrefix(null);
        }
        IRange replaceRange = this._replaceRange;
        if (replaceRange == null) {
            replaceRange = new Range(offset, offset - 1);
        }
        IDHander.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
        for (ICompletionProposal c : result) {
            if (!(c instanceof CommonCompletionProposal)) continue;
            CommonCompletionProposal proposal = (CommonCompletionProposal)c;
            String name = proposal.getPrefixCompletionText(this.document, offset).toString();
            proposal.setReplacementString(name);
            proposal.setDisplayString(name);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private Lexeme<CSSTokenType> getOutsideAttributeTagName(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        Lexeme lexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (!this.needIncludes((Lexeme<CSSTokenType>)lexeme) && !this.needIncludes((Lexeme<CSSTokenType>)(lexeme = lexemeProvider.getLexemeFromOffset(offset - 1)))) {
            lexeme = null;
        }
        this._currentLexeme = lexeme;
        this._replaceRange = this._currentLexeme;
        lexeme = lexemeProvider.getPreviousLexeme(offset);
        while (lexeme != null) {
            if (lexeme.getType() == CSSTokenType.SEMICOLON || lexeme.getType() == CSSTokenType.LPAREN || lexeme.getType() == CSSTokenType.RPAREN || lexeme.getType() == CSSTokenType.LCURLY || lexeme.getType() == CSSTokenType.RCURLY || lexeme.getType() == CSSTokenType.AT_RULE || lexeme.getType() == CSSTokenType.ID || lexeme.getType() == CSSTokenType.CLASS) break;
            if (lexeme.getType() == CSSTokenType.LBRACKET) {
                Lexeme preLexeme = lexemeProvider.getPreviousLexeme(lexeme.getStartingOffset());
                if (preLexeme != null && preLexeme.getType() == CSSTokenType.RBRACKET) {
                    lexeme = preLexeme;
                    continue;
                }
                lexeme = lexemeProvider.getPreviousLexeme(lexeme.getStartingOffset());
                break;
            }
            if ((lexeme = lexemeProvider.getPreviousLexeme(lexeme.getStartingOffset())) != null && lexeme.getType() == CSSTokenType.LBRACKET) continue;
        }
        if (lexeme != null && (lexeme.getType() == CSSTokenType.IDENTIFIER || lexeme.getType() == CSSTokenType.ID)) {
            return lexeme;
        }
        return null;
    }

    private void addOutsideAttributeValueProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        Lexeme<CSSTokenType> tagNameLexeme = this.getOutsideAttributeTagName(lexemeProvider, offset);
        Lexeme lexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (!this.needIncludes((Lexeme<CSSTokenType>)lexeme) && !this.needIncludes((Lexeme<CSSTokenType>)(lexeme = lexemeProvider.getLexemeFromOffset(offset - 1)))) {
            lexeme = null;
        }
        this._currentLexeme = lexeme;
        this._replaceRange = this._currentLexeme;
        HashSet result = new HashSet();
        ISpecialListHandler IDHander = (ISpecialListHandler)SPEC_MAPS.get("AttrValueString");
        Lexeme lexeme2 = lexeme = lexeme == null ? lexemeProvider.getPreviousLexeme(offset) : lexemeProvider.getPreviousLexeme(lexeme.getStartingOffset());
        if (lexeme != null && (lexeme.getType() == CSSTokenType.EQUAL || lexeme.getType() == CSSTokenType.INCLUDES || lexeme.getType() == CSSTokenType.DASHMATCH || lexeme.getType() == CSSTokenType.BEGINS_WITH || lexeme.getType() == CSSTokenType.ENDS_WITH || lexeme.getType() == CSSTokenType.CONTAINS)) {
            if ((lexeme = lexemeProvider.getPreviousLexeme(lexeme.getStartingOffset())) == null || lexeme.getType() != CSSTokenType.IDENTIFIER) {
                return;
            }
        } else {
            return;
        }
        if (tagNameLexeme != null) {
            ((IPrefixAttributeSelectors)IDHander).setPrefix(tagNameLexeme.getText());
        } else {
            ((IPrefixAttributeSelectors)IDHander).setPrefix(null);
        }
        ((IAttrName)IDHander).setAttrName(lexeme.getText());
        IRange replaceRange = this._replaceRange;
        if (replaceRange == null) {
            replaceRange = new Range(offset, offset - 1);
        } else if (((Lexeme)replaceRange).getType() == CSSTokenType.DOUBLE_QUOTED_STRING || ((Lexeme)replaceRange).getType() == CSSTokenType.SINGLE_QUOTED_STRING) {
            replaceRange = new Range(this._replaceRange.getStartingOffset() + 1, this._replaceRange.getEndingOffset() - 1);
        }
        IDHander.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
        for (ICompletionProposal c : result) {
            if (!(c instanceof CommonCompletionProposal)) continue;
            CommonCompletionProposal proposal = (CommonCompletionProposal)c;
            String name = proposal.getPrefixCompletionText(this.document, offset).toString();
            proposal.setReplacementString(name);
            proposal.setDisplayString(name);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private void addPropertyValues(Location location, Set<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset, char activationChar) {
        String propertyName = this.getPropertyName(lexemeProvider, offset);
        if (!this.checkNeedReContentAssist(propertyName, activationChar, false)) {
            return;
        }
        if (!StringUtil.isEmpty((String)propertyName)) {
            List<String> types;
            Point semicolonPoint;
            Lexeme nextLexeme;
            this.setPropertyValueRange(lexemeProvider, offset);
            PropertyElement property = this._queryHelper.getProperty(propertyName);
            if (property == null) {
                return;
            }
            int relativeCursorPosition = 0;
            int linkedCursorPosition = 0;
            int index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme != null ? this._currentLexeme.getEndingOffset() : offset);
            if (this._currentLexeme != null && (this._currentLexeme.getType() == CSSTokenType.IDENTIFIER || this._currentLexeme.getType() == CSSTokenType.LENGTH)) {
                Object previousLexeme;
                String text = null;
                int start = this._currentLexeme.getStartingOffset();
                int end = this._currentLexeme.getEndingOffset();
                if (this._currentLexeme.getType() == CSSTokenType.LENGTH) {
                    text = this._currentLexeme.getText();
                } else if (this._currentLexeme.getType() == CSSTokenType.IDENTIFIER && (previousLexeme = lexemeProvider.getLexeme(index - 1)) != null && previousLexeme.getType() == CSSTokenType.NUMBER && previousLexeme.getEndingOffset() == this._currentLexeme.getStartingOffset() - 1) {
                    text = String.valueOf(previousLexeme.getText()) + this._currentLexeme.getText();
                    start = previousLexeme.getStartingOffset();
                }
                if (text != null && this.checkAndAddNumProposals(proposals, text, (IRange)new Range(start, end))) {
                    return;
                }
            }
            if (this._currentLexeme != null && this._currentLexeme.getType() == CSSTokenType.COLON) {
                if (!property.allowMultipleValues()) {
                    relativeCursorPosition = 1;
                }
            } else if ((this._currentLexeme == null || this._currentLexeme.getEndingOffset() <= offset) && (nextLexeme = lexemeProvider.getLexeme(index + (this._currentLexeme != null ? 1 : 0))) != null && nextLexeme.getType() == CSSTokenType.SEMICOLON) {
                if (!property.allowMultipleValues()) {
                    relativeCursorPosition = this._currentLexeme != null ? nextLexeme.getEndingOffset() - this._currentLexeme.getEndingOffset() : nextLexeme.getEndingOffset() + 1 - offset;
                } else {
                    linkedCursorPosition = nextLexeme.getEndingOffset() + 1;
                }
            }
            if (property.allowMultipleValues() && linkedCursorPosition == 0 && (semicolonPoint = this.getPropertyValueSemicolonPoint(lexemeProvider, offset, index)) != null) {
                linkedCursorPosition = semicolonPoint.x + 1;
            }
            if ((types = property.getTypes()) != null && !types.isEmpty()) {
                boolean isInMethod = location.isInMethod();
                for (String type : types) {
                    boolean isURI;
                    if (StringUtil.isBlank((String)type)) break;
                    boolean bl = isURI = type.indexOf("URI") > 0;
                    if (!isURI && isInMethod) break;
                    ISpecialListHandler handler = (ISpecialListHandler)SPEC_MAPS.get(type);
                    if (handler == null) continue;
                    if (handler instanceof ISpecialValueListLocationType) {
                        ((ISpecialValueListLocationType)handler).setLocationType(SpecialValueLocationType.IN_CSS);
                    }
                    Object range = null;
                    range = this.needFullReplace(offset) ? (this._replaceRange == null ? new Range(offset, offset - 1) : this._replaceRange) : (this._replaceRange == null ? new Range(offset, offset - 1) : new Range(this._replaceRange.getStartingOffset(), 0));
                    handler.doComputeSpecialProposals(this.editor, offset, (IRange)range, proposals, false);
                    if (relativeCursorPosition == 0 && linkedCursorPosition == 0) continue;
                    for (ICompletionProposal proposal : proposals) {
                        if (!(proposal instanceof CommonCompletionProposal) || ((CommonCompletionProposal)proposal).isApplyNeedReContentAssist((ITextViewer)this.editor.getISourceViewer(), offset)) continue;
                        ((CommonCompletionProposal)proposal).setCursorPosition(((CommonCompletionProposal)proposal).getCursorPosition() + relativeCursorPosition);
                        ((CommonCompletionProposal)proposal).setlinkedCursorPosition(linkedCursorPosition);
                    }
                }
            }
            if (property != null && !location.isInMethod()) {
                boolean isContainNumber = CSSContentAssistProcessor.checkTypesContainsNumber(types);
                for (ValueElement value : property.getValues()) {
                    CommonCompletionProposal proposal = this.addProposal(null, value.getName(), value.getName(), PROPERTY_ICON, value.getDescription(), value.getUserAgentsNameWithVersion(), "", null, offset, relativeCursorPosition, linkedCursorPosition, false);
                    if (isContainNumber) {
                        proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
                    }
                    if (proposal == null) continue;
                    proposals.add((ICompletionProposal)proposal);
                }
            }
            if (!location.isInMethod()) {
                this.addImportantProposal(proposals, lexemeProvider, offset);
            }
            if (!CollectionsUtil.isEmpty(property.getSubs())) {
                List<PropertyElement> subPropertys;
                Range range = null;
                if (this.needFullReplace(offset)) {
                    range = this._replaceRange == null ? new Range(offset, offset - 1) : this._replaceRange;
                } else {
                    Range range2 = range = this._replaceRange == null ? new Range(offset, offset - 1) : new Range(this._replaceRange.getStartingOffset(), 0);
                }
                if (!CollectionsUtil.isEmpty(property.getSubs()) && !CollectionsUtil.isEmpty(subPropertys = this._queryHelper.getSubProperties(property))) {
                    for (PropertyElement subProperty : subPropertys) {
                        this.addSubPropertyValues(subProperty, location, proposals, lexemeProvider, offset, relativeCursorPosition, linkedCursorPosition, (IRange)range, activationChar);
                    }
                }
            }
        }
    }

    private void addSubPropertyValues(PropertyElement subProperty, Location location, Set<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset, int relativeCursorPosition, int linkedCursorPosition, IRange range, char activationChar) {
        List<PropertyElement> subPropertys;
        if (subProperty == null) {
            return;
        }
        List<String> types = subProperty.getTypes();
        if (types != null && !types.isEmpty()) {
            boolean isInMethod = location.isInMethod();
            for (String type : types) {
                boolean isURI;
                if (StringUtil.isBlank((String)type)) break;
                boolean bl = isURI = type.indexOf("URI") > 0;
                if (!isURI && isInMethod) break;
                ISpecialListHandler handler = (ISpecialListHandler)SPEC_MAPS.get(type);
                if (handler == null) continue;
                if (handler instanceof ISpecialValueListLocationType) {
                    ((ISpecialValueListLocationType)handler).setLocationType(SpecialValueLocationType.IN_CSS);
                }
                handler.doComputeSpecialProposals(this.editor, offset, range, proposals, false);
            }
        }
        if (subProperty != null && !location.isInMethod()) {
            boolean isContainNumber = CSSContentAssistProcessor.checkTypesContainsNumber(types);
            for (ValueElement value : subProperty.getValues()) {
                CommonCompletionProposal proposal = this.addProposal(null, value.getName(), value.getName(), PROPERTY_ICON, value.getDescription(), value.getUserAgentsNameWithVersion(), "", null, offset, relativeCursorPosition, linkedCursorPosition, false);
                if (proposal == null) continue;
                if (isContainNumber) {
                    proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
                }
                proposals.add((ICompletionProposal)proposal);
            }
        }
        if (!CollectionsUtil.isEmpty(subProperty.getSubs()) && !CollectionsUtil.isEmpty(subPropertys = this._queryHelper.getSubProperties(subProperty))) {
            for (PropertyElement sub : subPropertys) {
                this.addSubPropertyValues(sub, location, proposals, lexemeProvider, offset, relativeCursorPosition, linkedCursorPosition, range, activationChar);
            }
        }
    }

    private void addImportantProposal(Set<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        boolean enableNow;
        int initOffset = offset;
        Lexeme now = lexemeProvider.getLexemeFromOffset(offset);
        if (now == null || now.getType() == CSSTokenType.SEMICOLON) {
            now = lexemeProvider.getLexemeFromOffset(offset - 1);
            --offset;
        }
        Lexeme left = lexemeProvider.getPreviousLexeme(now != null ? now.getStartingOffset() : offset);
        Lexeme right = lexemeProvider.getNextLexeme(now != null ? now.getEndingOffset() : offset);
        boolean enableLeft = left.getType() != CSSTokenType.COLON && left.getType() != CSSTokenType.IMPORTANT;
        boolean bl = enableNow = now == null || now.getType() == CSSTokenType.SEMICOLON || now.getType() == CSSTokenType.IMPORTANT;
        if (enableLeft && enableNow) {
            try {
                boolean enableRight;
                boolean bl2 = enableRight = right == null || right.getType() == CSSTokenType.SEMICOLON || this.document.getLineOfOffset(offset) != this.document.getLineOfOffset(right.getStartingOffset());
                if (enableRight) {
                    this._replaceRange = now != null && now.getType() == CSSTokenType.SEMICOLON ? null : now;
                    CommonCompletionProposal proposal = this.addProposal(null, PROPERTY_VALUES_IMPORTANT, PROPERTY_VALUES_IMPORTANT, PROPERTY_ICON, null, null, "", null, initOffset, 1, 0, false);
                    if (proposal != null) {
                        proposals.add((ICompletionProposal)proposal);
                    }
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    protected CommonCompletionProposal addProposal(CompletionProposalType type, String displayName, String name, Image image, String description, Map<String, String> userAgentIds, String fileLocation, Point selectPoint, int offset, int relativeCursorPosition, int linkedCursorPosition, boolean isApplyNeedReContentAssist) {
        if (userAgentIds == null || this.isActiveByUserAgent(userAgentIds.keySet().toArray(new String[userAgentIds.size()]))) {
            CommonCompletionProposal proposal = this.createProposal(type, displayName, name, image, description, userAgentIds, fileLocation, selectPoint, offset, relativeCursorPosition, linkedCursorPosition, isApplyNeedReContentAssist);
            return proposal;
        }
        return null;
    }

    private void setProposalShowInfo(BaseElement element, CommonCompletionProposal proposal) {
        HashMap<String, String> specification = new HashMap<String, String>();
        List<Object> list = new ArrayList();
        String reference = "";
        if (element instanceof PseudoClassElement) {
            PseudoClassElement pseudoClassElement = (PseudoClassElement)element;
            list = pseudoClassElement.getSpecifications();
        } else if (element instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)element;
            list = propertyElement.getSpecifications();
            reference = propertyElement.getType();
        } else if (element instanceof PseudoElementElement) {
            PseudoElementElement pseudoElementElement = (PseudoElementElement)element;
            list = pseudoElementElement.getSpecifications();
        }
        if (list != null) {
            for (SpecificationElement specificationElement : list) {
                if (specificationElement == null) continue;
                specification.put(specificationElement.getName(), specificationElement.getVersion());
            }
        }
        ProposalShowInfo proposalShowInfo = new ProposalShowInfo(specification, reference);
        String name = element.getName();
        if (StringUtil.isNotBlank((String)name)) {
            proposalShowInfo.setName(name);
        }
        proposal.setProposalShowInfo(proposalShowInfo);
    }

    protected void addPseudoClassArguments(String pseudoClassName, List<ICompletionProposal> proposals, int offset) {
        if (pseudoClassName == null) {
            return;
        }
        List<PseudoClassElement> classes = this._queryHelper.getPseudoClasses();
        if (classes != null) {
            for (PseudoClassElement pseudoClass : classes) {
                if (!pseudoClass.getName().equals(pseudoClassName)) continue;
                List<ValueElement> values = pseudoClass.getValues();
                if (values == null) break;
                for (ValueElement value : values) {
                    CommonCompletionProposal proposal = this.addProposal(CompletionProposalType.CLASS, value.getName(), value.getName(), SELECTOR_ICON, value.getDescription(), pseudoClass.getUserAgentsNameWithVersion(), "", null, offset, 0, 0, false);
                    if (proposal == null) continue;
                    proposals.add((ICompletionProposal)proposal);
                }
            }
        }
    }

    protected void addPseudoClassProposals(List<ICompletionProposal> proposals, int offset) {
        List<PseudoElementElement> elements;
        List<PseudoClassElement> classes = this._queryHelper.getPseudoClasses();
        if (classes != null) {
            for (PseudoClassElement pseudoClass : classes) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation(pseudoClass);
                CommonCompletionProposal proposal = this.addProposal(CompletionProposalType.CLASS, pseudoClass.getName(), pseudoClass.getName(), SELECTOR_ICON, description, pseudoClass.getUserAgentsNameWithVersion(), "", null, offset, 0, 0, false);
                if (proposal == null) continue;
                this.setProposalShowInfo(pseudoClass, proposal);
                proposals.add((ICompletionProposal)proposal);
            }
        }
        if ((elements = this._queryHelper.getPseudoElements()) != null) {
            for (PseudoElementElement pseudoElement : elements) {
                if (!pseudoElement.allowPseudoClassSyntax()) continue;
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation(pseudoElement);
                CommonCompletionProposal proposal = this.addProposal(CompletionProposalType.ELEMENT, pseudoElement.getName(), pseudoElement.getName(), SELECTOR_ICON, description, pseudoElement.getUserAgentsNameWithVersion(), "", null, offset, 0, 0, false);
                if (proposal == null) continue;
                this.setProposalShowInfo(pseudoElement, proposal);
                proposals.add((ICompletionProposal)proposal);
            }
        }
    }

    protected void addPseudoElementProposals(List<ICompletionProposal> proposals, int offset) {
        List<PseudoElementElement> elements = this._queryHelper.getPseudoElements();
        if (elements != null) {
            for (PseudoElementElement pseudoElement : elements) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation(pseudoElement);
                CommonCompletionProposal proposal = this.addProposal(CompletionProposalType.ELEMENT, pseudoElement.getName(), pseudoElement.getName(), SELECTOR_ICON, description, pseudoElement.getUserAgentsNameWithVersion(), "", null, offset, 0, 0, false);
                if (proposal == null) continue;
                this.setProposalShowInfo(pseudoElement, proposal);
                proposals.add((ICompletionProposal)proposal);
            }
        }
    }

    public ILexemeProvider<CSSTokenType> createLexemeProvider(IDocument document, int offset) {
        if (this._activeRange != null) {
            return new CSSLexemeProvider(document, this._activeRange, (ITokenScanner)new CSSTokenScanner());
        }
        IRange range = this.getLexemeRange(document, offset);
        return new CSSLexemeProvider(document, range, (ITokenScanner)new CSSTokenScanner());
    }

    protected CommonCompletionProposal createProposal(CompletionProposalType type, String displayName, String name, Image image, String description, Map<String, String> userAgentIds, String fileLocation, Point selectPoint, int offset, int relativeCursorPosition, int linkedCursorPosition, boolean isApplyNeedReContentAssist) {
        int length = name.length();
        boolean showContextInfo = false;
        if (name.endsWith("()")) {
            --length;
            isApplyNeedReContentAssist = true;
            showContextInfo = true;
        } else if (relativeCursorPosition != 0) {
            length += relativeCursorPosition;
        }
        IContextInformation contextInfo = null;
        int replaceLength = 0;
        if (this._replaceRange != null) {
            int oldOffset = offset;
            offset = this._replaceRange.getStartingOffset();
            if (!this.needFullReplace(oldOffset)) {
                replaceLength = oldOffset - this._replaceRange.getStartingOffset();
                replaceLength = replaceLength < 0 ? 0 : replaceLength;
                selectPoint = null;
                isApplyNeedReContentAssist = false;
            } else {
                replaceLength = this._replaceRange.getLength();
            }
        }
        Map userAgents = UserAgentManager.getInstance().getUserAgentPath(this.getProject(), userAgentIds);
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
        proposal.setCompletionProposalType(type);
        proposal.setApplyNeedReContentAssist(isApplyNeedReContentAssist);
        proposal.setFileLocation(fileLocation);
        proposal.setUserAgentImages(userAgents);
        proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
        proposal.setSelection(selectPoint);
        proposal.setlinkedCursorPosition(linkedCursorPosition);
        proposal.setShowContextInfo(showContextInfo);
        proposal = this.processImage(null, proposal);
        return proposal;
    }

    private boolean needFullReplace(int offset) {
        if (this._replaceRange != null && this._currentLexeme != null) {
            CSSTokenType type = (CSSTokenType)((Object)this._currentLexeme.getType());
            if (offset > this._replaceRange.getStartingOffset() && (type == CSSTokenType.SINGLE_QUOTED_STRING || type == CSSTokenType.DOUBLE_QUOTED_STRING)) {
                return true;
            }
            if (type == CSSTokenType.URL ? offset >= this._currentLexeme.getStartingOffset() + 3 : type == CSSTokenType.FUNCTION && this._replaceRange.getStartingOffset() > this._currentLexeme.getStartingOffset() && this._replaceRange.getEndingOffset() < this._currentLexeme.getEndingOffset()) {
                return true;
            }
        }
        if (this._replaceRange != null && offset > this._replaceRange.getEndingOffset()) {
            return true;
        }
        if (this._selectRange != null && this._currentLexeme != null && this._selectRange.x == this._currentLexeme.getStartingOffset() && this._selectRange.y == this._currentLexeme.getLength()) {
            return true;
        }
        return this._replaceRange == null;
    }

    private CommonCompletionProposal processImage(File file, CommonCompletionProposal proposal) {
        if (file != null && file.exists()) {
            proposal.setShowImage(true);
            proposal.setShowImagePath(file.getPath());
        }
        return proposal;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(final ITextViewer viewer, int offset, char activationChar, final boolean autoActivated) {
        ArrayList<ICompletionProposal> result;
        block47: {
            block46: {
                AssistHelper.checkState();
                DisplayUtils.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CSSContentAssistProcessor.this.setTextViewer(viewer, autoActivated);
                    }
                });
                result = new ArrayList<ICompletionProposal>();
                if (this.isNeedComputeLocationType()) {
                    this._activeAstNode = this.getActiveASTNode(offset - 1);
                }
                if (this._activeAstNode == null) break block46;
                if (this._activeAstNode instanceof CSSTerminalNode || this._activeAstNode instanceof CSSTermListNode || this._activeAstNode instanceof CSSTermNode && this._activeAstNode.getParent() instanceof CSSTermListNode) {
                    String text = null;
                    IParseNode node = null;
                    if (this._activeAstNode instanceof CSSTerminalNode || this._activeAstNode instanceof CSSTermListNode) {
                        text = this._activeAstNode.getText();
                        node = this._activeAstNode;
                    } else {
                        node = this._activeAstNode.getParent();
                        text = node.getText();
                    }
                    if (this.checkAndAddNumProposals(result, text, (IRange)new Range(this._activeAstNode.getStartingOffset(), this._activeAstNode.getEndingOffset()))) {
                        return result.toArray(new ICompletionProposal[result.size()]);
                    }
                }
                if (this._activeAstNode.getNodeType() == 4 || this._activeAstNode.getNodeType() == 33) {
                    this._activeAstNode = this._activeAstNode.getParent();
                }
                switch (this._activeAstNode.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 5: {
                        this.addMediaKeyWords(result, offset);
                        break;
                    }
                    case 7: {
                        this.addMediaKeyWords(result, offset);
                        this.locationType = LocationType.UNKNOWN;
                        break;
                    }
                    case 19: {
                        this.locationType = LocationType.OUTSIDE_RULE;
                        break;
                    }
                    case 16: {
                        this.addAllElementProposals(result, offset);
                        break;
                    }
                    case 8: {
                        try {
                            char ch = this.document.getChar(offset - 1);
                            if (ch == ':') {
                                this.addRuleKeyWords(result, offset, new String[]{"left", "right", "first", "blank"});
                            } else {
                                this.addRuleKeyWords(result, offset, new String[]{":left", ":right", ":first", ":blank"});
                            }
                            this.locationType = LocationType.UNKNOWN;
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        break block47;
                    }
                    case 17: {
                        this.addRuleKeyWords(result, offset, new String[]{":left", ":right", ":first", ":blank"});
                        break;
                    }
                    case 24: {
                        if (this._activeAstNode.getParent() instanceof CSSImportNode) {
                            this._replaceRange = this._activeAstNode.getText().indexOf(34) > 0 || this._activeAstNode.getText().indexOf(39) > 0 ? new Range(this._activeAstNode.getStartingOffset() + 5, this._activeAstNode.getEndingOffset() - 2) : new Range(this._activeAstNode.getStartingOffset() + 4, this._activeAstNode.getEndingOffset() - 1);
                            this.addImportCSSFiles(result, offset);
                            break;
                        }
                        result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, null));
                        break;
                    }
                    case 27: {
                        if (this._activeAstNode.getParent() instanceof CSSCharSetNode) {
                            this._replaceRange = new Range(this._activeAstNode.getStartingOffset() + 1, this._activeAstNode.getEndingOffset() - 1);
                            this.addCharset(result, offset);
                            break;
                        }
                        if (this._activeAstNode.getParent() instanceof CSSImportNode) {
                            this._replaceRange = new Range(this._activeAstNode.getStartingOffset() + 1, this._activeAstNode.getEndingOffset() - 1);
                            this.addImportCSSFiles(result, offset);
                            break;
                        }
                        break block47;
                    }
                    case 28: {
                        this.addInsideRuleProposals(result, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(this._activeAstNode.getStartingOffset() + 1, this._activeAstNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner()), offset, activationChar, false);
                        break;
                    }
                    case 29: {
                        result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(this._activeAstNode.getStartingOffset() + 1, this._activeAstNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner())));
                        break;
                    }
                    case 25: {
                        this.addMediaKeyWords(result, offset);
                        break;
                    }
                    case 34: {
                        this.addInsideRuleProposals(result, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(this._activeAstNode.getStartingOffset() + 1, this._activeAstNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner()), offset, activationChar, false);
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 10: {
                        result.addAll(this.doComputeCompletionProposalsWithLexeme(offset - 1, activationChar, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(this._activeAstNode.getStartingOffset(), this._activeAstNode.getEndingOffset()), (ITokenScanner)new CSSTokenScanner())));
                        break;
                    }
                    default: {
                        if (this._activeAstNode instanceof CSSNode) {
                            CSSNode node = (CSSNode)this._activeAstNode;
                            IParseNode bodyNode = node.getContainingStatementNode2();
                            if (bodyNode instanceof CSSMediaBodyNode) {
                                result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(bodyNode.getStartingOffset() + 1, bodyNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner())));
                                break;
                            }
                            if (bodyNode instanceof CSSPageRuleBodyNode) {
                                String[] pageSubRules = new String[]{"@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"};
                                result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(bodyNode.getStartingOffset(), bodyNode.getEndingOffset()), (ITokenScanner)new CSSTokenScanner()), bodyNode));
                                if (this._replaceRange == null) {
                                    this._replaceRange = new Range(offset + 1, offset);
                                }
                                if (this.locationType == LocationType.INSIDE_PROPERTY) {
                                    this.addRuleKeyWords(result, offset, pageSubRules);
                                    break;
                                }
                            } else {
                                if (bodyNode instanceof CSSSupportsRuleBodyNode) {
                                    result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(bodyNode.getStartingOffset() + 1, bodyNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner())));
                                    break;
                                }
                                if (bodyNode instanceof CSSRuleBodyNode) {
                                    result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(bodyNode.getStartingOffset(), bodyNode.getEndingOffset()), (ITokenScanner)new CSSTokenScanner())));
                                    break;
                                }
                                if (bodyNode instanceof CSSKeyFramesRuleBodyNode) {
                                    this.addRuleKeyWords(result, offset, new String[]{"from", "to"});
                                    break;
                                }
                                if (bodyNode instanceof CSSMediaExpressNode) {
                                    this._replaceRange = null;
                                    this.addInsideRuleProposals(result, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(bodyNode.getStartingOffset() + 1, bodyNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner()), offset - 1, activationChar, false);
                                    break;
                                }
                                if (bodyNode instanceof CSSSupportsConditionInParensNode) {
                                    this.addInsideRuleProposals(result, (ILexemeProvider<CSSTokenType>)new CSSLexemeProvider(this.document, (IRange)new Range(bodyNode.getStartingOffset() + 1, bodyNode.getEndingOffset() - 1), (ITokenScanner)new CSSTokenScanner()), offset - 1, activationChar, false);
                                    break;
                                }
                            }
                        } else if (this._activeAstNode instanceof CSSParseRootNode) {
                            CSSParseRootNode rootNode = (CSSParseRootNode)this._activeAstNode;
                            IParseNode previousNode = null;
                            int current = offset - 1;
                            while (current > 0 && !(previousNode instanceof CSSNode)) {
                                previousNode = rootNode.getNodeAtOffset(--current);
                            }
                            if (previousNode != null) {
                                if (previousNode.getParent() instanceof CSSMediaQueryNode || previousNode.getParent() instanceof CSSImportNode || previousNode instanceof CSSImportNode) {
                                    this.addMediaKeyWords(result, offset);
                                    this.locationType = LocationType.UNKNOWN;
                                    break;
                                }
                                if (previousNode instanceof CSSFontFaceNode) {
                                    this.locationType = LocationType.UNKNOWN;
                                    break;
                                }
                            }
                            result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, null));
                            break;
                        }
                        break block47;
                    }
                }
                break block47;
            }
            result.addAll(this.doComputeCompletionProposalsWithLexeme(offset, activationChar, null));
        }
        ICompletionProposal[] proposals = result.toArray(new ICompletionProposal[result.size()]);
        return proposals;
    }

    public void setTextViewer(ITextViewer viewer, boolean autoActivated) {
        if (this.editor != null) {
            this._selectRange = this.editor.getISourceViewer().getSelectedRange();
            if (this._selectRange.y == 0) {
                this._selectRange = null;
            }
        }
        this.document = this.subDocument != null ? this.subDocument : viewer.getDocument();
        this.setAutoActivated(autoActivated);
    }

    private boolean checkAndAddNumProposals(Collection<ICompletionProposal> proposals, String text, IRange replaceRange) {
        if (StringUtil.isNotEmpty((String)text) && (Character.isDigit(text.charAt(0)) || text.charAt(0) == '.' && text.length() > 1 && Character.isDigit(text.charAt(1)))) {
            Matcher matcher = pxPattern.matcher(text);
            if (matcher.find()) {
                this.addPx2RemProposals(proposals, text, matcher.group(1), replaceRange);
            }
            return true;
        }
        return false;
    }

    private void addPx2RemProposals(Collection<ICompletionProposal> proposals, String text, String num, IRange replaceRange) {
        IProject project = this.getProject();
        IPreferenceStore store = CommonEditorPlugin.getDefault().getPreferenceStore();
        if (project != null) {
            store = new ChainedPreferenceStore(new IPreferenceStore[]{new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "com.aptana.editor.common", ""), store});
        }
        if (!store.getBoolean("com.aptana.editor.common.px2remEnable")) {
            return;
        }
        String numText = num;
        if (num.startsWith(".")) {
            num = "0" + num;
        }
        try {
            Double.parseDouble(num);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        try {
            int proportion = store.getInt("com.aptana.editor.common.px2remProportion");
            int decimalLength = store.getInt("com.aptana.editor.common.px2remDecimalLength");
            if (proportion > 0) {
                double fNum;
                String value = String.valueOf(Double.parseDouble(num) / (double)proportion);
                int position = value.indexOf(".");
                if (position > 0) {
                    if (decimalLength > 0) {
                        if (value.length() - position > decimalLength) {
                            value = value.substring(0, position + 1 + decimalLength);
                        }
                    } else {
                        value = value.substring(0, position);
                    }
                }
                value = (fNum = Double.parseDouble(value)) == (double)((int)fNum) ? String.valueOf((int)fNum) : String.valueOf(fNum);
                CSSPx2RemProposal proposal = new CSSPx2RemProposal(String.valueOf(value) + "rem", replaceRange.getStartingOffset(), replaceRange.getLength(), replaceRange.getEndingOffset(), PROPERTY_ICON, String.valueOf(numText) + "px->" + value + "rem", text.charAt(text.length() - 1) == 'p');
                proposal.setAutoReplace(false);
                proposals.add((ICompletionProposal)proposal);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
    }

    private void addRuleKeyWords(List<ICompletionProposal> result, int offset, String[] keywords) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(keyword, this._replaceRange, PROPERTY_ICON, "");
            result.add((ICompletionProposal)proposal);
            ++n2;
        }
    }

    private void addMediaKeyWords(List<ICompletionProposal> result, int offset) {
        String[] mediaTypes = new String[]{"screen", "only", "not", "and", "print", "all", "speech", "projection"};
        this.addRuleKeyWords(result, offset, mediaTypes);
    }

    private void addImportCSSFiles(List<ICompletionProposal> proposals, int offset) {
        HashSet result = new HashSet();
        ISpecialListHandler classHandler = (ISpecialListHandler)SPEC_MAPS.get("CSSURIString");
        IRange replaceRange = this._replaceRange;
        if (replaceRange == null) {
            replaceRange = new Range(offset);
        }
        classHandler.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
        for (ICompletionProposal c : result) {
            if (!(c instanceof CommonCompletionProposal)) continue;
            CommonCompletionProposal proposal = (CommonCompletionProposal)c;
            String name = "" + proposal.getPrefixCompletionText(this.document, offset);
            proposal.setReplacementString(name);
            proposal.setDisplayString(name);
            proposals.add((ICompletionProposal)proposal);
            proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
        }
    }

    private void addCharset(List<ICompletionProposal> proposals, int offset) {
        HashSet result = new HashSet();
        ISpecialListHandler classHandler = (ISpecialListHandler)SPEC_MAPS.get("CharsetString");
        IRange replaceRange = this._replaceRange;
        if (replaceRange == null) {
            replaceRange = new Range(offset);
        }
        classHandler.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
        for (ICompletionProposal c : result) {
            if (!(c instanceof CommonCompletionProposal)) continue;
            CommonCompletionProposal proposal = (CommonCompletionProposal)c;
            String name = "" + proposal.getPrefixCompletionText(this.document, offset);
            proposal.setReplacementString(name);
            proposal.setDisplayString(name);
            proposals.add((ICompletionProposal)proposal);
            proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
        }
    }

    public List<ICompletionProposal> doComputeCompletionProposalsWithLexeme(int offset, char activationChar, ILexemeProvider<CSSTokenType> lexemeProvider) {
        return this.doComputeCompletionProposalsWithLexeme(offset, activationChar, lexemeProvider, null);
    }

    public List<ICompletionProposal> doComputeCompletionProposalsWithLexeme(int offset, char activationChar, ILexemeProvider<CSSTokenType> lexemeProvider, IParseNode bodyNode) {
        AssistHelper.checkState();
        if (lexemeProvider == null) {
            lexemeProvider = this.createLexemeProvider(this.document, offset);
        }
        this.locationType = this.getLocationTypeByLexeme(offset, lexemeProvider);
        if (bodyNode != null && bodyNode instanceof CSSPageRuleBodyNode) {
            this.locationType = LocationType.INSIDE_RULE;
        }
        try {
            if (EditorUtil.isJSPartition((AbstractThemeableEditor)this.editor, (int)offset) && this.getPredefinedLocationType() == LocationType.OUTSIDE_RULE) {
                LocationType type = this.getCoarseLocationType(lexemeProvider, offset);
                this.locationType = type == null ? LocationType.OUTSIDE_RULE : type;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        switch (this.locationType) {
            case OUTSIDE_RULE: {
                this.addOutsideRuleProposals(result, lexemeProvider, offset);
                break;
            }
            case OUTSIDE_ATTRIBUTE: {
                this.addOutsideAttributeProposals(result, lexemeProvider, offset);
                break;
            }
            case OUTSIDE_ATTRIBUTE_VALUE: {
                this.addOutsideAttributeValueProposals(result, lexemeProvider, offset);
                break;
            }
            case INSIDE_RULE: {
                this.addInsideRuleProposals(result, lexemeProvider, offset, activationChar, true);
                break;
            }
            case INSIDE_ARG: {
                break;
            }
            case IN_MEDIA_RULE: {
                this.addMediaKeyWords(result, offset);
                break;
            }
        }
        return result;
    }

    public LocationType getLocationTypeByLexeme(int offset, ILexemeProvider<CSSTokenType> lexemeProvider) {
        Lexeme type;
        this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (this._currentLexeme != null && this._currentLexeme.getStartingOffset() == offset && (type = lexemeProvider.getLexemeFromOffset(offset - 1)) != null) {
            this._currentLexeme = type;
        }
        if (this._currentLexeme == null) {
            this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
        }
        this._replaceRange = this._currentLexeme;
        return this.isNeedComputeLocationType() ? this.getCoarseLocationType(lexemeProvider, offset) : LocationType.INSIDE_RULE;
    }

    protected IParseNode getActiveASTNode(int offset) {
        AssistHelper.checkState();
        IParseNode node = null;
        try {
            String content = this._activeRange != null ? this.document.get(this._activeRange.getStartingOffset(), this._activeRange.getLength()) : this.document.get();
            int startingOffset = this._activeRange != null ? this._activeRange.getStartingOffset() : 0;
            ParseResult pResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (String)content, (int)startingOffset);
            IParseRootNode root = pResult.getRootNode();
            if (root != null) {
                node = root.getNodeAtOffset(offset);
                if (node == null) {
                    if (offset < root.getStartingOffset()) {
                        node = root.getNodeAtOffset(root.getStartingOffset());
                    } else if (offset > root.getEndingOffset()) {
                        node = root.getNodeAtOffset(root.getEndingOffset());
                    }
                }
                this._replaceRange = node instanceof CSSTerminalNode ? new Range(node.getStartingOffset(), node.getEndingOffset()) : new Range(offset + 1, offset);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)e.getMessage());
        }
        return node;
    }

    /*
     * Unable to fully structure code
     */
    public LocationType getCoarseLocationType(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        result = LocationType.ERROR;
        index = lexemeProvider.getLexemeFloorIndex(offset);
        num = 0;
        block25: while (index >= 0) {
            lexeme = lexemeProvider.getLexeme(index);
            switch (CSSContentAssistProcessor.$SWITCH_TABLE$com$aptana$editor$css$parsing$lexer$CSSTokenType()[((CSSTokenType)lexeme.getType()).ordinal()]) {
                case 96: {
                    if (lexeme.getStartingOffset() + 10 < offset && lexeme.getEndingOffset() >= offset) {
                        result = LocationType.IN_IE_EXPRESSION;
                        break block25;
                    }
                }
                case 6: {
                    if (lexeme.getEndingOffset() < offset) {
                        result = LocationType.INSIDE_RULE;
                        break block25;
                    }
                    result = LocationType.OUTSIDE_RULE;
                    break block25;
                }
                case 7: {
                    result = lexeme.getEndingOffset() < offset ? LocationType.OUTSIDE_RULE : LocationType.INSIDE_RULE;
                    break block25;
                }
                case 8: {
                    i = index - 1;
                    while (i >= 0) {
                        candidate = lexemeProvider.getLexeme(i);
                        switch (CSSContentAssistProcessor.$SWITCH_TABLE$com$aptana$editor$css$parsing$lexer$CSSTokenType()[((CSSTokenType)candidate.getType()).ordinal()]) {
                            case 4: 
                            case 6: {
                                result = LocationType.INSIDE_RULE;
                                break block25;
                            }
                            case 9: {
                                colon = lexemeProvider.getLexeme(i - 2);
                                if (colon != null && CSSTokenType.CHARSET == colon.getType()) {
                                    result = LocationType.OUTSIDE_RULE;
                                    break block25;
                                }
                                result = LocationType.INSIDE_RULE;
                                break block25;
                            }
                            case 7: 
                            case 11: 
                            case 12: {
                                result = LocationType.OUTSIDE_RULE;
                                break block25;
                            }
                            default: {
                                --i;
                            }
                        }
                    }
                    i = index + 1;
                    while (i < lexemeProvider.size()) {
                        candidate = lexemeProvider.getLexeme(i);
                        switch (CSSContentAssistProcessor.$SWITCH_TABLE$com$aptana$editor$css$parsing$lexer$CSSTokenType()[((CSSTokenType)candidate.getType()).ordinal()]) {
                            case 4: 
                            case 9: {
                                result = LocationType.INSIDE_RULE;
                                break block25;
                            }
                            case 6: 
                            case 11: 
                            case 12: {
                                result = LocationType.OUTSIDE_RULE;
                                break block25;
                            }
                            default: {
                                ++i;
                            }
                        }
                    }
                    result = LocationType.OUTSIDE_RULE;
                    break block25;
                }
                case 1: 
                case 25: {
                    result = LocationType.INSIDE_RULE;
                    break block25;
                }
                case 72: {
                    ** GOTO lbl76
                }
                case 15: {
                    candidate = lexemeProvider.getLexeme(index - 1);
                    if (candidate != null && candidate.getType() == CSSTokenType.MEDIA_KEYWORD) {
                        result = LocationType.IN_MEDIA_RULE;
                        this._replaceRange = new Range(offset, offset - 1);
                        break block25;
                    }
                    ** GOTO lbl76
                }
                case 95: {
                    if (num == 0 && offset <= lexeme.getEndingOffset() && offset > lexeme.getStartingOffset()) {
                        result = LocationType.UNKNOWN;
                        break block25;
                    }
                }
                case 3: {
                    if (num == 0 && offset <= lexeme.getEndingOffset() && offset > lexeme.getStartingOffset()) {
                        result = LocationType.INSIDE_ARG;
                        break block25;
                    }
                }
lbl76:
                // 5 sources

                default: {
                    ++num;
                    --index;
                }
            }
        }
        if (index < 0 && result == LocationType.ERROR) {
            result = LocationType.OUTSIDE_RULE;
        }
        if (result == LocationType.OUTSIDE_RULE) {
            switchLexeme = lexemeProvider.getLexemeFromOffset(offset);
            if (switchLexeme == null) {
                switchLexeme = lexemeProvider.getPreviousLexeme(offset);
            }
            block28: while (switchLexeme != null) {
                switch (CSSContentAssistProcessor.$SWITCH_TABLE$com$aptana$editor$css$parsing$lexer$CSSTokenType()[((CSSTokenType)switchLexeme.getType()).ordinal()]) {
                    case 56: 
                    case 69: {
                        if (switchLexeme.getType() == CSSTokenType.LBRACKET && switchLexeme.getStartingOffset() >= offset || switchLexeme.getType() == CSSTokenType.RBRACKET && switchLexeme.getEndingOffset() < offset) break block28;
                        lexeme = lexemeProvider.getPreviousLexeme(offset);
                        if (lexeme.getType() == CSSTokenType.IDENTIFIER) {
                            lexeme = lexemeProvider.getPreviousLexeme(lexeme.getStartingOffset());
                        }
                        if (lexeme.getType() == CSSTokenType.LBRACKET) {
                            result = LocationType.OUTSIDE_ATTRIBUTE;
                            break block28;
                        }
                        if (lexeme.getType() == CSSTokenType.INCLUDES || lexeme.getType() == CSSTokenType.EQUAL || lexeme.getType() == CSSTokenType.DASHMATCH || lexeme.getType() == CSSTokenType.BEGINS_WITH || lexeme.getType() == CSSTokenType.ENDS_WITH || lexeme.getType() == CSSTokenType.CONTAINS) {
                            result = LocationType.OUTSIDE_ATTRIBUTE_VALUE;
                            break block28;
                        }
                        result = LocationType.UNKNOWN;
                        break block28;
                    }
                    case 66: {
                        if (this._replaceRange == null) {
                            this._replaceRange = new Range(offset, offset - 1);
                        }
                        result = LocationType.IN_MEDIA_RULE;
                        break block28;
                    }
                    case 6: 
                    case 7: {
                        break block28;
                    }
                    default: {
                        switchLexeme = lexemeProvider.getPreviousLexeme(switchLexeme.getStartingOffset());
                    }
                }
            }
        }
        return result;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this._validator == null) {
            this._validator = new CSSContextInformationValidator();
        }
        return this._validator;
    }

    private int getIndexOfPreviousColon(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        int result = -1;
        int i = index;
        while (i >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(i);
            if (lexeme.getType() == CSSTokenType.COLON) {
                result = i;
                break;
            }
            --i;
        }
        return result;
    }

    public Location getInsideLocationType(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        return this.getInsideLocationType(lexemeProvider, offset, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location getInsideLocationType(ILexemeProvider<CSSTokenType> lexemeProvider, int offset, boolean needChangeReplaceRange) {
        Lexeme lexeme;
        if (this.document == null && this.editor != null) {
            this.document = this.editor.getDocument();
        }
        LocationType locationType = LocationType.ERROR;
        Location location = new Location(locationType);
        int index = lexemeProvider.getLexemeIndex(offset);
        boolean initMethod = false;
        if (index < 0) {
            int candidateIndex = lexemeProvider.getLexemeFloorIndex(offset);
            lexeme = lexemeProvider.getLexeme(candidateIndex);
            index = lexeme != null && (lexeme.getEndingOffset() == offset - 1 || this._activeRange != null) ? candidateIndex : lexemeProvider.getLexemeCeilingIndex(offset);
        }
        int num = 0;
        block25: while (index >= 0) {
            lexeme = lexemeProvider.getLexeme(index);
            block1 : switch ((CSSTokenType)((Object)lexeme.getType())) {
                case LCURLY: {
                    locationType = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case RCURLY: {
                    if (index <= 0) break;
                    Lexeme previousLexeme = lexemeProvider.getLexeme(index - 1);
                    if (previousLexeme.getEndingOffset() == offset - 1) {
                        switch ((CSSTokenType)((Object)previousLexeme.getType())) {
                            case CLASS: {
                                locationType = LocationType.ERROR;
                                break block25;
                            }
                            case ID: {
                                locationType = LocationType.INSIDE_VALUE;
                                break;
                            }
                            case LCURLY: 
                            case SEMICOLON: {
                                locationType = LocationType.INSIDE_PROPERTY;
                                break;
                            }
                        }
                        break;
                    }
                    switch ((CSSTokenType)((Object)previousLexeme.getType())) {
                        case FUNCTION: 
                        case COLON: 
                        case RGB: 
                        case NUMBER: 
                        case IDENTIFIER: 
                        case DOUBLE_QUOTED_STRING: 
                        case SINGLE_QUOTED_STRING: 
                        case PERCENTAGE: 
                        case URL: 
                        case LENGTH: 
                        case EMS: 
                        case EXS: 
                        case ANGLE: 
                        case TIME: 
                        case FREQUENCY: {
                            try {
                                IRegion line = this.document.getLineInformationOfOffset(previousLexeme.getEndingOffset());
                                if (offset >= line.getOffset() && offset <= line.getOffset() + line.getLength()) {
                                    locationType = LocationType.INSIDE_VALUE;
                                    break block1;
                                }
                                locationType = LocationType.INSIDE_PROPERTY;
                            }
                            catch (BadLocationException e) {
                                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                                locationType = LocationType.INSIDE_PROPERTY;
                            }
                            break block1;
                        }
                    }
                    locationType = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case PROPERTY: 
                case IDENTIFIER: 
                case ELEMENT: {
                    boolean afterColon = false;
                    int i = index - 1;
                    block26: while (i >= 0) {
                        Lexeme candidate = lexemeProvider.getLexeme(i);
                        switch ((CSSTokenType)((Object)candidate.getType())) {
                            case COLON: {
                                afterColon = true;
                                break block26;
                            }
                            case LCURLY: 
                            case RCURLY: 
                            case SEMICOLON: {
                                break block26;
                            }
                            default: {
                                --i;
                                continue block26;
                            }
                        }
                    }
                    if (afterColon) break;
                    if (needChangeReplaceRange) {
                        if (lexeme.contains(offset) || lexeme.getEndingOffset() == offset - 1) {
                            this._currentLexeme = lexeme;
                            this._replaceRange = this._currentLexeme;
                        } else {
                            this._currentLexeme = null;
                            this._replaceRange = null;
                        }
                    }
                    locationType = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case SEMICOLON: {
                    if (lexeme.getEndingOffset() >= offset) break;
                    locationType = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case COLON: {
                    locationType = lexeme.getEndingOffset() < offset ? LocationType.INSIDE_VALUE : LocationType.INSIDE_PROPERTY;
                    break;
                }
                case FUNCTION: {
                    if (num == 0 && offset <= lexeme.getEndingOffset() && offset > lexeme.getStartingOffset()) {
                        locationType = LocationType.INSIDE_ARG;
                        break block25;
                    }
                }
                case VALUE: {
                    locationType = LocationType.INSIDE_VALUE;
                    break;
                }
                case RPAREN: {
                    if (!initMethod) {
                        initMethod = true;
                    }
                }
                case LPAREN: {
                    if (initMethod) break;
                    initMethod = true;
                    Lexeme pre = lexemeProvider.getLexeme(index - 1);
                    if (pre.getType() != CSSTokenType.IDENTIFIER) break;
                    location.setInMethod(true);
                    location.setMethodName(pre.getText());
                }
            }
            if (locationType != LocationType.ERROR) break;
            --index;
            ++num;
        }
        location.setLocationType(locationType);
        return location;
    }

    private int getLexemeAfterDelimiter(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        int index = lexemeProvider.getLexemeIndex(offset);
        if (index >= 0) {
            Lexeme currentLexeme = lexemeProvider.getLexeme(index);
            if (currentLexeme.getType() == CSSTokenType.SEMICOLON) {
                currentLexeme = lexemeProvider.getLexeme(--index);
            }
            int i = index;
            while (i >= 0) {
                Lexeme previousLexeme;
                Lexeme lexeme = previousLexeme = i > 0 ? lexemeProvider.getLexeme(i - 1) : null;
                if (this.isValueDelimiter((Lexeme<CSSTokenType>)currentLexeme) || !previousLexeme.isContiguousWith(currentLexeme)) {
                    index = i;
                    break;
                }
                currentLexeme = previousLexeme;
                index = i--;
            }
        }
        return index;
    }

    private Lexeme<CSSTokenType> getLexemeBeforeDelimiter(ILexemeProvider<CSSTokenType> lexemeProvider, int index) {
        Lexeme result = null;
        Lexeme startingLexeme = lexemeProvider.getLexeme(index);
        if (startingLexeme != null && !this.isValueDelimiter((Lexeme<CSSTokenType>)startingLexeme)) {
            Lexeme endingLexeme = startingLexeme;
            ++index;
            while (index < lexemeProvider.size()) {
                Lexeme candidateLexeme = lexemeProvider.getLexeme(index);
                if (this.isValueDelimiter((Lexeme<CSSTokenType>)candidateLexeme) || !endingLexeme.isContiguousWith(candidateLexeme)) break;
                endingLexeme = candidateLexeme;
                ++index;
            }
            if (index >= lexemeProvider.size()) {
                endingLexeme = lexemeProvider.getLexeme(lexemeProvider.size() - 1);
            }
            result = endingLexeme;
        }
        return result;
    }

    protected IRange getLexemeRange(IDocument document, int offset) {
        int endOffset;
        int startOffset;
        block9: {
            startOffset = 0;
            try {
                int testOffset = document.get(0, offset).lastIndexOf(125, offset);
                startOffset = testOffset < 0 ? 0 : testOffset + 1;
            }
            catch (BadLocationException badLocationException) {}
            endOffset = offset;
            try {
                ITypedRegion region = document.getPartition(offset);
                if (region == null) break block9;
                if (region.getType().equals("__css_multiline_comment")) {
                    return new Range(region.getOffset(), region.getOffset() + region.getLength());
                }
                if (!region.getType().startsWith("__css_") && !region.getType().equals("__dftl_partition_content_type")) {
                    region = document.getPartition(offset - 1);
                }
                if (region.getType().startsWith("__css_") || region.getType().equals("__dftl_partition_content_type")) {
                    ITypedRegion nextRegion;
                    String type;
                    int start = region.getOffset() - 1;
                    if (start > 0 && ((type = document.getContentType(start)) == null || !type.equals("__dftl_partition_content_type") && !type.startsWith("__css_"))) {
                        startOffset = region.getOffset();
                    }
                    if (document.get(region.getOffset(), region.getLength()).trim().endsWith(":") && (nextRegion = document.getPartition(region.getOffset() + region.getLength())) != null) {
                        region = nextRegion;
                    }
                    endOffset = Math.max(startOffset, region.getOffset() + region.getLength() - 1);
                    break block9;
                }
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        return new Range(startOffset, endOffset);
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.css";
    }

    private String getPropertyName(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        String result = null;
        int index = this.getIndexOfPreviousColon(lexemeProvider, offset);
        if (index > 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index - 1);
            result = lexeme.getText();
        }
        return result;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return Character.isWhitespace(c);
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        EnumSet<CSSTokenType[]> types = EnumSet.of(CSSTokenType.LCURLY, new CSSTokenType[]{CSSTokenType.COMMA, CSSTokenType.COLON, CSSTokenType.SEMICOLON, CSSTokenType.CLASS, CSSTokenType.ID});
        ILexemeProvider<CSSTokenType> lexemeProvider = this.createLexemeProvider(document, offset);
        if (offset > 0) {
            Lexeme lexeme = lexemeProvider.getFloorLexeme(offset - 1);
            return lexeme != null ? types.contains(lexeme.getType()) : false;
        }
        return false;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return 65 <= keyCode && keyCode <= 90 || 97 <= keyCode && keyCode <= 122 || c == '_' || c == '#' || c == '.' || c == '-';
    }

    private boolean isValueDelimiter(Lexeme<CSSTokenType> lexeme) {
        boolean result = false;
        switch ((CSSTokenType)((Object)lexeme.getType())) {
            case LCURLY: 
            case RCURLY: 
            case COLON: 
            case SEMICOLON: 
            case COMMA: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public void setActiveRange(IRange activeRange) {
        this._activeRange = activeRange;
    }

    private void setPropertyValueRange(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        Lexeme next;
        Lexeme<CSSTokenType> endingLexeme;
        int index = this.getLexemeAfterDelimiter(lexemeProvider, offset);
        Lexeme<CSSTokenType> lexeme = endingLexeme = index >= 0 ? this.getLexemeBeforeDelimiter(lexemeProvider, index) : null;
        if (endingLexeme != null && this._replaceRange == null) {
            Lexeme startingLexeme = lexemeProvider.getLexeme(index);
            this._replaceRange = new Range(startingLexeme.getStartingOffset(), endingLexeme.getEndingOffset());
        } else if (this._currentLexeme != null && (this._currentLexeme.contains(offset) || this._currentLexeme.getEndingOffset() == offset - 1)) {
            switch ((CSSTokenType)((Object)this._currentLexeme.getType())) {
                case COLON: {
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case LCURLY: {
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case RCURLY: {
                    Lexeme candidate = lexemeProvider.getLexemeFromOffset(offset - 1);
                    if (candidate != null && !this.isValueDelimiter((Lexeme<CSSTokenType>)candidate)) {
                        this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                        this._replaceRange = this._currentLexeme;
                        break;
                    }
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case SEMICOLON: {
                    Lexeme lexeme2 = lexemeProvider.getLexemeFromOffset(offset - 1);
                    if (lexeme2 != null && lexeme2.getType() == CSSTokenType.COLON) {
                        this._currentLexeme = null;
                        this._replaceRange = null;
                        break;
                    }
                    this._currentLexeme = lexeme2;
                    this._replaceRange = this._currentLexeme;
                    break;
                }
                default: {
                    this._replaceRange = this._currentLexeme;
                    break;
                }
            }
        } else {
            this._currentLexeme = null;
            this._replaceRange = null;
        }
        if (this._replaceRange != null && (next = lexemeProvider.getNextLexeme(this._replaceRange.getEndingOffset())) != null && next.getType() == CSSTokenType.COLON) {
            this._replaceRange = null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        CSSFunctionNode functionNode;
        String funcName;
        CSSFunctionElement fElement;
        this.setTextViewer(viewer, false);
        ArrayList<CSSContextInformation> result = new ArrayList<CSSContextInformation>();
        CSSInvokeNode ivkNode = this.getFunctionNode(viewer, offset);
        if (ivkNode != null && (fElement = CSSFunctions.getCSSFunction(funcName = (functionNode = (CSSFunctionNode)ivkNode.getParent()).getName())) != null) {
            CSSContextInformation ci = new CSSContextInformation(fElement, this.getProjectURI(), ivkNode.getStartingOffset());
            result.add(ci);
        }
        return result.toArray(new IContextInformation[result.size()]);
    }

    private CSSInvokeNode getFunctionNode(ITextViewer viewer, int offset) {
        IParseNode activeNode = this.getActiveASTNode(offset - 1);
        if (activeNode instanceof CSSInvokeNode) {
            CSSInvokeNode ivkNode = (CSSInvokeNode)activeNode;
            return ivkNode;
        }
        return null;
    }

    protected List<ICompletionProposal> addRubleProposals(ITextViewer viewer, int offset) {
        if (this.showSnippetProposals) {
            this.showSnippetProposals = false;
            return super.addRubleProposals(viewer, offset);
        }
        return new ArrayList<ICompletionProposal>(0);
    }

    public SnippetType getSnippetType() {
        if (this.locationType == null || "com.aptana.editor.html.NViewEditor".equals(this.editor.getClass().getName())) {
            return new SnippetType(SnippetType.Type.NO_TYPE);
        }
        switch (this.locationType) {
            case OUTSIDE_ATTRIBUTE: 
            case OUTSIDE_ATTRIBUTE_VALUE: {
                return new SnippetType(SnippetType.Type.NO_TYPE);
            }
            case INSIDE_PROPERTY: {
                return new SnippetType(CSSTokenType.PROPERTY.getScope());
            }
            case INSIDE_VALUE: {
                return new SnippetType(CSSTokenType.VALUE.getScope(), SnippetType.Type.NO_TYPE);
            }
            case OUTSIDE_RULE: {
                return new SnippetType(CSSTokenType.ELEMENT.getScope(), SnippetType.Type.CSS_OUTRULE);
            }
        }
        return null;
    }

    private boolean needIncludes(Lexeme<CSSTokenType> type) {
        if (type == null) {
            return false;
        }
        switch ((CSSTokenType)((Object)type.getType())) {
            case LCURLY: 
            case RCURLY: 
            case COLON: 
            case SEMICOLON: 
            case AT_RULE: 
            case COMMA: 
            case SLASH: 
            case STAR: 
            case WAVY: 
            case LBRACKET: 
            case PAGE: 
            case CHARSET: 
            case MEDIA_KEYWORD: 
            case FONTFACE: 
            case NAMESPACE: 
            case RBRACKET: 
            case IMPORT: 
            case PLUS: 
            case MINUS: 
            case LPAREN: 
            case RPAREN: 
            case GREATER: 
            case EQUAL: 
            case INCLUDES: 
            case DASHMATCH: 
            case BEGINS_WITH: 
            case ENDS_WITH: 
            case CONTAINS: 
            case MOZ_DOCUMENT: 
            case KEYFRAMES_KEYWORD: 
            case COMMENT: {
                return false;
            }
        }
        return true;
    }

    public void setSubDocument(IDocument subDocument) {
        this.subDocument = subDocument;
    }

    public boolean isEnableEmmet(IDocument document, int offset) {
        try {
            List<String> filterTypes = Arrays.asList("__css_string_double");
            String type = document.getPartition(offset).getType();
            if (filterTypes.contains(type)) {
                return false;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected LocationType getPredefinedLocationType() {
        return null;
    }

    public boolean isNeedComputeLocationType() {
        return this.needComputeLocationType;
    }

    public void setNeedComputeLocationType(boolean needComputeLocationType) {
        this.needComputeLocationType = needComputeLocationType;
    }
}

