/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.css.CSSFunctions;
import com.aptana.editor.css.CSSMetadataLoader;
import com.aptana.editor.css.CSSPlugin;
import java.net.URI;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IStartup;

public class CSSStartup
implements IStartup {
    private static final String CLEAN_CSS_ERROR = "CLEAN_CSS_ERROR";

    public void earlyStartup() {
        try {
            CSSMetadataLoader job = new CSSMetadataLoader();
            job.schedule();
            CSSMetadataLoader nviewjob = new CSSMetadataLoader(){

                @Override
                protected String[] getMetadataFiles() {
                    return new String[]{"/metadata/css_nview_metadata.xml"};
                }

                @Override
                protected URI getIndexLocation() {
                    return URI.create("css.metadata:/nview");
                }
            };
            nviewjob.schedule();
            CSSFunctions.init();
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.editor.css");
            boolean hasCleanCssError = prefs.getBoolean(CLEAN_CSS_ERROR, false);
            if (!hasCleanCssError) {
                Job cleanCssError = new Job("clean css error job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"\u5f00\u59cb\u6e05\u7406css\u9519\u8befmarker...");
                            ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("com.aptana.editor.css.problem", false, 2);
                            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"\u6e05\u7406css\u9519\u8befmarker\u7ed3\u675f");
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                cleanCssError.setSystem(true);
                cleanCssError.schedule();
                prefs.putBoolean(CLEAN_CSS_ERROR, true);
                try {
                    prefs.flush();
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
    }
}

