/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.css.CSSOpenDeclarationAction;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.CSSSourceViewerConfiguration;
import com.aptana.editor.css.Messages;
import com.aptana.editor.css.internal.text.CSSFoldingComputer;
import com.aptana.editor.css.outline.CSSOutlineContentProvider;
import com.aptana.editor.css.outline.CSSOutlineLabelProvider;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSSSourceEditor
extends AbstractThemeableEditor {
    public ITreeContentProvider getOutlineContentProvider() {
        return new CSSOutlineContentProvider();
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new CSSOutlineLabelProvider();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(CSSSourceEditor.getChainedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new CSSSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(CSSPlugin.getDefault().getCSSDocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{CSSPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    protected Object getOutlineElementAt(int caret) {
        if (this.hasOutlinePageCreated()) {
            return CSSOutlineContentProvider.getElementAt((IParseNode)this.getOutlinePage().getCurrentAst(), caret);
        }
        return null;
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return CSSPlugin.getDefault().getPreferenceStore();
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return CSSPlugin.getDefault().getPreferenceStore();
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new CSSFoldingComputer(this, document);
    }

    public String getContentType() {
        return "com.aptana.contenttype.css";
    }

    public void refreshOutline(IParseRootNode ast) {
        this.outlineAutoExpanded = true;
        super.refreshOutline(ast);
    }

    protected void createActions() {
        super.createActions();
        CSSOpenDeclarationAction action = new CSSOpenDeclarationAction(Messages.getResourceBundle(), (ITextEditor)this);
        action.setActionDefinitionId("com.aptana.editor.js.openDeclaration");
        this.setAction("com.aptana.editor.js.openDeclaration", (IAction)action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction action = this.getAction("com.aptana.editor.js.openDeclaration");
        if (action != null) {
            menu.appendToGroup("group.open", action);
        }
    }

    public boolean isEnableTransformChinesePunctuation(int offset, char character) {
        block4: {
            if (this.getPreferenceStore().getBoolean("CHINESE_PUNCTUATION_AUTO_TRANSFER")) break block4;
            return false;
        }
        try {
            IDocument document = this.getDocument();
            ITypedRegion region = document.getPartition(offset);
            String type = region.getType();
            if ("__css_multiline_comment".equals(type) || "__css_string_double".equals(type) || "__css_string_single".equals(type)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public char[] getChinesePunctuationCharacters() {
        return super.getChinesePunctuationCharacters();
    }
}

