/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.css.CSSCodeScannerFlex;
import com.aptana.editor.css.internal.text.rules.CSSHexColorRule;
import com.aptana.editor.css.internal.text.rules.CSSIdentifierRule;
import com.aptana.editor.css.internal.text.rules.CSSImportantRule;
import com.aptana.editor.css.internal.text.rules.CSSNumberRule;
import com.aptana.editor.css.internal.text.rules.EqualOperatorWordDetector;
import com.aptana.editor.css.internal.text.rules.IdentifierWithPrefixDetector;
import com.aptana.editor.css.internal.text.rules.KeywordIdentifierDetector;
import com.aptana.editor.css.parsing.lexer.CSSTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

@Deprecated
public class CSSCodeScannerRuleBased
extends BufferedRuleBasedScanner {
    public static final String[] KEYFRAMES_KEYWORD = new String[]{"from", "to"};
    public static final String[] MEDIA_KEYWORDS = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv", "and"};
    public static final String KEYWORD_MEDIA = "@media";
    public static final String[] FUNCTIONS = new String[]{"rgba", "rgb", "url", "attr", "counters", "counter", "linear-gradient"};
    public static final Pattern CURLY_MEDIA_PATTERN = Pattern.compile("([{}]|@media)");
    private int fCurlyState;
    private boolean fInMedia;
    protected boolean fInPropertyValue;
    protected boolean fInSelector;
    public static final VendorPropertyWordRule VENDOR_WORD_RULE = new VendorPropertyWordRule(new IdentifierWithPrefixDetector('-'), (IToken)new Token((Object)CSSTokenType.PROPERTY), true);

    public CSSCodeScannerRuleBased() {
        List<IRule> rules = this.createRules();
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private void addWordsToRule(WordRule wordRule, String[] words, CSSTokenType tokenType) {
        IToken token = this.createToken(tokenType);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            wordRule.addWord(word, token);
            ++n2;
        }
    }

    protected WordRule createAtWordsRule() {
        WordRule atRule = new WordRule((IWordDetector)new IdentifierWithPrefixDetector('@'), this.createToken(CSSTokenType.AT_RULE));
        atRule.addWord("@import", this.createToken(CSSTokenType.IMPORT));
        atRule.addWord("@page", this.createToken(CSSTokenType.PAGE));
        atRule.addWord(KEYWORD_MEDIA, this.createToken(CSSTokenType.MEDIA_KEYWORD));
        atRule.addWord("@charset", this.createToken(CSSTokenType.CHARSET));
        atRule.addWord("@font-face", this.createToken(CSSTokenType.FONTFACE));
        atRule.addWord("@namespace", this.createToken(CSSTokenType.NAMESPACE));
        return atRule;
    }

    protected CharacterMapRule createPunctuatorsRule() {
        CharacterMapRule punctuatorsRule = new CharacterMapRule();
        punctuatorsRule.add(':', this.createToken(CSSTokenType.COLON));
        punctuatorsRule.add(';', this.createToken(CSSTokenType.SEMICOLON));
        punctuatorsRule.add('{', this.createToken(CSSTokenType.LCURLY));
        punctuatorsRule.add('}', this.createToken(CSSTokenType.RCURLY));
        punctuatorsRule.add('(', this.createToken(CSSTokenType.LPAREN));
        punctuatorsRule.add(')', this.createToken(CSSTokenType.RPAREN));
        punctuatorsRule.add('%', this.createToken(CSSTokenType.PERCENTAGE));
        punctuatorsRule.add('[', this.createToken(CSSTokenType.LBRACKET));
        punctuatorsRule.add(']', this.createToken(CSSTokenType.RBRACKET));
        punctuatorsRule.add(',', this.createToken(CSSTokenType.COMMA));
        punctuatorsRule.add('+', this.createToken(CSSTokenType.PLUS));
        punctuatorsRule.add('*', this.createToken(CSSTokenType.STAR));
        punctuatorsRule.add('>', this.createToken(CSSTokenType.GREATER));
        punctuatorsRule.add('/', this.createToken(CSSTokenType.SLASH));
        punctuatorsRule.add('=', this.createToken(CSSTokenType.EQUAL));
        punctuatorsRule.add('-', this.createToken(CSSTokenType.MINUS));
        return punctuatorsRule;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('.'), this.createToken(CSSTokenType.CLASS)));
        rules.add((IRule)this.createAtWordsRule());
        rules.add((IRule)new CSSImportantRule(this.createToken(CSSTokenType.IMPORTANT)));
        rules.add((IRule)this.createVendorPropertyRules());
        WordRule punctuatorRule2 = new WordRule((IWordDetector)new EqualOperatorWordDetector(), Token.UNDEFINED);
        punctuatorRule2.addWord("~=", this.createToken(CSSTokenType.INCLUDES));
        punctuatorRule2.addWord("|=", this.createToken(CSSTokenType.DASHMATCH));
        punctuatorRule2.addWord("^=", this.createToken(CSSTokenType.BEGINS_WITH));
        punctuatorRule2.addWord("$=", this.createToken(CSSTokenType.ENDS_WITH));
        rules.add((IRule)punctuatorRule2);
        rules.add((IRule)this.createPunctuatorsRule());
        rules.add((IRule)new CSSHexColorRule(this.createToken(CSSTokenType.RGB)));
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('#'), this.createToken(CSSTokenType.ID)));
        rules.addAll(this.createScannerSpecificRules());
        rules.add((IRule)new CSSNumberRule(this.createToken(CSSTokenType.NUMBER)));
        rules.add((IRule)new CSSIdentifierRule(this.createToken(CSSTokenType.IDENTIFIER)));
        return rules;
    }

    protected Collection<? extends IRule> createScannerSpecificRules() {
        ArrayList<WordRule> rules = new ArrayList<WordRule>();
        WordRule wordRule = new WordRule((IWordDetector)new KeywordIdentifierDetector(), Token.UNDEFINED);
        wordRule.addWord("em", this.createToken(CSSTokenType.EMS));
        wordRule.addWord("ex", this.createToken(CSSTokenType.EXS));
        wordRule.addWord("px", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("cm", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("mm", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("in", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("pt", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("pc", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("rem", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("deg", this.createToken(CSSTokenType.ANGLE));
        wordRule.addWord("rad", this.createToken(CSSTokenType.ANGLE));
        wordRule.addWord("grad", this.createToken(CSSTokenType.ANGLE));
        wordRule.addWord("ms", this.createToken(CSSTokenType.TIME));
        wordRule.addWord("s", this.createToken(CSSTokenType.TIME));
        wordRule.addWord("hz", this.createToken(CSSTokenType.FREQUENCY));
        wordRule.addWord("khz", this.createToken(CSSTokenType.FREQUENCY));
        wordRule.addWord("Hz", this.createToken(CSSTokenType.FREQUENCY));
        wordRule.addWord("kHz", this.createToken(CSSTokenType.FREQUENCY));
        rules.add(wordRule);
        return rules;
    }

    protected IToken createToken(CSSTokenType type) {
        return new Token((Object)type);
    }

    protected IToken createToken(String scope) {
        return new Token((Object)scope);
    }

    private ExtendedWordRule createVendorPropertyRules() {
        return VENDOR_WORD_RULE;
    }

    protected String[] getPropertyNames() {
        return CSSCodeScannerFlex.PROPERTY_NAMES.toArray(new String[0]);
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        if (token.isEOF()) {
            return token;
        }
        Object tokenData = token.getData();
        if (CSSTokenType.MEDIA_KEYWORD == tokenData) {
            this.fInMedia = true;
            this.fCurlyState = 0;
        } else if (CSSTokenType.LCURLY == tokenData) {
            if (this.insideMedia() && this.fCurlyState == 0) {
                token = this.createToken(CSSTokenType.LCURLY_MEDIA);
            }
            ++this.fCurlyState;
        } else if (CSSTokenType.RCURLY == tokenData) {
            this.fInPropertyValue = false;
        } else if (CSSTokenType.PROPERTY == tokenData) {
            this.fInSelector = false;
        } else if (CSSTokenType.COLON == tokenData) {
            this.fInPropertyValue = true;
        } else if (CSSTokenType.CLASS == tokenData || CSSTokenType.ID == tokenData || CSSTokenType.STAR == tokenData || CSSTokenType.ELEMENT == tokenData) {
            this.fInSelector = true;
        }
        StringBuilder builder = new StringBuilder();
        if (this.insideMedia()) {
            builder.append(CSSTokenType.META_MEDIA.getScope()).append(' ');
        }
        if (this.insideRule()) {
            builder.append(CSSTokenType.META_RULE.getScope()).append(' ');
        } else if (this.fInSelector) {
            builder.append(CSSTokenType.META_SELECTOR.getScope()).append(' ');
        }
        if (this.insidePropertyValue()) {
            builder.append(CSSTokenType.META_PROPERTY_VALUE.getScope()).append(' ');
        }
        if (!this.fInPropertyValue && CSSTokenType.VALUE == tokenData) {
            token = this.createToken(CSSTokenType.PROPERTY);
        } else if (CSSTokenType.LCURLY == tokenData) {
            this.fInSelector = false;
        } else if (CSSTokenType.RCURLY == tokenData) {
            --this.fCurlyState;
            if (this.fCurlyState <= 0 && this.insideMedia()) {
                token = this.createToken(CSSTokenType.RCURLY_MEDIA);
                this.fInMedia = false;
            }
        } else if (CSSTokenType.SEMICOLON == tokenData) {
            this.fInPropertyValue = false;
        }
        if (token.isOther()) {
            tokenData = token.getData();
            if (tokenData != null) {
                if (tokenData instanceof CSSTokenType) {
                    builder.append(((CSSTokenType)((Object)tokenData)).getScope());
                } else if (tokenData instanceof String) {
                    builder.append((String)tokenData);
                }
            } else if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
        } else if (token.isWhitespace()) {
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            } else {
                return token;
            }
        }
        return this.createToken(builder.toString());
    }

    private boolean insidePropertyValue() {
        return this.fInPropertyValue;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fCurlyState = 0;
        this.fInMedia = false;
        this.fInPropertyValue = false;
        this.fInSelector = false;
        if (offset > 0) {
            String previous = null;
            try {
                ITypedRegion[] partitions;
                ITypedRegion[] iTypedRegionArray = partitions = this.fDocument.computePartitioning(0, offset);
                int n = partitions.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypedRegion region = iTypedRegionArray[n2];
                    if (!("__css_multiline_comment".equals(region.getType()) || "__css_string_double".equals(region.getType()) || "__css_string_single".equals(region.getType()))) {
                        previous = this.fDocument.get(region.getOffset(), region.getLength());
                        Matcher m = CURLY_MEDIA_PATTERN.matcher(previous);
                        while (m.find()) {
                            String found = m.group();
                            if ("{".equals(found)) {
                                ++this.fCurlyState;
                                continue;
                            }
                            if ("}".equals(found)) {
                                --this.fCurlyState;
                                if (this.fCurlyState > 0 || !this.insideMedia()) continue;
                                this.fInMedia = false;
                                continue;
                            }
                            if (!KEYWORD_MEDIA.equals(found)) continue;
                            this.fInMedia = true;
                            this.fCurlyState = 0;
                        }
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private boolean insideRule() {
        if (this.insideMedia()) {
            return this.fCurlyState > 1;
        }
        return this.fCurlyState > 0;
    }

    private boolean insideMedia() {
        return this.fInMedia;
    }

    static final class VendorPropertyWordRule
    extends ExtendedWordRule {
        private VendorPropertyWordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        public boolean wordOK(String word, ICharacterScanner scanner) {
            return word.startsWith("-moz-") || word.startsWith("-webkit-") || word.startsWith("-ms-") || word.startsWith("-o-") || word.startsWith("-atsc-") || word.startsWith("-khtml-") || word.startsWith("-wap-");
        }
    }
}

