/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.parsing.AbstractFlexTokenScanner;
import com.aptana.editor.css.CSSCodeScannerRuleBased;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.parsing.CSSColoringFlexScanner;
import com.aptana.editor.css.parsing.lexer.CSSTokenType;
import com.aptana.editor.css.parsing.lexer.CSSTokenTypeSymbol;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CSSCodeScannerFlex
extends AbstractFlexTokenScanner {
    private int fCurlyState;
    private boolean fInMedia;
    protected boolean fInColon;
    protected boolean fInProperty;
    protected boolean fInSelector;
    protected boolean fInBracket;
    protected boolean fNextAttributeValue;
    private String fContextToAppend = "";
    public static final Set<String> HTML_TAGS = CollectionsUtil.newSet((Object[])new String[0]);
    public static final Set<String> HTML_ATTRIBUTE = CollectionsUtil.newSet((Object[])new String[0]);
    public static final Set<String> PROPERTY_NAMES = CollectionsUtil.newSet((Object[])new String[0]);
    public static final Set<String> PSEUDOS = CollectionsUtil.newSet((Object[])new String[0]);
    public static final Set<String> PROPERTY_VALUES = CollectionsUtil.newSet((Object[])new String[0]);
    public static final Set<String> FUNCTIONS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.FUNCTIONS);
    public static final Set<String> FONT_NAMES = CollectionsUtil.newSet((Object[])new String[0]);
    public static final Set<String> MEDIA_KEYWORDS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.MEDIA_KEYWORDS);
    public static final Set<String> KEYFRAME_KEYWORDS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.MEDIA_KEYWORDS);
    public static final Set<String> STANDARD_COLORS = CollectionsUtil.newSet((Object[])new String[0]);
    public static final String TOKEN_NAME_HTMLTAG = "htmlTag";
    public static final String TOKEN_NAME_HTMLATTRIBUTE = "htmlAttribute";
    public static final String TOKEN_NAME_CSSPSEUDO = "cssPseudo";
    public static final String TOKEN_NAME_CSSPROPERTY = "cssProperty";
    public static final String TOKEN_NAME_COLOR = "color";
    public static final String TOKEN_NAME_CSSVALUE = "cssValue";
    public static final String TOKEN_NAME_FONT = "font";
    private boolean fInAttribute;
    private IToken tokenOnWhitespace;

    static {
        try {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            map.put(TOKEN_NAME_HTMLTAG, HTML_TAGS);
            map.put(TOKEN_NAME_HTMLATTRIBUTE, HTML_ATTRIBUTE);
            map.put(TOKEN_NAME_CSSPROPERTY, PROPERTY_NAMES);
            map.put(TOKEN_NAME_CSSPSEUDO, PSEUDOS);
            map.put(TOKEN_NAME_COLOR, STANDARD_COLORS);
            map.put(TOKEN_NAME_CSSVALUE, PROPERTY_VALUES);
            map.put(TOKEN_NAME_FONT, FONT_NAMES);
            CSSCodeScannerFlex.getTokenDefaultNames(map, (boolean)true);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
    }

    public CSSCodeScannerFlex() {
        super((Scanner)new CSSColoringFlexScanner());
    }

    public CSSCodeScannerFlex(boolean isInAttribute) {
        super((Scanner)new CSSColoringFlexScanner());
        this.fInAttribute = isInAttribute;
    }

    protected void setSource(String string) {
        ((CSSColoringFlexScanner)this.fScanner).setSource(string);
    }

    protected void setSource(char[] source, int offset, int length, int skipStart, int skipEnd) {
        ((CSSColoringFlexScanner)this.fScanner).setSource(source, offset, length, skipStart, skipEnd);
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fCurlyState = 0;
        this.fInMedia = false;
        this.fInColon = false;
        this.fInSelector = false;
        this.fInProperty = false;
        this.fInBracket = false;
        this.fNextAttributeValue = false;
        if (offset > 0 && !this.fInAttribute) {
            String previous = null;
            try {
                ITypedRegion[] partitions;
                ITypedRegion[] iTypedRegionArray = partitions = document.computePartitioning(0, offset);
                int n = partitions.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypedRegion region = iTypedRegionArray[n2];
                    if (!"__css_multiline_comment".equals(region.getType()) && !"__css_string_double".equals(region.getType()) && !"__css_string_single".equals(region.getType()) && region.getType().indexOf("__css_") >= 0 && (previous = document.get(region.getOffset(), region.getLength())).contains("@media")) {
                        Matcher m = CSSCodeScannerRuleBased.CURLY_MEDIA_PATTERN.matcher(previous);
                        while (m.find()) {
                            String found = m.group();
                            if ("{".equals(found)) {
                                ++this.fCurlyState;
                                continue;
                            }
                            if ("}".equals(found)) {
                                --this.fCurlyState;
                                if (this.fCurlyState > 0 || !this.fInMedia) continue;
                                this.fInMedia = false;
                                continue;
                            }
                            if (!"@media".equals(found)) continue;
                            this.fInMedia = true;
                            this.fCurlyState = 0;
                        }
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        this.buildContext();
    }

    protected IToken mapToken(Symbol symbol) throws IOException, Scanner.Exception {
        CSSTokenType tokenData;
        CSSTokenTypeSymbol tokenTypeSymbol = (CSSTokenTypeSymbol)symbol;
        switch (tokenTypeSymbol.token) {
            case IDENTIFIER: {
                String name = ((String)symbol.value).toLowerCase();
                if (this.fInBracket && this.fNextAttributeValue) {
                    tokenData = CSSTokenType.DOUBLE_QUOTED_STRING;
                    break;
                }
                if (HTML_TAGS.contains(name)) {
                    tokenData = CSSTokenType.ELEMENT;
                    break;
                }
                if (FUNCTIONS.contains(name)) {
                    tokenData = CSSTokenType.FUNCTION;
                    break;
                }
                if (!this.fInBracket && PROPERTY_NAMES.contains(name)) {
                    tokenData = CSSTokenType.PROPERTY;
                    break;
                }
                if (!this.fInBracket && PROPERTY_VALUES.contains(name)) {
                    tokenData = CSSTokenType.VALUE;
                    break;
                }
                if (!this.fInBracket && PSEUDOS.contains(name)) {
                    tokenData = CSSTokenType.CLASS;
                    break;
                }
                if (!this.fInBracket && STANDARD_COLORS.contains(name)) {
                    tokenData = CSSTokenType.COLOR;
                    break;
                }
                if (FONT_NAMES.contains(name)) {
                    tokenData = CSSTokenType.FONT;
                    break;
                }
                if (this.fInBracket && HTML_ATTRIBUTE.contains(name)) {
                    tokenData = CSSTokenType.PROPERTY;
                    break;
                }
                if (this.fInMedia && MEDIA_KEYWORDS.contains(name) || KEYFRAME_KEYWORDS.contains(name)) {
                    tokenData = CSSTokenType.PROPERTY;
                    break;
                }
                tokenData = CSSTokenType.IDENTIFIER;
                break;
            }
            case EOF: {
                return Token.EOF;
            }
            default: {
                tokenData = tokenTypeSymbol.token;
            }
        }
        return this.makeTokenWithContext(tokenData, false);
    }

    protected IToken getWhitespace() {
        return this.makeTokenWithContext(null, true);
    }

    protected IToken getUndefinedToken() {
        return new Token((Object)CSSTokenType.UNDEFINED.getScope());
    }

    private IToken makeTokenWithContext(CSSTokenType tokenData, boolean isWhitespace) {
        if (CSSTokenType.MEDIA_KEYWORD == tokenData) {
            this.fInMedia = true;
            this.fCurlyState = 0;
            this.buildContext();
        } else if (CSSTokenType.LCURLY == tokenData) {
            if (this.fInMedia && this.fCurlyState == 0) {
                tokenData = CSSTokenType.LCURLY_MEDIA;
            }
            ++this.fCurlyState;
            this.fInColon = false;
            this.fInProperty = true;
            this.buildContext();
        } else if (CSSTokenType.RCURLY == tokenData) {
            this.fInColon = false;
            this.fInProperty = false;
            this.buildContext();
        } else if (CSSTokenType.PROPERTY == tokenData) {
            this.fInSelector = false;
            this.buildContext();
        } else if (CSSTokenType.COLON == tokenData) {
            this.fInColon = true;
            this.buildContext();
        } else if (CSSTokenType.CLASS == tokenData || CSSTokenType.ID == tokenData || CSSTokenType.STAR == tokenData || CSSTokenType.ELEMENT == tokenData) {
            if (this.fInColon && CSSTokenType.ID == tokenData) {
                tokenData = CSSTokenType.RGB;
            } else if (this.fInProperty) {
                tokenData = CSSTokenType.IDENTIFIER;
            } else {
                this.fInSelector = true;
            }
            this.buildContext();
        } else if (CSSTokenType.LBRACKET == tokenData) {
            this.fInBracket = true;
        } else if (CSSTokenType.RBRACKET == tokenData) {
            this.fInBracket = false;
        } else if (CSSTokenType.SEMICOLON == tokenData) {
            this.fInColon = false;
        }
        if (this.fInBracket && (CSSTokenType.EQUAL == tokenData || CSSTokenType.INCLUDES == tokenData || CSSTokenType.DASHMATCH == tokenData || CSSTokenType.BEGINS_WITH == tokenData || CSSTokenType.ENDS_WITH == tokenData || CSSTokenType.CONTAINS == tokenData)) {
            this.fNextAttributeValue = true;
        } else if (tokenData != null) {
            this.fNextAttributeValue = false;
        }
        IToken ret = null;
        if (!this.fInColon && CSSTokenType.VALUE == tokenData) {
            tokenData = CSSTokenType.PROPERTY;
            ret = this.computeReturn(tokenData, isWhitespace);
            this.buildContext();
        } else if (CSSTokenType.LCURLY == tokenData) {
            this.fInSelector = false;
            ret = this.computeReturn(tokenData, isWhitespace);
            this.buildContext();
        } else if (CSSTokenType.RCURLY == tokenData) {
            --this.fCurlyState;
            if (this.fCurlyState <= 0 && this.fInMedia) {
                tokenData = CSSTokenType.RCURLY_MEDIA;
                this.fInMedia = false;
            }
            ret = this.computeReturn(tokenData, isWhitespace);
            this.buildContext();
        } else if (CSSTokenType.SEMICOLON == tokenData) {
            ret = this.computeReturn(tokenData, isWhitespace);
            this.fInColon = false;
            this.buildContext();
        } else {
            ret = this.computeReturn(tokenData, isWhitespace);
        }
        return ret;
    }

    private IToken computeReturn(CSSTokenType tokenData, boolean isWhitespace) {
        if (isWhitespace) {
            return this.tokenOnWhitespace;
        }
        if (tokenData != null) {
            String scope = tokenData.getScope();
            int contextLen = this.fContextToAppend.length();
            if (contextLen == 0) {
                return new Token((Object)scope);
            }
            int scopeLen = scope.length();
            char[] array = new char[contextLen + scopeLen];
            this.fContextToAppend.getChars(0, contextLen, array, 0);
            scope.getChars(0, scopeLen, array, contextLen);
            return new Token((Object)new String(array));
        }
        return new Token((Object)CSSTokenType.UNDEFINED.getScope());
    }

    private void buildContext() {
        StringBuilder builder = null;
        if (this.fInMedia) {
            builder = new StringBuilder(56);
            builder.append(CSSTokenType.META_MEDIA.getScope()).append(' ');
        }
        if (this.fInMedia ? this.fCurlyState > 1 : this.fCurlyState > 0) {
            builder = builder != null ? builder : new StringBuilder(56);
            builder.append(CSSTokenType.META_RULE.getScope()).append(' ');
        } else if (this.fInSelector) {
            builder = builder != null ? builder : new StringBuilder(56);
            builder.append(CSSTokenType.META_SELECTOR.getScope()).append(' ');
        }
        if (this.fInColon) {
            builder = builder != null ? builder : new StringBuilder(56);
            builder.append(CSSTokenType.META_PROPERTY_VALUE.getScope()).append(' ');
        }
        if (builder == null) {
            this.fContextToAppend = "";
            this.tokenOnWhitespace = Token.WHITESPACE;
        } else {
            this.fContextToAppend = builder.toString();
            this.tokenOnWhitespace = new Token((Object)this.fContextToAppend.substring(0, builder.length() - 1));
        }
    }
}

