/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfNode
extends Node {
    private Node condition;
    private Node thenBody;
    private Node elseBody;

    public IfNode(SourcePosition position, Node condition, Node thenBody, Node elseBody) {
        super(position);
        assert (condition != null) : "condition is not null";
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.IFNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getElseBody() {
        return this.elseBody;
    }

    public Node getThenBody() {
        return this.thenBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.condition, this.thenBody, this.elseBody);
    }
}

