/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;

class URLImageDescriptor
extends ImageDescriptor {
    private static final String FILE_PROTOCOL = "file";
    private URL url;

    URLImageDescriptor(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof URLImageDescriptor)) {
            return false;
        }
        return ((URLImageDescriptor)o).url.toExternalForm().equals(this.url.toExternalForm());
    }

    public ImageData getImageData() {
        return URLImageDescriptor.getImageData(this.url);
    }

    protected InputStream getStream() {
        try {
            return new BufferedInputStream(this.url.openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.url.toExternalForm().hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + this.url + ")";
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        try {
            return new Image(device, (ImageFileNameProvider)new URLImageFileNameProvider(this.url));
        }
        catch (SWTException sWTException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Image image = null;
        try {
            image = new Image(device, (ImageDataProvider)new URLImageDataProvider(this.url));
        }
        catch (SWTException e) {
            if (e.code != 40) {
                throw e;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (image == null && returnMissingImageOnError) {
            try {
                image = new Image(device, DEFAULT_IMAGE_DATA);
            }
            catch (SWTException nextException) {
                return null;
            }
        }
        return image;
    }

    private static URL getxURL(URL url, int zoom) {
        if (zoom <= 100) {
            return url;
        }
        if (zoom > 100 && zoom <= 150) {
            zoom = 150;
        } else if (zoom > 150) {
            zoom = 200;
        }
        String path = url.getPath();
        int dot = path.lastIndexOf(46);
        if (dot != -1 && (zoom == 150 || zoom == 200)) {
            String lead = path.substring(0, dot);
            String tail = path.substring(dot);
            if (".gif".equalsIgnoreCase(tail)) {
                tail = ".png";
            }
            String x = "@2x";
            try {
                String file = String.valueOf(lead) + x + tail;
                if (url.getQuery() != null) {
                    file = String.valueOf(file) + '?' + url.getQuery();
                }
                URL xUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
                return xUrl;
            }
            catch (MalformedURLException e) {
                Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return null;
    }

    private static String getFilePath(URL url, boolean logIOException) {
        URL locatedURL;
        block7: {
            try {
                if (InternalPolicy.OSGI_AVAILABLE) break block7;
                if (FILE_PROTOCOL.equalsIgnoreCase(url.getProtocol())) {
                    return new Path(url.getFile()).toOSString();
                }
                return null;
            }
            catch (IOException e) {
                String path;
                if (logIOException && ((path = url.getPath()).endsWith("@2x.png") || path.endsWith("@1.5x.png"))) {
                    String message = "High-resolution image missing: " + url;
                    Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", message, (Throwable)e));
                }
                return null;
            }
        }
        URL platformURL = FileLocator.find((URL)url);
        if (platformURL != null) {
            url = platformURL;
        }
        if (FILE_PROTOCOL.equalsIgnoreCase((locatedURL = FileLocator.toFileURL((URL)url)).getProtocol())) {
            return new Path(locatedURL.getPath()).toOSString();
        }
        return null;
    }

    private static ImageData getImageData(URL url) {
        ImageData result;
        block14: {
            result = null;
            InputStream in = null;
            try {
                try {
                    in = URLImageDescriptor.getStream(url);
                    if (in != null) {
                        result = new ImageData(in);
                    }
                }
                catch (SWTException e) {
                    if (e.code != 40) {
                        throw e;
                    }
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e2.getLocalizedMessage(), (Throwable)e2));
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getLocalizedMessage(), (Throwable)e));
                    }
                }
            }
        }
        return result;
    }

    private static InputStream getStream(URL url) {
        try {
            URL platformURL;
            if (InternalPolicy.OSGI_AVAILABLE && (platformURL = FileLocator.find((URL)url)) != null) {
                url = platformURL;
            }
            return new BufferedInputStream(url.openStream());
        }
        catch (IOException e) {
            String path = url.getPath();
            if (path.endsWith("@2x.png") || path.endsWith("@1.5x.png")) {
                String message = "High-resolution image missing: " + url;
                Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", message, (Throwable)e));
            }
            return null;
        }
    }

    private static class URLImageDataProvider
    implements ImageDataProvider {
        private URL url;

        public URLImageDataProvider(URL url) {
            this.url = url;
        }

        public ImageData getImageData(int zoom) {
            URL xUrl = URLImageDescriptor.getxURL(this.url, zoom);
            if (xUrl == null) {
                return null;
            }
            return URLImageDescriptor.getImageData(xUrl);
        }
    }

    private static class URLImageFileNameProvider
    implements ImageFileNameProvider {
        private URL url;

        public URLImageFileNameProvider(URL url) {
            this.url = url;
        }

        public String getImagePath(int zoom) {
            URL xUrl = URLImageDescriptor.getxURL(this.url, zoom);
            if (xUrl == null) {
                return null;
            }
            String filePath = URLImageDescriptor.getFilePath(xUrl, zoom == 100);
            if (zoom > 100 && filePath != null && !new File(filePath).exists()) {
                return null;
            }
            return filePath;
        }
    }
}

