/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui.internal.quicksearch;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileElement
extends QuickAccessElement {
    private String separator = " - ";
    private IFile file;
    WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

    public FileElement(IFile file, QuickAccessProvider provider) {
        super(provider);
        this.file = file;
    }

    public String getLabel() {
        return this.file.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        Image image = this.provider.getImage((Object)this.file);
        if (image == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    public String getId() {
        return this.file.getFullPath().toOSString();
    }

    public void execute() {
        try {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
            editorPart.setFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSortLabel() {
        return String.valueOf(this.file.getName()) + this.separator + this.file.getProject().getName() + "/" + this.file.getProjectRelativePath().toString();
    }
}

