/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui.internal.quicksearch;

import com.pandora.quicksearch.ui.QuickSearchUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class CurrentEditorElement
extends QuickAccessElement {
    private String text;
    public static final String ID = "com.pandora.quicksearch.ui.internal.quicksearch.CurrentEditorElement";

    public CurrentEditorElement(QuickAccessProvider provider, String text) {
        super(provider);
        this.text = text;
    }

    public String getLabel() {
        return this.text;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)QuickSearchUtil.PROPERTY_IMAGE);
    }

    public String getId() {
        return ID;
    }

    public void execute() {
        IFindReplaceTarget target;
        AbstractTextEditor editor;
        ISelection selection;
        AbstractTextEditor editorPart = QuickSearchUtil.getCurrentEditor();
        if (editorPart == null) {
            return;
        }
        int start = 0;
        if (editorPart instanceof AbstractTextEditor && (selection = (editor = editorPart).getSelectionProvider().getSelection()) != null && selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            start = textSelection.getOffset() + textSelection.getLength();
        }
        if ((target = (IFindReplaceTarget)editorPart.getAdapter(IFindReplaceTarget.class)) != null && target.canPerformFind()) {
            editorPart.setFocus();
            if (target instanceof IFindReplaceTargetExtension3) {
                IFindReplaceTargetExtension3 exts = (IFindReplaceTargetExtension3)target;
                int i = exts.findAndSelect(start, this.text, true, false, false, true);
                if (i == -1) {
                    start = 0;
                    i = exts.findAndSelect(start, this.text, true, false, false, true);
                }
            } else {
                int i = target.findAndSelect(start, this.text, true, false, false);
                if (i == -1) {
                    start = 0;
                    i = target.findAndSelect(start, this.text, true, false, false);
                }
            }
        }
    }

    public void setText(String text) {
        this.text = text;
    }
}

