/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui;

import com.pandora.core.index.IQuickSearchIndexQuery;
import com.pandora.core.index.QuickSearchIndexResult;
import com.pandora.core.index.QuickSearchType;
import com.pandora.quicksearch.ui.IFocusHandler;
import com.pandora.quicksearch.ui.QuickSearchActivator;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wb.swt.ResourceManager;

public class QuickSearchUtil {
    private static QuickSearchType CURRENT_SEARCH_TYPE = QuickSearchType.DEFAULT;
    public static Image DEFAULT_TYPE_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/default.png");
    public static Image CURRENT_PROJECT_TYPE_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/project.png");
    public static Image ABILITY_TYPE_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/ablity.png");
    public static Image ASK_TYPE_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/ask.png");
    public static Image PROPERTY_IMAGE = ResourceManager.getPluginImage((String)"com.pandora.quicksearch.ui", (String)"icons/property.png");
    private static IFocusHandler focusHandler;

    public static QuickSearchType getSearchType() {
        return CURRENT_SEARCH_TYPE;
    }

    public static void setSearchType(QuickSearchType type) {
        QuickSearchUtil.setSearchType(type, false);
    }

    public static void setSearchType(QuickSearchType type, boolean need) {
        CURRENT_SEARCH_TYPE = type;
        if (need && QuickSearchUtil.getFocusHandler() != null) {
            QuickSearchUtil.getFocusHandler().setPrefixText();
        }
    }

    public static void setFocusHandler(IFocusHandler fh) {
        focusHandler = fh;
    }

    public static IFocusHandler getFocusHandler() {
        return focusHandler;
    }

    public static void setFocus(boolean b) {
        if (QuickSearchUtil.getFocusHandler() != null) {
            QuickSearchUtil.getFocusHandler().setFocus(b, true);
        }
    }

    public static void setMessage(boolean b) {
        if (QuickSearchUtil.getFocusHandler() != null) {
            QuickSearchUtil.getFocusHandler().setMessage(b);
        }
    }

    public static List<QuickSearchIndexResult> getIndexResult(String fileName) {
        try {
            IExtension[] extensions;
            IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint("com.pandora.core.QuickSearch");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("quicksearch")) {
                        IQuickSearchIndexQuery quickSearchIndexQuery = (IQuickSearchIndexQuery)element.createExecutableExtension("class");
                        return quickSearchIndexQuery.getQuickSearchIndexResult(QuickSearchUtil.getSearchType(), fileName);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    public static void closeQuickSearchDialog() {
        if (QuickSearchUtil.getFocusHandler() != null) {
            QuickSearchUtil.getFocusHandler().closeDialog();
        }
    }

    public static void setForeground(Color color) {
        if (QuickSearchUtil.getFocusHandler() != null) {
            QuickSearchUtil.getFocusHandler().setForeground(color);
        }
    }

    public static IDocument getCurrentDocument() {
        IDocument document = null;
        AbstractTextEditor editor = QuickSearchUtil.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            document = documentProvider.getDocument((Object)editor.getEditorInput());
        }
        return document;
    }

    public static AbstractTextEditor getCurrentEditor() {
        IWorkbenchWindow workbenchWindow = QuickSearchActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (editorPart instanceof AbstractTextEditor) {
            AbstractTextEditor editor = (AbstractTextEditor)editorPart;
            return editor;
        }
        return null;
    }
}

