/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.pandora.core.appstream.IValue;
import com.pandora.core.utils.StreamJsonUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RefFileLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private WorkbenchLabelProvider benchLabel = new WorkbenchLabelProvider();

    public Image getImage(Object element) {
        if (element instanceof IFile) {
            return this.benchLabel.getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() != null) {
            StyledString text = this.getStyledText(cell.getElement());
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
        } else {
            cell.setText("");
            cell.setStyleRanges(null);
        }
        super.update(cell);
    }

    public StyledString getStyledText(Object element) {
        StyledString styledStr = new StyledString();
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            styledStr.append(file.getProjectRelativePath().toString());
        } else if (element instanceof IValue) {
            try {
                IValue value = (IValue)element;
                IFile file = value.getFile();
                if (file != null && file.exists()) {
                    String contents = StreamJsonUtil.getContents((IFile)file);
                    Document document = new Document(contents);
                    Point p = value.getRange();
                    int lineNum = document.getLineOfOffset(p.x);
                    IRegion region = document.getLineInformation(lineNum);
                    StyledString.Styler styler = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.background = Display.getDefault().getSystemColor(26);
                            textStyle.borderStyle = 4;
                            textStyle.borderColor = Display.getDefault().getSystemColor(2);
                            textStyle.foreground = Display.getDefault().getSystemColor(2);
                        }
                    };
                    StyledString.Styler styler0 = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.foreground = Display.getDefault().getSystemColor(16);
                        }
                    };
                    styledStr.append(lineNum + 1 + ":", styler0);
                    int length = styledStr.length();
                    styledStr.append(document.get(region.getOffset(), region.getLength()));
                    styledStr.setStyle(length + p.x - region.getOffset(), p.y - p.x, styler);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return styledStr;
    }
}

