/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.pandora.editor.ui.editors.views.IMoveableResource;
import com.pandora.editor.ui.editors.views.StreamResourceLabelProvider;
import com.pandora.editor.ui.editors.views.StreamViewerSorter;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class OtherContentTreePart
implements IMoveableResource {
    private String fTitle = null;
    private String fDesc = null;
    private TreeViewer fTreeViewer = null;
    private Map fDependencies = null;
    private Link fIdleLink = null;

    public OtherContentTreePart(String title, String desc, Map depens) {
        this.fTitle = title;
        this.fDesc = desc;
        this.fDependencies = depens;
    }

    public void createPartControl(Composite parent) {
        Group rightGroup = new Group(parent, 0);
        rightGroup.setText(this.fTitle);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)rightGroup);
        Composite toolbar = new Composite((Composite)rightGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)toolbar);
        toolbar.setLayout((Layout)new FillLayout());
        this.fIdleLink = new Link(toolbar, 64);
        this.fIdleLink.setText(this.fDesc);
        Composite comp = new Composite((Composite)rightGroup, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        comp.setLayout((Layout)treeLayout);
        this.fTreeViewer = new TreeViewer(comp, 65538);
        this.fTreeViewer.getTree().setBackground(parent.getDisplay().getSystemColor(1));
        this.fTreeViewer.setAutoExpandLevel(1);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new StreamResourceLabelProvider(this.fDependencies));
        this.fTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fTreeViewer.setSorter((ViewerSorter)new StreamViewerSorter());
    }

    public Link getIdleLink() {
        return this.fIdleLink;
    }

    public void setViewerFilter(ViewerFilter[] filters) {
        this.fTreeViewer.setFilters(filters);
    }

    public void setInput(Object input) {
        if (this.fTreeViewer.getInput() == input) {
            return;
        }
        this.fTreeViewer.setInput(input);
    }

    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    @Override
    public IResource[] getSelectionResources() {
        IStructuredSelection structSelection;
        Object[] objs;
        ISelection selection = this.fTreeViewer.getSelection();
        if (selection instanceof IStructuredSelection && (objs = (structSelection = (IStructuredSelection)selection).toArray()) != null && objs.length > 0) {
            IResource[] results = new IResource[objs.length];
            int i = 0;
            while (i < objs.length) {
                results[i] = (IResource)objs[i];
                ++i;
            }
            return results;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.fTreeViewer.refresh();
    }

    @Override
    public boolean removeResources(IResource[] resources) {
        if (resources != null) {
            boolean hasFolder = false;
            boolean hasFile = false;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder) {
                    hasFolder = true;
                } else {
                    Map idleMap;
                    hasFile = true;
                    if (this.fDependencies.containsKey("idle") && (idleMap = (Map)this.fDependencies.get("idle")).containsKey("resources")) {
                        ((List)idleMap.get("resources")).remove(res.getProjectRelativePath().toString());
                    }
                }
                ++n2;
            }
            if (hasFolder && !hasFile) {
                MessageDialog dialog = new MessageDialog(this.getControl().getShell(), "\u9875\u9762\u5f15\u7528\u5173\u7cfb", this.getControl().getShell().getImage(), "\u4e0d\u652f\u6301\u6dfb\u52a0\u76ee\u5f55\u5230\u76ee\u6807\u5217\u8868\u4e2d\u3002", 4, new String[]{"\u786e\u5b9a"}, 0);
                dialog.open();
                return false;
            }
        }
        return true;
    }

    @Override
    public IResource[] addResources(IResource[] resource) {
        return resource;
    }

    public Object getView() {
        return this.fTreeViewer;
    }
}

