/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.component.DetailedDialog;
import com.pandora.editor.ui.editors.pages.AbstractAppConfigPage;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PluginsAppConfigPage
extends AbstractAppConfigPage {
    private String rootPath;
    private Map<String, Button> pluginPathAndCheckButtonMaps = new HashMap<String, Button>();
    private Map<String, Text> pluginConfigPathAndTextMaps = new HashMap<String, Text>();

    public PluginsAppConfigPage(FormEditor editor, String id, String title, JSONObject appPageConfig) {
        super(editor, id, title, appPageConfig);
        this.rootPath = appPageConfig.optString("path");
    }

    @Override
    protected void createPageContent(IManagedForm managedForm) {
        FormToolkit formToolkit = managedForm.getToolkit();
        this.createPluginsContent(formToolkit);
        this.bindErrorDecorations(formToolkit);
    }

    private void createPluginsContent(FormToolkit formToolkit) {
        try {
            JSONArray listJsonArray = this.appPageConfig.optJSONArray("list");
            GC gc = new GC((Drawable)this.getSite().getShell().getDisplay());
            Point maxWidth = null;
            int i = 0;
            while (i < listJsonArray.size()) {
                JSONArray pluginsJsonArray = listJsonArray.getJSONObject(i).optJSONArray("plugins");
                int y = 0;
                while (y < pluginsJsonArray.size()) {
                    JSONObject pluginsJsonObject = pluginsJsonArray.getJSONObject(y);
                    JSONArray configsJsonArray = pluginsJsonObject.optJSONArray("configs");
                    if (configsJsonArray != null) {
                        int yy = 0;
                        while (yy < configsJsonArray.size()) {
                            String name = configsJsonArray.getJSONObject(yy).optString("name");
                            if (StringUtil.isNotBlank((String)name)) {
                                Point point = gc.stringExtent(configsJsonArray.getJSONObject(yy).getString("name"));
                                if (maxWidth == null || point.x > maxWidth.x) {
                                    maxWidth = point;
                                }
                            }
                            ++yy;
                        }
                    }
                    ++y;
                }
                ++i;
            }
            gc.dispose();
            i = 0;
            while (i < listJsonArray.size()) {
                try {
                    JSONObject listJsonObject = listJsonArray.getJSONObject(i);
                    String groupTitle = listJsonObject.optString("desc");
                    String pluginsPath = listJsonObject.optString("path");
                    String moduleName = listJsonObject.optString("module");
                    JSONObject hrefJsonObject = listJsonObject.optJSONObject("href");
                    final boolean isRadio = "radio".equalsIgnoreCase(listJsonObject.optString("type"));
                    Composite pluginGroup = this.createGroup(groupTitle, formToolkit);
                    Composite pluginsComposite = formToolkit.createComposite(pluginGroup, 0);
                    pluginsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                    pluginsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 20, 5, 20).spacing(0, 5).create());
                    if (hrefJsonObject != null) {
                        String url = hrefJsonObject.optString("url");
                        PluginsAppConfigPage.createLink(pluginsComposite, hrefJsonObject.optString("desc"), URI.create(url).toURL(), 0);
                    }
                    JSONArray pluginsJsonArray = listJsonObject.optJSONArray("plugins");
                    final HashMap<Button, String> groupButtonsPathMap = new HashMap<Button, String>();
                    int y = 0;
                    while (y < pluginsJsonArray.size()) {
                        JSONObject pluginsJsonObject = pluginsJsonArray.getJSONObject(y);
                        String buttonTitle = pluginsJsonObject.optString("desc");
                        String pluginPath = pluginsJsonObject.getString("path");
                        Composite pluginComposite = formToolkit.createComposite(pluginsComposite, 0);
                        pluginComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                        pluginComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                        final Button selectButton = formToolkit.createButton(pluginComposite, buttonTitle, 32);
                        String selectButtonPath = StringUtil.join((String)".", (String[])new String[]{this.rootPath, pluginsPath, pluginPath});
                        this.pluginPathAndCheckButtonMaps.put(selectButtonPath, selectButton);
                        groupButtonsPathMap.put(selectButton, selectButtonPath);
                        selectButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
                        selectButton.setData("map", groupButtonsPathMap);
                        selectButton.setData("moduleName", (Object)moduleName);
                        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (isRadio && selectButton.getSelection()) {
                                    for (Button radio : groupButtonsPathMap.keySet()) {
                                        if (e.widget == radio) continue;
                                        radio.setSelection(false);
                                        PluginsAppConfigPage.this.getEditor().getChangedPaths().add((String)groupButtonsPathMap.get(radio));
                                    }
                                }
                            }
                        });
                        Composite configComposite = formToolkit.createComposite(pluginComposite, 0);
                        configComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                        configComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).spacing(20, 10).create());
                        JSONArray configsJsonArray = pluginsJsonObject.optJSONArray("configs");
                        int yy = 0;
                        while (yy < configsJsonArray.size()) {
                            JSONObject configsJsonObject = configsJsonArray.getJSONObject(yy);
                            String configName = configsJsonObject.optString("name");
                            if (StringUtil.isBlank((String)configName)) {
                                formToolkit.createLabel(configComposite, configName, 131072).setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
                            } else {
                                String configPath = configsJsonObject.getString("path");
                                formToolkit.createLabel(configComposite, configName, 131072).setLayoutData((Object)GridDataFactory.swtDefaults().hint(maxWidth.x + 10, -1).align(0x1000008, 0x1000000).create());
                                Text configText = formToolkit.createText(configComposite, null);
                                configText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(200, -1).align(1, 0x1000000).create());
                                this.pluginConfigPathAndTextMaps.put(StringUtil.join((String)".", (String[])new String[]{this.rootPath, pluginsPath, pluginPath, configPath}), configText);
                            }
                            ++yy;
                        }
                        ++y;
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private void bindErrorDecorations(FormToolkit formToolkit) {
        for (String filedPath : this.pluginPathAndCheckButtonMaps.keySet()) {
            final Button selectButton = this.pluginPathAndCheckButtonMaps.get(filedPath);
            this.bindErrorValidation((Control)selectButton, filedPath, 0x1020000, formToolkit, new Control[]{selectButton});
            selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Map groupButtonsPathMap = (Map)selectButton.getData("map");
                    String moduleName = (String)selectButton.getData("moduleName");
                    selectButton.setData("map", (Object)groupButtonsPathMap);
                    selectButton.setData("moduleName", (Object)moduleName);
                    if (moduleName != null) {
                        boolean needFlush = false;
                        if (selectButton.getSelection()) {
                            needFlush = PluginsAppConfigPage.this.getEditor().getModulesAppConfigPage().addModuleAndPermissions(moduleName);
                        } else {
                            boolean result = false;
                            for (Button button : groupButtonsPathMap.keySet()) {
                                if (button == selectButton) continue;
                                boolean bl = result = result || button.getSelection();
                            }
                            if (!result) {
                                boolean hasModule = PluginsAppConfigPage.this.getEditor().getModulesAppConfigPage().isModuleExists(PluginsAppConfigPage.this.getManifestConfiguration(), moduleName);
                                List<String> permissions = PluginsAppConfigPage.this.getEditor().getModulesAppConfigPage().getModuleRequiredPermissions(PluginsAppConfigPage.this.getManifestConfiguration(), moduleName, false);
                                if (hasModule || !permissions.isEmpty()) {
                                    MultiStatus status = new MultiStatus("com.pandora.editor.ui", 0, "\u662f\u5426\u540c\u65f6\u53bb\u9664SDK\u9700\u8981\u7684\u6a21\u5757\u53ca\u6240\u4f7f\u7528\u7684Android\u6743\u9650\uff1f\r\n\u70b9\u51fb\u8be6\u7ec6\u4fe1\u606f\u4e86\u89e3\u5c06\u53bb\u9664\u7684\u6a21\u5757\u548cAndroid\u6743\u9650\u5217\u8868\u3002", null);
                                    status.add((IStatus)new Status(1, "com.pandora.editor.ui", "\u6a21\u5757\uff1a " + ManifastConfigurationVerification.getModuleShowName((String)moduleName)));
                                    for (String permission : permissions) {
                                        status.add((IStatus)new Status(1, "com.pandora.editor.ui", "\u6743\u9650\uff1a" + permission));
                                    }
                                    if (DetailedDialog.openConfirm(PluginsAppConfigPage.this.getSite().getShell(), "\u63d0\u9192", null, (IStatus)status) == 0) {
                                        needFlush = PluginsAppConfigPage.this.getEditor().getModulesAppConfigPage().removeModuleAndPermissions(moduleName);
                                    }
                                }
                            }
                        }
                        if (needFlush) {
                            Map infos = ManifastConfigurationVerification.verify((ManifastConfiguration)PluginsAppConfigPage.this.appConfigEditor.getManifestConfiguration(), (IProject)PluginsAppConfigPage.this.appConfigEditor.getProject(), (ManifastConfigurationVerification.VerificationPlatform)PluginsAppConfigPage.this.appConfigEditor.getPlatform());
                            PluginsAppConfigPage.this.getEditor().showAllPagesError(infos);
                        }
                    }
                }
            });
        }
        for (String filedPath : this.pluginConfigPathAndTextMaps.keySet()) {
            this.bindErrorValidation((Control)this.pluginConfigPathAndTextMaps.get(filedPath), this.pluginConfigPathAndTextMaps.get(filedPath).getParent(), Arrays.asList(filedPath), 0x1020000, formToolkit, (Control)this.pluginConfigPathAndTextMaps.get(filedPath));
        }
    }

    @Override
    public void fromModule(ManifastConfiguration manifastConfiguration) {
        for (String filedPath : this.pluginPathAndCheckButtonMaps.keySet()) {
            try {
                Object result = this.getFieldValue(manifastConfiguration, filedPath.split("\\."));
                this.pluginPathAndCheckButtonMaps.get(filedPath).setSelection(result != null);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
        for (String filedPath : this.pluginConfigPathAndTextMaps.keySet()) {
            try {
                String value = (String)this.getFieldValue(manifastConfiguration, filedPath.split("\\."));
                if (StringUtil.isNotBlank((String)value)) {
                    this.pluginConfigPathAndTextMaps.get(filedPath).setText(value);
                    continue;
                }
                this.pluginConfigPathAndTextMaps.get(filedPath).setText("");
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    @Override
    public void toModule(ManifastConfiguration manifastConfiguration) {
        for (String filedPath : this.pluginPathAndCheckButtonMaps.keySet()) {
            try {
                Button button = this.pluginPathAndCheckButtonMaps.get(filedPath);
                boolean isSelect = button.getSelection();
                if (isSelect) {
                    this.newInstanceField(manifastConfiguration, filedPath.split("\\."));
                    for (String subPath : this.pluginConfigPathAndTextMaps.keySet()) {
                        try {
                            if (!subPath.startsWith(filedPath)) continue;
                            this.setFieldValue(manifastConfiguration, this.pluginConfigPathAndTextMaps.get(subPath).getText(), subPath.split("\\."));
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                    continue;
                }
                this.setFieldValue(manifastConfiguration, null, filedPath.split("\\."));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

