/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.URIUtil;
import com.aptana.ide.ui.io.ImageUtils;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.component.BeforeModifyListener;
import com.pandora.editor.ui.editors.component.ImageSelectWidget;
import com.pandora.editor.ui.editors.component.ImageViewer;
import com.pandora.editor.ui.editors.pages.AbstractAppConfigPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.ResourceManager;

public class IconsAppConfigPage
extends AbstractAppConfigPage {
    public static final String AUTO_ICON_PATH = "AUTO_ICON_PATH_";
    public static final String REPLACE_ALL = "REPLACE_ALL";
    private QualifiedName autoIconPathQualifiedName = new QualifiedName("com.pandora.editor.ui", "AUTO_ICON_PATH_");
    private QualifiedName replaceAllQualifiedName = new QualifiedName("com.pandora.editor.ui", "REPLACE_ALL");
    private String rootPath;
    private IFolder defaultAutoIconSavePath = null;
    private ImageViewer imageViewer = new ImageViewer();
    private ImageSelectWidget autoIconImage = null;
    private Button replaceOptionsCheck;
    private Button replaceButton;
    private Text autoIconSavePathText = null;
    private Map<List<String>, ImageSelectWidget> iconAndPathsMaps = new HashMap<List<String>, ImageSelectWidget>();
    private Map<String, String> oldPaths = new HashMap<String, String>();

    public IconsAppConfigPage(FormEditor editor, String id, String title, JSONObject appPageConfig) {
        super(editor, id, title, appPageConfig);
        this.rootPath = appPageConfig.optString("path");
    }

    @Override
    protected void createPageContent(IManagedForm managedForm) {
        FormToolkit formToolkit = managedForm.getToolkit();
        this.createAutoIconContent(formToolkit);
        this.createIconGroupContent(formToolkit);
        this.addImageViewers(formToolkit);
        this.bindErrorDecorations(formToolkit);
    }

    private void createAutoIconContent(FormToolkit formToolkit) {
        Composite noticeComposite = formToolkit.createComposite(this.bodyContent);
        noticeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 10).create());
        noticeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label noticeText = new Label(noticeComposite, 72);
        noticeText.setText("\u6ce8\uff1a\u56fe\u6807\u5fc5\u987b\u4f7f\u7528png\u683c\u5f0f\u7684\u56fe\u7247\u3002\u4e0d\u652f\u6301\u5176\u4ed6\u683c\u5f0f\u7684\u56fe\u7247\u901a\u8fc7\u4fee\u6539\u540e\u7f00\u540d\u5f97\u5230\u7684png\u56fe\u7247\u3002");
        noticeText.setFont(new Font(noticeText.getFont().getDevice(), noticeText.getFont().getFontData()[0].getName(), noticeText.getFont().getFontData()[0].getHeight(), 1));
        noticeText.setForeground(Display.getDefault().getSystemColor(3));
        Composite group = this.createGroup("iOS AppStore\u9700\u8981\u76841024\u5927\u56fe\u6807\uff0c\u53ef\u7528\u4e8e\u81ea\u52a8\u751f\u6210\u6240\u6709\u9002\u7528\u56fe\u6807", formToolkit);
        Composite autoContent = formToolkit.createComposite(group, 0);
        autoContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        autoContent.setLayout((Layout)GridLayoutFactory.swtDefaults().extendedMargins(20, 20, 5, 20).numColumns(3).spacing(10, 5).create());
        Label label = formToolkit.createLabel(autoContent, "\u9009\u62e9\u6e90\u56fe\u7247:");
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).span(1, 2).create());
        formToolkit.createLabel(autoContent, "\u9009\u62e9\u4e00\u4e2a\u5927\u56fe\u6807\uff0c\u5c06\u4f1a\u81ea\u52a8\u538b\u7f29\u751f\u6210\u5404\u79cd\u5c0f\u56fe\u6807").setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        Composite imageContent = formToolkit.createComposite(autoContent, 0);
        imageContent.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).create());
        imageContent.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 5).extendedMargins(0, 0, 5, 0).create());
        this.autoIconImage = new ImageSelectWidget(imageContent, ResourceManager.getPluginImage((String)"com.pandora.editor.ui", (String)"icons/full/add_icon.png"), null, new Point(1024, 1024), 2048);
        this.autoIconImage.setLayoutData(GridDataFactory.fillDefaults().align(1, 0x1000000).hint(180, 180).create());
        formToolkit.adapt((Composite)this.autoIconImage);
        formToolkit.paintBordersFor((Composite)this.autoIconImage);
        Label sizeLabel = formToolkit.createLabel(imageContent, "\u63a8\u83501024*1024\u7684\u6b63\u65b9\u5f62\u56fe\u5f62\uff08\u5982\u4e0a\u4f20iOS AppStore\uff0c\u5219\u5fc5\u987b\u662f1024x1024\uff09", 0);
        sizeLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
        new Label(autoContent, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label = formToolkit.createLabel(autoContent, "\u9009\u62e9\u56fe\u6807\u4fdd\u5b58\u8def\u5f84:");
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.autoIconSavePathText = formToolkit.createText(autoContent, "", 0);
        this.autoIconSavePathText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(300, -1).grab(false, false).create());
        this.autoIconSavePathText.setEnabled(false);
        label = formToolkit.createLabel(autoContent, null);
        label = formToolkit.createLabel(autoContent, "\u751f\u6210\u5404\u79cd\u5206\u8fa8\u7387\u56fe\u6807 :");
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        Composite operationComposite = formToolkit.createComposite(autoContent, 0);
        operationComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        operationComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.replaceOptionsCheck = formToolkit.createButton(operationComposite, "\u5982\u679c\u6211\u624b\u52a8\u8bbe\u7f6e\u8fc7\u67d0\u4e2a\u56fe\u6807\uff0c\u8bf7\u4e0d\u7528\u81ea\u52a8\u66ff\u6362\u8be5\u56fe\u6807", 32);
        this.replaceOptionsCheck.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.replaceButton = formToolkit.createButton(operationComposite, "\u81ea\u52a8\u751f\u6210\u6240\u6709\u56fe\u6807\u5e76\u66ff\u6362", 0);
        this.replaceButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).create());
        Button openAutoIconSavePathButton = formToolkit.createButton(autoContent, "\u6d4f\u89c8\u751f\u6210\u56fe\u6807\u6240\u5728\u76ee\u5f55...", 0);
        openAutoIconSavePathButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        openAutoIconSavePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = IconsAppConfigPage.this.defaultAutoIconSavePath.getLocation().toFile().getAbsolutePath();
                File dir = new File(path);
                dir.mkdirs();
                URIUtil.open((URI)dir.toURI());
            }
        });
    }

    private void createIconGroupContent(FormToolkit formToolkit) {
        block17: {
            try {
                JSONArray listJsonArray = this.appPageConfig.optJSONArray("list");
                if (listJsonArray == null || listJsonArray.size() <= 0) break block17;
                int i = 0;
                while (i < listJsonArray.size()) {
                    try {
                        JSONArray imagesJsonArray;
                        JSONObject iconsJsonObject;
                        JSONObject listJsonObject = listJsonArray.getJSONObject(i);
                        String title = listJsonObject.optString("title");
                        String path = listJsonObject.optString("path");
                        String[] splits = path.split("\\.");
                        String iconBaseDir = "icons/hbuilder/" + splits[0] + "/icon";
                        JSONArray iconsJsonArray = listJsonObject.optJSONArray("icons");
                        Composite group = this.createGroup(title, formToolkit);
                        Composite iconConfigContent = formToolkit.createComposite(group, 0);
                        iconConfigContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                        int columnNum = 0;
                        int y = 0;
                        while (y < iconsJsonArray.size()) {
                            columnNum += iconsJsonArray.getJSONObject(y).optJSONArray("images").size();
                            ++y;
                        }
                        iconConfigContent.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(20, 20, 15, 20).spacing(30, 5).numColumns(columnNum).create());
                        y = 0;
                        while (y < iconsJsonArray.size()) {
                            iconsJsonObject = iconsJsonArray.getJSONObject(y);
                            imagesJsonArray = iconsJsonObject.optJSONArray("images");
                            Composite groupContent = formToolkit.createComposite(iconConfigContent, 0);
                            groupContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).span(imagesJsonArray.size(), 1).create());
                            groupContent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(5, 0).numColumns(imagesJsonArray.size()).spacing(15, 5).create());
                            int ii = 0;
                            while (ii < imagesJsonArray.size()) {
                                JSONObject imageJsonObject = imagesJsonArray.getJSONObject(ii);
                                int size = imageJsonObject.optInt("size");
                                Image image = ResourceManager.getPluginImage((String)"com.pandora.editor.ui", (String)(String.valueOf(iconBaseDir) + size + ".png"));
                                ImageSelectWidget iconSelectWidget = new ImageSelectWidget(groupContent, image, ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)EditorPlugin.getDefault().getBundle().getEntry(String.valueOf(iconBaseDir) + size + ".png"))), new Point(size, size), 2048);
                                int iconSelectWidgetSize = Double.valueOf(48 + ii * (imagesJsonArray.size() > 2 ? 24 : 40)).intValue();
                                iconSelectWidget.setLayoutData(GridDataFactory.fillDefaults().align(0x1000000, 0x1000008).grab(imagesJsonArray.size() == 1, true).hint(iconSelectWidgetSize, iconSelectWidgetSize).create());
                                formToolkit.adapt((Composite)iconSelectWidget);
                                formToolkit.paintBordersFor((Composite)iconSelectWidget);
                                ArrayList<String> pathList = new ArrayList<String>();
                                Object subPathsObject = imageJsonObject.get("path");
                                if (subPathsObject instanceof String) {
                                    pathList.add(StringUtil.join((String)".", (Object[])new Object[]{this.rootPath, path, subPathsObject}));
                                } else if (subPathsObject instanceof JSONArray) {
                                    JSONArray array = (JSONArray)subPathsObject;
                                    int yy = 0;
                                    while (yy < array.size()) {
                                        pathList.add(StringUtil.join((String)".", (String[])new String[]{this.rootPath, path, array.optString(yy)}));
                                        ++yy;
                                    }
                                }
                                this.iconAndPathsMaps.put(pathList, iconSelectWidget);
                                String oldPath = imageJsonObject.optString("oldPath");
                                if (StringUtil.isNotEmpty((String)oldPath)) {
                                    this.oldPaths.put("manifest." + (String)pathList.get(0), "manifest." + StringUtil.join((String)".", (String[])new String[]{this.rootPath, path, oldPath}));
                                }
                                ++ii;
                            }
                            ii = 0;
                            while (ii < imagesJsonArray.size()) {
                                int size = imagesJsonArray.getJSONObject(ii).optInt("size");
                                Label sizeLabel = formToolkit.createLabel(groupContent, String.valueOf(size) + "*" + size, 0);
                                sizeLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000008).create());
                                ++ii;
                            }
                            ++y;
                        }
                        y = 0;
                        while (y < iconsJsonArray.size()) {
                            iconsJsonObject = iconsJsonArray.getJSONObject(y);
                            imagesJsonArray = iconsJsonObject.optJSONArray("images");
                            Label separator = formToolkit.createLabel(iconConfigContent, "", 258);
                            separator.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).span(imagesJsonArray.size(), 1).create());
                            ++y;
                        }
                        y = 0;
                        while (y < iconsJsonArray.size()) {
                            iconsJsonObject = iconsJsonArray.getJSONObject(y);
                            imagesJsonArray = iconsJsonObject.optJSONArray("images");
                            JSONArray descs = iconsJsonObject.optJSONArray("desc");
                            Composite descContent = formToolkit.createComposite(iconConfigContent, 0);
                            descContent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).span(imagesJsonArray.size(), 1).create());
                            descContent.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 5).create());
                            int ii = 0;
                            while (ii < descs.size()) {
                                String desc = descs.optString(ii);
                                Label descLabel = formToolkit.createLabel(descContent, desc);
                                descLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).grab(true, true).create());
                                ++ii;
                            }
                            ++y;
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private void addImageViewers(FormToolkit formToolkit) {
        try {
            this.autoIconImage.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent e) {
                    if (!IconsAppConfigPage.this.autoIconImage.isDefault() && IconsAppConfigPage.this.autoIconImage.isExist()) {
                        IconsAppConfigPage.this.imageViewer.show((Control)IconsAppConfigPage.this.autoIconImage, IconsAppConfigPage.this.autoIconImage.getImagePath());
                    }
                }

                public void mouseExit(MouseEvent e) {
                    IconsAppConfigPage.this.imageViewer.close(IconsAppConfigPage.this.autoIconImage.toDisplay(e.x, e.y));
                }
            });
            for (final ImageSelectWidget imageSelectWidget : this.iconAndPathsMaps.values()) {
                imageSelectWidget.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseHover(MouseEvent e) {
                        if (!imageSelectWidget.isDefault() && imageSelectWidget.isExist()) {
                            IconsAppConfigPage.this.imageViewer.show((Control)imageSelectWidget, imageSelectWidget.getImagePath());
                        } else if (imageSelectWidget.isDefault()) {
                            IconsAppConfigPage.this.imageViewer.show((Control)imageSelectWidget, imageSelectWidget.getDefaultImageUrl());
                        }
                    }

                    public void mouseExit(MouseEvent e) {
                        IconsAppConfigPage.this.imageViewer.close(imageSelectWidget.toDisplay(e.x, e.y));
                    }
                });
            }
        }
        catch (Throwable ex) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
        }
    }

    private void bindErrorDecorations(FormToolkit formToolkit) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.pandora.editor.ui");
        this.bindAutoIconImage(prefs);
        this.bindAutoIconSavePath(prefs);
        for (List<String> filedPaths : this.iconAndPathsMaps.keySet()) {
            this.bindErrorValidation((Control)this.iconAndPathsMaps.get(filedPaths), this.iconAndPathsMaps.get(filedPaths).getParent(), filedPaths, 16512, formToolkit, (Control)this.iconAndPathsMaps.get(filedPaths));
        }
    }

    private void bindAutoIconImage(IEclipsePreferences prefs) {
        File autoPath;
        String autoIconPathStr = null;
        try {
            autoIconPathStr = this.getEditor().getProject().getPersistentProperty(this.autoIconPathQualifiedName);
        }
        catch (CoreException ex) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
        }
        if (autoIconPathStr == null) {
            autoIconPathStr = prefs.get(AUTO_ICON_PATH + this.appConfigEditor.getProject().getName(), null);
        }
        if ((autoPath = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)this.getEditor().getProject(), (String)autoIconPathStr)) != null) {
            this.autoIconImage.setImagePath(autoPath.getAbsolutePath());
        }
        this.oldPaths.put("manifest.plus.distribute.icons.ios.appstore", "manifest.plus.distribute.icons.ios.auto");
        this.iconAndPathsMaps.put(Arrays.asList("plus.distribute.icons.ios.appstore"), this.autoIconImage);
        this.autoIconImage.addBeforeModifyListener(new BeforeModifyListener(){

            @Override
            public boolean beforeModify(ModifyEvent e) {
                try {
                    boolean success;
                    block12: {
                        success = false;
                        String path = (String)e.data;
                        File autoIconFile = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)IconsAppConfigPage.this.getEditor().getProject(), (String)path);
                        if (autoIconFile != null && autoIconFile.exists() && autoIconFile.isFile()) {
                            Image image = null;
                            try {
                                try {
                                    image = new Image((Device)IconsAppConfigPage.this.getSite().getShell().getDisplay(), autoIconFile.getAbsolutePath());
                                    success = true;
                                }
                                catch (Throwable ex) {
                                    MessageDialog.openError((Shell)IconsAppConfigPage.this.getSite().getShell(), (String)"\u9519\u8bef", (String)"\u9009\u62e9\u7684\u6587\u4ef6\u4e0d\u662f\u5408\u6cd5\u7684\u56fe\u6807\u6587\u4ef6\uff01");
                                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                                    if (image != null && !image.isDisposed()) {
                                        image.dispose();
                                    }
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                if (image != null && !image.isDisposed()) {
                                    image.dispose();
                                }
                                throw throwable;
                            }
                            if (image != null && !image.isDisposed()) {
                                image.dispose();
                            }
                        }
                    }
                    if (!success) {
                        return success;
                    }
                }
                catch (Throwable ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
                return true;
            }
        });
        this.autoIconImage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    IconsAppConfigPage.this.getEditor().getProject().setPersistentProperty(IconsAppConfigPage.this.autoIconPathQualifiedName, IconsAppConfigPage.this.getProjectRelativePath(IconsAppConfigPage.this.autoIconImage.getImagePath()));
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        String replaceAllStr = null;
        try {
            replaceAllStr = this.getEditor().getProject().getPersistentProperty(this.replaceAllQualifiedName);
        }
        catch (CoreException ex) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
        }
        if (replaceAllStr == null) {
            replaceAllStr = prefs.get(REPLACE_ALL + this.appConfigEditor.getProject().getName(), null);
        }
        boolean replaceAll = Boolean.parseBoolean(replaceAllStr);
        this.replaceOptionsCheck.setSelection(replaceAll);
        this.replaceOptionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IconsAppConfigPage.this.getEditor().getProject().setPersistentProperty(IconsAppConfigPage.this.replaceAllQualifiedName, String.valueOf(IconsAppConfigPage.this.replaceOptionsCheck.getSelection()));
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        this.replaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final File autoIconFile = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)IconsAppConfigPage.this.getEditor().getProject(), (String)IconsAppConfigPage.this.autoIconImage.getImagePath());
                if (autoIconFile == null || !autoIconFile.exists()) {
                    MessageDialog.openInformation((Shell)IconsAppConfigPage.this.getSite().getShell(), (String)"\u63d0\u9192", (String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6e90\u56fe\u7247\uff01");
                    return;
                }
                String savePath = IconsAppConfigPage.this.defaultAutoIconSavePath.getLocation().toFile().getAbsolutePath();
                final File savePathFile = new File(savePath);
                if (savePathFile.exists() && savePathFile.isFile() || !savePathFile.exists() && !savePathFile.mkdirs()) {
                    MessageDialog.openError((Shell)IconsAppConfigPage.this.getSite().getShell(), (String)"\u9519\u8bef", (String)"\u65e0\u6cd5\u4fdd\u5b58\u81ea\u52a8\u751f\u6210\u7684\u56fe\u6807\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u7684\u4fdd\u5b58\u8def\u5f84\u662f\u5426\u6b63\u786e");
                    return;
                }
                final boolean resplaeCheck = IconsAppConfigPage.this.replaceOptionsCheck.getSelection();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("\u6b63\u5728\u751f\u6210\u56fe\u6807...", IconsAppConfigPage.this.iconAndPathsMaps.size() + 1);
                        for (final ImageSelectWidget imageWidget : IconsAppConfigPage.this.iconAndPathsMaps.values()) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (resplaeCheck && !imageWidget.isDefault() && imageWidget.isExist()) {
                                monitor.worked(1);
                                continue;
                            }
                            try {
                                Point size = imageWidget.getValidPoint();
                                final File dstFile = new File(savePathFile, String.valueOf(size.x) + "x" + size.y + ".png");
                                ImageUtils.scaleImage((File)autoIconFile, (File)dstFile, (int)size.x, (int)size.y);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        imageWidget.setImagePath(dstFile.getAbsolutePath());
                                    }
                                });
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                            }
                            monitor.worked(1);
                        }
                        try {
                            File dstFile = new File(savePathFile, "256x256.png");
                            ImageUtils.scaleImage((File)autoIconFile, (File)dstFile, (int)256, (int)256);
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                        }
                        monitor.worked(1);
                        try {
                            IconsAppConfigPage.this.defaultAutoIconSavePath.refreshLocal(0, monitor);
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                        }
                        monitor.done();
                    }
                };
                try {
                    new ProgressMonitorDialog(IconsAppConfigPage.this.getSite().getShell()).run(true, true, runnable);
                }
                catch (Throwable ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
    }

    private void bindAutoIconSavePath(IEclipsePreferences prefs) {
        try {
            this.defaultAutoIconSavePath = ResourceUtil.getAppProjectResDir((IProject)this.getEditor().getProject(), (String[])new String[]{"icons"});
            this.autoIconSavePathText.setText(this.getProjectRelativePath(this.defaultAutoIconSavePath.getLocation().toString()));
        }
        catch (Throwable ex) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
        }
    }

    @Override
    public void fromModule(ManifastConfiguration manifastConfiguration) {
        for (List<String> filedPaths : this.iconAndPathsMaps.keySet()) {
            try {
                String[] pathSplit = filedPaths.get(0).split("\\.");
                String imageFile = (String)this.getFieldValue(manifastConfiguration, pathSplit);
                if (StringUtil.isNotBlank((String)imageFile)) {
                    imageFile = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)this.getEditor().getProject(), (String)imageFile).getAbsolutePath();
                }
                if (this.iconAndPathsMaps.get(filedPaths) == this.autoIconImage && StringUtil.isEmpty((String)imageFile) && StringUtil.isNotEmpty((String)this.autoIconImage.getImagePath())) {
                    this.setFieldValue(manifastConfiguration, this.getProjectRelativePath(this.autoIconImage.getImagePath()), pathSplit);
                    continue;
                }
                this.iconAndPathsMaps.get(filedPaths).setImagePath(imageFile);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    @Override
    public void toModule(ManifastConfiguration manifastConfiguration) {
        for (List<String> filedPaths : this.iconAndPathsMaps.keySet()) {
            String imagePath = this.getProjectRelativePath(this.iconAndPathsMaps.get(filedPaths).getImagePath());
            for (String filedPath : filedPaths) {
                this.setFieldValue(manifastConfiguration, imagePath, filedPath.split("\\."));
            }
        }
    }

    @Override
    protected void recordChangeAndVilidation(List<String> paths) {
        if (this.modelInited) {
            for (String path : paths) {
                if (!this.oldPaths.containsKey(path)) continue;
                this.appConfigEditor.getChangedPaths().add(this.oldPaths.get(path));
            }
        }
        super.recordChangeAndVilidation(paths);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.imageViewer != null) {
            this.imageViewer.dispose();
        }
    }
}

