/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.editor.ui.editors.listener.ConfirmedDependencerListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ConfirmedDependencer {
    private static Map<IProject, ConfirmedDependencerListener> listeners = new HashMap<IProject, ConfirmedDependencerListener>();
    private IProject project;

    public ConfirmedDependencer(IProject project) {
        this.project = project;
    }

    public void add(Map map) {
        if (CollectionsUtil.isEmpty((Map)map)) {
            return;
        }
        Map comfirmedDependencesMap = this.getConfirmedDependences();
        if (CollectionsUtil.isEmpty((Map)comfirmedDependencesMap)) {
            comfirmedDependencesMap = new LinkedTreeMap();
        }
        Set keySet = map.keySet();
        boolean isAdded = false;
        for (String key : keySet) {
            Map rrmap = (Map)map.get(key);
            if (CollectionsUtil.isEmpty((Map)rrmap)) continue;
            Map frrMap = (Map)comfirmedDependencesMap.get(key);
            if (CollectionsUtil.isEmpty((Map)frrMap)) {
                frrMap = new LinkedTreeMap();
                comfirmedDependencesMap.put(key, frrMap);
            }
            isAdded = this.addFromMap("resources", rrmap, frrMap) ? true : isAdded;
            boolean bl = isAdded = this.addFromMap("refer", rrmap, frrMap) ? true : isAdded;
        }
        if (isAdded) {
            this.save(comfirmedDependencesMap, true);
        }
    }

    private boolean addFromMap(String key, Map rrmap, Map frrMap) {
        Collection rrList = (Collection)rrmap.get(key);
        if (CollectionsUtil.isEmpty((Collection)rrList)) {
            return false;
        }
        boolean b = false;
        ArrayList<String> frrList = (ArrayList<String>)frrMap.get(key);
        if (CollectionsUtil.isEmpty((Collection)frrList)) {
            frrList = new ArrayList<String>();
            frrMap.put(key, frrList);
            b = frrList.addAll(rrList);
        } else {
            for (String string : rrList) {
                if (!StringUtil.isNotBlank((String)string) || frrList.contains(string)) continue;
                frrList.add(string);
                b = true;
            }
        }
        return b;
    }

    public void add(String key, Map map) {
        Map frrMap;
        if (StringUtil.isBlank((String)key) || CollectionsUtil.isEmpty((Map)map)) {
            return;
        }
        Map comfirmedDependencesMap = this.getConfirmedDependences();
        if (CollectionsUtil.isEmpty((Map)comfirmedDependencesMap)) {
            comfirmedDependencesMap = new LinkedTreeMap();
        }
        if (CollectionsUtil.isEmpty((Map)(frrMap = (Map)comfirmedDependencesMap.get(key)))) {
            frrMap = new LinkedTreeMap();
            comfirmedDependencesMap.put(key, frrMap);
        }
        boolean isAdded = this.addFromMap("resources", map, frrMap);
        boolean bl = isAdded = this.addFromMap("refer", map, frrMap) ? true : isAdded;
        if (isAdded) {
            this.save(comfirmedDependencesMap, true);
        }
    }

    public void addResource(String key, List<String> list) {
        this.addResourceOrRefer("resources", key, list);
    }

    public void addRefer(String key, List<String> list) {
        this.addResourceOrRefer("refer", key, list);
    }

    private void addResourceOrRefer(String type, String key, List<String> list) {
        Map frrMap;
        if (StringUtil.isBlank((String)key) || CollectionsUtil.isEmpty(list)) {
            return;
        }
        Map comfirmedDependencesMap = this.getConfirmedDependences();
        if (CollectionsUtil.isEmpty((Map)comfirmedDependencesMap)) {
            comfirmedDependencesMap = new LinkedTreeMap();
        }
        if (CollectionsUtil.isEmpty((Map)(frrMap = (Map)comfirmedDependencesMap.get(key)))) {
            frrMap = new LinkedTreeMap();
            comfirmedDependencesMap.put(key, frrMap);
        }
        ArrayList<String> frrList = (ArrayList<String>)frrMap.get(type);
        boolean b = false;
        if (CollectionsUtil.isEmpty((Collection)frrList)) {
            frrList = new ArrayList<String>();
            frrMap.put(type, frrList);
            b = frrList.addAll(list);
        } else {
            for (String string : list) {
                if (!StringUtil.isNotBlank((String)string) || frrList.contains(string)) continue;
                frrList.add(string);
                b = true;
            }
        }
        if (b) {
            this.save(comfirmedDependencesMap, true);
        }
    }

    public Map getConfirmedDependences() {
        IFile file = this.getFile();
        if (!file.exists()) {
            return null;
        }
        String content = StreamJsonUtil.getContents((IFile)file);
        if (StringUtil.isBlank((String)content)) {
            return null;
        }
        Gson gson = StreamJsonUtil.createGson();
        return (Map)gson.fromJson(content, Map.class);
    }

    public void save(Map map, boolean needNotify) {
        this.save(map);
        if (needNotify && ConfirmedDependencer.getListener(this.getProject()) != null) {
            ConfirmedDependencer.getListener(this.getProject()).postChange();
        }
    }

    public void save(Map map) {
        if (CollectionsUtil.isEmpty((Map)map)) {
            return;
        }
        Gson gson = StreamJsonUtil.createGson();
        String content = StreamJsonUtil.toJson((Gson)gson, (Object)map);
        this.save(content);
    }

    public synchronized void save(String content) {
        block13: {
            if (StringUtil.isBlank((String)content)) {
                return;
            }
            ByteArrayInputStream sbStream = new ByteArrayInputStream(content.getBytes());
            try {
                try {
                    IFile file = this.getFile();
                    if (file.exists()) {
                        file.setContents((InputStream)sbStream, true, true, (IProgressMonitor)new NullProgressMonitor());
                        break block13;
                    }
                    file.create((InputStream)sbStream, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)sbStream).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    ((InputStream)sbStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public IFile getFile() {
        IFolder folder = this.getProject().getFolder("unpackage");
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.getProject().getFile("unpackage/.confirmed_dependencies");
    }

    public IProject getProject() {
        return this.project;
    }

    public static ConfirmedDependencerListener getListener(IProject project) {
        if (project == null) {
            return null;
        }
        return listeners.get(project);
    }

    public static void setListener(IProject project, ConfirmedDependencerListener cdl) {
        if (project == null || cdl == null) {
            return;
        }
        listeners.put(project, cdl);
    }

    public static void removeListener(IProject project) {
        if (project == null) {
            return;
        }
        listeners.remove(project);
    }
}

