/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors;

import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.index.core.build.BuildContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.editor.ui.EditorPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class ManifestGsonValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.pandora.editor.ui.editors.ManifestGsonValidator";
    private static final String JSON_PROBLEM_MARKER_TYPE = "com.aptana.editor.manifest.problem";
    private Pattern pattern = Pattern.compile("line\\s(\\d+)\\scolumn\\s(\\d+)");

    public void initContext(BuildContext context) {
        if (!this.needValidation(context)) {
            return;
        }
        List problems = Collections.emptyList();
        context.putProblems(JSON_PROBLEM_MARKER_TYPE, problems);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (!this.needValidation(context)) {
            return;
        }
        try {
            ArrayList<IProblem> problems = new ArrayList<IProblem>();
            IProblem problem = this.parserWithGson(context);
            if (problem != null) {
                problems.add(problem);
            }
            context.putProblems(JSON_PROBLEM_MARKER_TYPE, problems);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected IProblem parserWithGson(BuildContext context) {
        block7: {
            String content = null;
            try {
                content = context.getContents();
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                gson.fromJson(content, ManifastConfiguration.class);
            }
            catch (JsonSyntaxException e) {
                if (!(e.getCause() instanceof IllegalStateException)) break block7;
                try {
                    Matcher matcher = this.pattern.matcher(e.getMessage());
                    if (matcher.find()) {
                        int line = Integer.parseInt(matcher.group(1));
                        int column = Integer.parseInt(matcher.group(2)) - 2;
                        try {
                            int offset = new Document(content).getLineOffset(line - 1) + column;
                            return this.createError(e.getCause().getMessage().replace("BEGIN_", ""), line, offset, 1, context.getURI().toString());
                        }
                        catch (BadLocationException ex) {
                            IdeLog.logError((Plugin)JSONPlugin.getDefault(), (Throwable)ex);
                        }
                    }
                }
                catch (Throwable ex) {
                    IdeLog.logError((Plugin)JSONPlugin.getDefault(), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (!this.needValidation(context)) {
            return;
        }
        context.removeProblems(JSON_PROBLEM_MARKER_TYPE);
    }

    protected boolean needValidation(BuildContext context) {
        if (context == null || context.getFile() == null || !(context.getFile().getParent() instanceof IProject) || !"manifest.json".equals(context.getFile().getName())) {
            return false;
        }
        Collection jsonProblems = (Collection)context.getProblems().get(JSON_PROBLEM_MARKER_TYPE);
        return jsonProblems == null || jsonProblems.isEmpty();
    }
}

