/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.actions.ValidatorHandler;
import com.aptana.editor.json.JSONUtils;
import com.aptana.editor.json.parsing.ast.JSONCommaNode;
import com.aptana.editor.json.parsing.ast.JSONEntryNode;
import com.aptana.editor.json.parsing.ast.JSONNode;
import com.aptana.editor.json.parsing.ast.JSONParseRootNode;
import com.aptana.editor.json.parsing.ast.JSONTreeWalker;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.UIUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.permission.NativeUI;
import com.pandora.core.mobile.model.permission.Navigator;
import com.pandora.core.mobile.model.permission.Permission;
import com.pandora.core.mobile.model.permission.Webview;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.ReflectUtils;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.JSONSourceEditor;
import com.pandora.editor.ui.editors.Messages;
import com.pandora.editor.ui.editors.pages.AbstractAppConfigPage;
import com.pandora.editor.ui.editors.pages.AppStreamConfigPage;
import com.pandora.editor.ui.editors.pages.BasicInfoAppConfigPage;
import com.pandora.editor.ui.editors.pages.IconsAppConfigPage;
import com.pandora.editor.ui.editors.pages.JSONSourcePage;
import com.pandora.editor.ui.editors.pages.ModulesAppConfigPage;
import com.pandora.editor.ui.editors.pages.PluginsAppConfigPage;
import com.pandora.editor.ui.editors.pages.SplashsAppConfigPage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AppConfigEditor
extends FormEditor
implements IResourceChangeListener {
    public static final String EDITOR_ID = "com.pandora.editor.ui.editors.AppConfigEditor";
    private Gson gson = null;
    private boolean isPropertyChanged = false;
    private boolean syntaxError = false;
    private boolean needValidation = true;
    private ManifastConfigurationVerification.VerificationPlatform platform = ManifastConfigurationVerification.VerificationPlatform.ALL;
    private IProject project = null;
    private BasicInfoAppConfigPage basicInfoAppConfigPage;
    private IconsAppConfigPage iconsAppConfigPage;
    private SplashsAppConfigPage splashsAppConfigPage;
    private PluginsAppConfigPage pluginsAppConfigPage;
    private ModulesAppConfigPage modulesAppConfigPage;
    private AppStreamConfigPage fStreamPage;
    private JSONSourcePage jsonPage = null;
    private JSONSourceEditor sourceEditor = null;
    private int sourceEditorIndex = -1;
    private int fResourceDependenciesIndex = -1;
    private int currentEditorIndex = -1;
    private IFileEditorInput fileInput = null;
    private ManifastConfiguration manifastConfiguration = null;
    private Set<String> changedPaths = new HashSet<String>();

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)Messages.AppConfigEditor_0);
        if (input instanceof IFileEditorInput) {
            this.gson = new GsonBuilder().disableHtmlEscaping().create();
            this.fileInput = (IFileEditorInput)input;
            this.setPartName(this.fileInput.getName());
            if (this.fileInput.getFile() != null) {
                this.project = this.fileInput.getFile().getProject();
                HMobileProject hMobileProject = null;
                try {
                    hMobileProject = ProjectUtils.convertToHMobile((IProject)this.project);
                    if (hMobileProject != null) {
                        this.manifastConfiguration = hMobileProject.getAppConfigWithError();
                        String text = FileUtils.readFileToString((File)this.fileInput.getFile().getLocation().makeAbsolute().toFile());
                        ParseResult parseResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.json", (String)text);
                        if (parseResult == null || !parseResult.getErrors().isEmpty() || parseResult.getRootNode() == null) {
                            this.syntaxError = true;
                        }
                    }
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    this.syntaxError = true;
                    if (hMobileProject != null) {
                        this.manifastConfiguration = hMobileProject.getAppConfig();
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                }
            }
        }
    }

    protected void addPages() {
        try {
            boolean profile;
            boolean bl = profile = Profile.STARTUP;
            if (profile) {
                Profile.logEnter((String)"addPages");
            }
            this.basicInfoAppConfigPage = this.addAppConfigPage(new BasicInfoAppConfigPage(this, "com.pandora.editor.appconfig.basic", "\u5e94\u7528\u4fe1\u606f", "manifest\u914d\u7f6e\u6307\u5357", new URL("http://ask.dcloud.net.cn/article/94"), null));
            this.iconsAppConfigPage = this.addAppConfigPage(new IconsAppConfigPage(this, "com.pandora.editor.appconfig.icon", "\u56fe\u6807\u914d\u7f6e", this.getConfigJson("/config/appeditor_icon.json")));
            this.splashsAppConfigPage = this.addAppConfigPage(new SplashsAppConfigPage(this, "com.pandora.editor.appconfig.splash", "\u542f\u52a8\u56fe\u7247(splash)\u914d\u7f6e", this.getConfigJson("/config/appeditor_splash.json")));
            this.pluginsAppConfigPage = this.addAppConfigPage(new PluginsAppConfigPage(this, "com.pandora.editor.appconfig.plugin", "SDK\u914d\u7f6e", this.getConfigJson("/config/appeditor_plugin.json")));
            this.modulesAppConfigPage = this.addAppConfigPage(new ModulesAppConfigPage(this, "com.pandora.editor.appconfig.module", "\u6a21\u5757\u6743\u9650\u914d\u7f6e", "\u4e3a\u4ec0\u4e48\u8981\u914d\u7f6e\u6a21\u5757\u4e0e\u6743\u9650", new URL("http://ask.dcloud.net.cn/article/255"), this.getConfigJson("/config/appeditor_permission.json")));
            this.fStreamPage = new AppStreamConfigPage(this, "com.pandora.editor.appstream", "\u9875\u9762\u5f15\u7528\u5173\u7cfb");
            this.fResourceDependenciesIndex = this.addPage((IFormPage)this.fStreamPage);
            this.fStreamPage.setIndex(this.fResourceDependenciesIndex);
            if (this.fileInput != null) {
                this.sourceEditor = new JSONSourceEditor(this);
                this.jsonPage = new JSONSourcePage(this, "com.pandora.editor.appconfig.jsonsource", "\u4ee3\u7801\u89c6\u56fe", this.sourceEditor);
                this.jsonPage.init(this.createSite((IEditorPart)this.jsonPage.getSourceEditor()), (IEditorInput)this.fileInput);
                this.sourceEditorIndex = this.addPage((IFormPage)this.jsonPage);
            }
            if (profile) {
                Profile.logExit((String)"addPages");
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
        this.setDirty(false);
        this.settingTabFolderStyle();
        if (this.syntaxError) {
            this.showSyntaxError(true);
        }
    }

    protected void showSyntaxError(boolean alertSyntaxError) {
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.setPageImage(this.sourceEditorIndex, errorImage);
        if (this.getActivePage() != this.sourceEditorIndex) {
            this.setActivePage(this.sourceEditorIndex);
        }
        if (alertSyntaxError) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Platform.isRunning()) {
                        MessageDialog.openInformation((Shell)UIUtils.getActiveShell(), (String)"\u9519\u8bef\u63d0\u793a", (String)"manifest.json\u6587\u4ef6\u8bed\u6cd5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9");
                    }
                }
            });
            new ValidatorHandler().validateEditor((IEditorPart)this.sourceEditor);
        }
    }

    protected void removeSyntaxError() {
        this.setPageImage(this.sourceEditorIndex, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject getConfigJson(String path) {
        JSONObject jSONObject;
        InputStream configFileInput = null;
        try {
            URL url = EditorPlugin.getDefault().getBundle().getResource(path);
            configFileInput = url.openStream();
            jSONObject = new JSONObject(configFileInput);
        }
        catch (Exception e) {
            try {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(configFileInput);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)configFileInput);
            return null;
        }
        IOUtils.closeQuietly((InputStream)configFileInput);
        return jSONObject;
    }

    private <T extends AbstractAppConfigPage> T addAppConfigPage(T basicPage) throws MalformedURLException, JSONException, PartInitException {
        int index = this.addPage((IFormPage)basicPage);
        basicPage.setPageIndex(index);
        return basicPage;
    }

    public void setPageImage(int pageIndex, Image image) {
        super.setPageImage(pageIndex, image);
    }

    protected void pageChange(int newPageIndex) {
        Permission permission;
        boolean profile;
        boolean bl = profile = Profile.STARTUP;
        if (profile) {
            Profile.logEnter((String)"pageChange", (String)String.valueOf(newPageIndex));
        }
        if (this.syntaxError && newPageIndex != this.sourceEditorIndex) {
            this.showSyntaxError(true);
            return;
        }
        if (this.manifastConfiguration != null && this.manifastConfiguration.getPermissions() != null && (permission = this.manifastConfiguration.getPermissions()).getUi() != null) {
            this.getChangedPaths().add("permissions.UI");
            if (permission.getNativeUI() == null) {
                permission.setNativeUI(new NativeUI());
                this.getChangedPaths().add("permissions.NativeUI");
            }
            if (permission.getNavigator() == null) {
                permission.setNavigator(new Navigator());
                this.getChangedPaths().add("permissions.Navigator");
            }
            if (permission.getWebview() == null) {
                permission.setWebview(new Webview());
                this.getChangedPaths().add("permissions.Webview");
            }
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        boolean dirty = false;
        if (newPageIndex == this.sourceEditorIndex) {
            if (this.sourceEditor != null) {
                try {
                    this.jsonPage.setActionsEnable(true);
                    this.changeManifastConfigurationDocument();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                }
            }
        } else if (newPageIndex == this.fResourceDependenciesIndex) {
            if (this.sourceEditor == null) {
                return;
            }
            this.fStreamPage.activated();
        }
        super.pageChange(newPageIndex);
        if (newPageIndex != this.sourceEditorIndex) {
            try {
                this.jsonPage.setActionsEnable(false);
                Object object = this.pages.get(newPageIndex);
                if (object instanceof AbstractAppConfigPage) {
                    AbstractAppConfigPage page = (AbstractAppConfigPage)((Object)object);
                    page.setModelInited(false);
                    if (this.currentEditorIndex == this.sourceEditorIndex) {
                        String content = this.sourceEditor.getDocument().get();
                        ManifastConfiguration config = (ManifastConfiguration)this.gson.fromJson(content, ManifastConfiguration.class);
                        this.copyProperties(this.manifastConfiguration, config);
                    }
                    page.fromModule(this.manifastConfiguration);
                    if (this.needValidation) {
                        page.validation(null, true);
                    }
                    page.setModelInited(true);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
        this.currentEditorIndex = newPageIndex;
        dirty = this.isDirty();
        if (!dirty) {
            this.setDirty(false);
        }
        if (profile) {
            Profile.logExit((String)"pageChange", (String)String.valueOf(newPageIndex));
        }
    }

    public IDocument getSourceDocument() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getDocument();
    }

    protected void formatSourceDocument(final int start, final int length, final String content) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDocument document = AppConfigEditor.this.sourceEditor.getDocument();
                    String str = content.replace("\n", "\n\t");
                    document.replace(start, length, str);
                    ISourceViewer viewer = AppConfigEditor.this.sourceEditor.getISourceViewer();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void updateManifestJSON(Map dependencies) throws Exception {
        Map sourceMap = (Map)new Gson().fromJson(this.getSourceDocument().get(), Map.class);
        if (sourceMap.containsKey("dependencies")) {
            this.updateManifestJSON(dependencies, false);
        } else {
            this.updateManifestJSON(dependencies, true);
        }
    }

    public void updateManifestJSON(Map map, boolean create) throws Exception {
        JSONParseRootNode root = (JSONParseRootNode)this.sourceEditor.getAST().getRootNode();
        Gson gson = StreamJsonUtil.createGson();
        StringBuffer sBuffer = new StringBuffer();
        if (create) {
            IParseNode lastChild = JSONUtils.findJSONNodeByName((JSONParseRootNode)root, null);
            if (lastChild != null) {
                sBuffer.append(",\n").append("\"dependencies\"").append(":").append(StreamJsonUtil.toJson((Gson)gson, (Object)map));
                this.formatSourceDocument(lastChild.getEndingOffset() + 1, 0, sBuffer.toString());
            } else {
                LinkedHashMap<String, Map> manifestMap = new LinkedHashMap<String, Map>();
                manifestMap.put("dependencies", map);
                this.formatSourceDocument(0, root.getLength(), StreamJsonUtil.toJson((Gson)gson, manifestMap));
            }
        } else {
            IParseNode lastChild = JSONUtils.findJSONNodeByName((JSONParseRootNode)root, (String)"dependencies");
            this.formatSourceDocument(lastChild.getStartingOffset(), lastChild.getLength(), gson.toJson((Object)map));
        }
    }

    private void changeManifastConfigurationDocument() {
        if (this.sourceEditor == null) {
            return;
        }
        if (this.changedPaths.size() != 0 && this.sourceEditor != null) {
            try {
                boolean needFormat = AppConfigEditor.changeManifestJson(this.changedPaths, this.manifastConfiguration, this.sourceEditor.getDocument());
                if (needFormat && this.sourceEditor.getISourceViewer() != null) {
                    ((SourceViewer)this.sourceEditor.getISourceViewer()).doOperation(15);
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
            }
        }
        this.changedPaths.clear();
    }

    public static boolean changeManifestJson(Set<String> changedPaths, ManifastConfiguration manifastConfiguration, final IDocument manifastDocument) {
        if (manifastDocument == null || changedPaths == null || changedPaths.isEmpty()) {
            return false;
        }
        String[] changes = changedPaths.toArray(new String[0]);
        Arrays.sort(changes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                return o1.length() > o2.length() ? 1 : -1;
            }
        });
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        final boolean[] needFormat = new boolean[1];
        String[] stringArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            String changeValuePath = stringArray[n2];
            String[] paths = changeValuePath.split("\\.");
            if (paths != null && paths.length > 1) {
                if ("manifest".equals(paths[0])) {
                    paths = Arrays.copyOfRange(paths, 1, paths.length);
                }
                final String name = paths[paths.length - 1];
                final String[] parentPaths = Arrays.copyOf(paths, paths.length - 1);
                Object object = ReflectUtils.getFieldValue((Object)manifastConfiguration, (String[])paths);
                final String value = object == null ? null : gson.toJson(object);
                try {
                    ParseResult parseResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.json", (String)manifastDocument.get());
                    if (parseResult == null) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (String)"parse error");
                        return needFormat[0];
                    }
                    IParseRootNode ast = parseResult.getRootNode();
                    if (ast == null) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (String)"root is null");
                        return needFormat[0];
                    }
                    JSONParseRootNode root = (JSONParseRootNode)ast.getRootNode();
                    root.accept(new JSONTreeWalker(){
                        private int depth = 0;

                        public void visit(JSONEntryNode node) {
                            IParseNode nameNode = node.getFirstChild();
                            if (nameNode != null) {
                                if (this.depth > parentPaths.length) {
                                    throw new StopVisitingException();
                                }
                                if (this.depth < parentPaths.length) {
                                    String pPath = parentPaths[this.depth];
                                    if (pPath.equals(nameNode.getText())) {
                                        ++this.depth;
                                        boolean hasNode = false;
                                        IParseNode lastNode = node.getLastChild();
                                        if (this.depth < parentPaths.length || !lastNode.hasChildren()) {
                                            IParseNode previousParent = null;
                                            if (lastNode.hasChildren()) {
                                                pPath = parentPaths[this.depth];
                                                for (IParseNode iParseNode : lastNode) {
                                                    if (iParseNode == null || iParseNode.getFirstChild() == null || !pPath.equals(iParseNode.getFirstChild().getText())) continue;
                                                    if (this.depth == parentPaths.length - 1 && iParseNode instanceof JSONEntryNode && !iParseNode.getLastChild().hasChildren()) {
                                                        previousParent = iParseNode;
                                                    }
                                                    hasNode = true;
                                                    break;
                                                }
                                                if (!hasNode && value != null) {
                                                    this.createNotes(needFormat, name, parentPaths, value, lastNode);
                                                } else if (previousParent != null && value != null) {
                                                    try {
                                                        IParseNode last = ((JSONEntryNode)previousParent).getLastChild();
                                                        if (last != null) {
                                                            manifastDocument.replace(last.getStartingOffset() + 1, 0, "\"" + name + "\":" + value);
                                                            needFormat[0] = true;
                                                            IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)("changeManifastConfigurationDocument  name: " + name + "   value: " + value));
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                                                    }
                                                    throw new StopVisitingException();
                                                }
                                            } else if (value != null) {
                                                String[] newPaths = new String[parentPaths.length];
                                                System.arraycopy(parentPaths, 0, newPaths, 0, newPaths.length);
                                                this.createNotes(needFormat, name, newPaths, value, lastNode);
                                            }
                                        }
                                        this.visitChildren((JSONNode)node);
                                    } else if (node.getParent().getLastChild() == node && value != null) {
                                        this.createNotes(needFormat, name, parentPaths, value, node.getParent());
                                    }
                                } else if (this.depth == parentPaths.length) {
                                    if (name.equals(nameNode.getText())) {
                                        try {
                                            if (value == null) {
                                                IParseNode nextNode = node.getNextSibling();
                                                if (nextNode instanceof JSONCommaNode) {
                                                    manifastDocument.replace(node.getStartingOffset(), nextNode.getEndingOffset() - node.getStartingOffset() + 1, "");
                                                    IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)("changeManifastConfigurationDocument  name: " + name + "   value: " + value));
                                                } else if (node.getParent().getLastChild() == node) {
                                                    IParseNode previousNode = node.getPreviousNode();
                                                    if (previousNode instanceof JSONCommaNode) {
                                                        manifastDocument.replace(previousNode.getStartingOffset(), node.getEndingOffset() - previousNode.getStartingOffset() + 1, "");
                                                    } else {
                                                        manifastDocument.replace(node.getStartingOffset(), node.getLength(), "");
                                                    }
                                                } else {
                                                    manifastDocument.replace(node.getStartingOffset(), node.getLength(), "");
                                                }
                                                IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)("changeManifastConfigurationDocument  name: " + name + "   value: " + value));
                                            } else if (value instanceof String) {
                                                IParseNode valueNode = node.getLastChild();
                                                manifastDocument.replace(valueNode.getStartingOffset(), valueNode.getLength(), value);
                                                IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)("changeManifastConfigurationDocument  name: " + name + "   value: " + value));
                                            }
                                        }
                                        catch (Exception e) {
                                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                                        }
                                        throw new StopVisitingException();
                                    }
                                    if (value != null && node.getParent().getLastChild() == node) {
                                        try {
                                            manifastDocument.replace(node.getEndingOffset() + 1, 0, ",\"" + name + "\":" + value);
                                            needFormat[0] = true;
                                            IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)("changeManifastConfigurationDocument  name: " + name + "   value: " + value));
                                        }
                                        catch (Exception e) {
                                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                                        }
                                        throw new StopVisitingException();
                                    }
                                }
                            }
                        }

                        protected void createNotes(boolean[] needFormat2, String name2, String[] parentPaths2, String value2, IParseNode lastNode) {
                            if (value2 == null) {
                                throw new StopVisitingException();
                            }
                            int offset = lastNode.getStartingOffset() + 1;
                            boolean hasChildren = lastNode.hasChildren();
                            while (this.depth <= parentPaths2.length + 1) {
                                try {
                                    String n = "";
                                    String v = "";
                                    int prefix = 1;
                                    if (this.depth == parentPaths2.length || parentPaths2.length == 0) {
                                        if (value2 == null) {
                                            throw new StopVisitingException();
                                        }
                                        n = name2;
                                        v = value2.toString();
                                    } else if (this.depth < parentPaths2.length) {
                                        n = parentPaths2[this.depth];
                                        v = "{}";
                                        if (hasChildren) {
                                            hasChildren = false;
                                            v = String.valueOf(v) + ",";
                                            prefix = 2;
                                        }
                                    }
                                    String content = "\"" + n + "\":" + v;
                                    manifastDocument.replace(offset, 0, content);
                                    offset += content.length() - prefix;
                                    needFormat2[0] = true;
                                    if (this.depth == parentPaths2.length) {
                                        throw new StopVisitingException();
                                    }
                                }
                                catch (BadLocationException e) {
                                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                                }
                                ++this.depth;
                            }
                        }
                    });
                }
                catch (StopVisitingException stopVisitingException) {
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                }
            }
            ++n2;
        }
        return needFormat[0];
    }

    private void copyProperties(Object dest, Object src) throws Exception {
        try {
            PropertyDescriptor[] descs;
            if (dest == null || src == null) {
                return;
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(dest.getClass());
            PropertyDescriptor[] propertyDescriptorArray = descs = beanInfo.getPropertyDescriptors();
            int n = descs.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor desc = propertyDescriptorArray[n2];
                if (desc.getReadMethod() != null && desc.getWriteMethod() != null) {
                    PropertyDescriptor srcProperty = new PropertyDescriptor(desc.getName(), src.getClass());
                    if (desc.getPropertyType().isPrimitive() || desc.getPropertyType() == String.class) {
                        Method writeMethod = desc.getWriteMethod();
                        writeMethod.invoke(dest, srcProperty.getReadMethod().invoke(src, new Object[0]));
                    } else if (desc.getPropertyType() == List.class) {
                        List list = (List)srcProperty.getReadMethod().invoke(src, new Object[0]);
                        List destList = (List)desc.getReadMethod().invoke(dest, new Object[0]);
                        if (list != null && !list.isEmpty()) {
                            destList.clear();
                            destList.addAll(list);
                        }
                    } else {
                        Object nextDest = desc.getReadMethod().invoke(dest, new Object[0]);
                        Object nextSrc = srcProperty.getReadMethod().invoke(src, new Object[0]);
                        if (nextDest == null && nextSrc != null) {
                            nextDest = desc.getPropertyType().newInstance();
                            desc.getWriteMethod().invoke(dest, nextDest);
                        } else if (nextSrc == null) {
                            desc.getWriteMethod().invoke(dest, nextSrc);
                        }
                        this.copyProperties(nextDest, nextSrc);
                    }
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void settingTabFolderStyle() {
        Composite composite = this.getContainer();
        if (composite instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)composite;
            tabFolder.setTabHeight(23);
            tabFolder.setSimple(true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IFile appConfigIFile;
        block5: {
            IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)MessageFormat.format("\u4fdd\u5b58{0}\u6587\u4ef6...", "manifest.json"));
            appConfigIFile = this.project.getFile("manifest.json");
            if (appConfigIFile.getLocation() != null) break block5;
            this.setDirty(false);
            return;
        }
        try {
            try {
                final File configFile = appConfigIFile.getLocation().makeAbsolute().toFile();
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            if (AppConfigEditor.this.sourceEditor != null) {
                                AppConfigEditor.this.changeManifastConfigurationDocument();
                                try {
                                    AppConfigEditor.this.sourceEditor.doSave(monitor);
                                }
                                catch (AssertionFailedException assertionFailedException) {}
                            } else {
                                String jsonString = AppConfigEditor.this.gson.toJson((Object)AppConfigEditor.this.manifastConfiguration);
                                JSONObject object = new JSONObject(jsonString);
                                FileUtils.writeStringToFile((File)configFile, (String)object.toString(true));
                            }
                            if (AppConfigEditor.this.getToolkit() != null && AppConfigEditor.this.currentEditorIndex == AppConfigEditor.this.sourceEditorIndex) {
                                try {
                                    ParseResult parseResult = AppConfigEditor.this.sourceEditor.getParseResult();
                                    if (parseResult == null || !parseResult.getErrors().isEmpty() || parseResult.getRootNode() == null) {
                                        AppConfigEditor.this.syntaxError = true;
                                        AppConfigEditor.this.showSyntaxError(false);
                                    } else {
                                        ManifastConfiguration config = (ManifastConfiguration)AppConfigEditor.this.gson.fromJson(AppConfigEditor.this.sourceEditor.getDocument().get(), ManifastConfiguration.class);
                                        AppConfigEditor.this.syntaxError = false;
                                        Map infos = ManifastConfigurationVerification.verify((ManifastConfiguration)config, (IProject)AppConfigEditor.this.getProject(), (ManifastConfigurationVerification.VerificationPlatform)AppConfigEditor.this.platform);
                                        AppConfigEditor.this.showAllPagesError(infos);
                                    }
                                }
                                catch (JsonSyntaxException jsonSyntaxException) {
                                    AppConfigEditor.this.syntaxError = true;
                                    AppConfigEditor.this.showSyntaxError(false);
                                }
                                catch (Throwable e) {
                                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                                }
                            }
                            if (AppConfigEditor.this.fStreamPage != null) {
                                AppConfigEditor.this.fStreamPage.saveDependenciesSettingFile(AppConfigEditor.this.fStreamPage.getDiffDependencies(), ".dependencies");
                                AppConfigEditor.this.fStreamPage.saveDependenciesSettingFile(AppConfigEditor.this.fStreamPage.getConfirmPages(), ".confirmed_dependencies");
                            }
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)e);
                this.setDirty(false);
            }
        }
        catch (Throwable throwable) {
            this.setDirty(false);
            throw throwable;
        }
        this.setDirty(false);
        IdeLog.logInfo((Plugin)EditorPlugin.getDefault(), (String)MessageFormat.format("\u4fdd\u5b58{0}\u6587\u4ef6\u7ed3\u675f...", "manifest.json"));
    }

    public void doSaveAs() {
    }

    public void showVerificationInfo(Map<String, String> verificationInfos, Map<String, String> permissionInfos, String pageId, ManifastConfigurationVerification.VerificationPlatform platform) {
        this.platform = platform;
        if (this.syntaxError) {
            this.showSyntaxError(true);
            return;
        }
        boolean hasErrors = false;
        if (verificationInfos != null) {
            this.showAllPagesError(verificationInfos);
            for (Object object : this.pages) {
                AbstractAppConfigPage page;
                if (!(object instanceof AbstractAppConfigPage) || this.getPageImage((page = (AbstractAppConfigPage)((Object)object)).getIndex()) == null) continue;
                try {
                    hasErrors = true;
                    this.needValidation = false;
                    this.setActivePage(page.getId());
                    page.validation(verificationInfos, true);
                    break;
                }
                finally {
                    this.needValidation = true;
                }
            }
        }
        if (hasErrors) {
            return;
        }
        if (permissionInfos != null && !permissionInfos.isEmpty()) {
            this.setActivePage(pageId == null ? this.modulesAppConfigPage.getId() : pageId);
        } else {
            this.setActivePage(pageId);
        }
    }

    public void showAllPagesError(Map<String, String> infos) {
        if (this.syntaxError) {
            return;
        }
        this.removeSyntaxError();
        boolean basicError = false;
        boolean iconsError = false;
        boolean splashError = false;
        boolean pluginsError = false;
        boolean moduleError = false;
        if (infos != null) {
            Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
            for (String path : infos.keySet()) {
                if (path.startsWith("manifest.plus.distribute.icons")) {
                    iconsError = true;
                    this.setPageImage(this.getIconsAppConfigPage().getPageIndex(), errorImage);
                } else if (path.startsWith("manifest.plus.distribute.splashscreen") || path.startsWith("manifest.plus.splashscreen")) {
                    splashError = true;
                    this.setPageImage(this.getSplashsAppConfigPage().getPageIndex(), errorImage);
                } else if (path.startsWith("manifest.plus.distribute.plugins")) {
                    pluginsError = true;
                    this.setPageImage(this.getPluginsAppConfigPage().getPageIndex(), errorImage);
                } else if (path.startsWith("manifest.permissions") || path.startsWith("manifest.plus.distribute.google.permissions")) {
                    moduleError = true;
                    this.setPageImage(this.getModulesAppConfigPage().getPageIndex(), errorImage);
                } else if (path.startsWith("manifest.")) {
                    basicError = true;
                    this.setPageImage(this.getBasicInfoAppConfigPage().getPageIndex(), errorImage);
                }
                if (basicError && iconsError && splashError && pluginsError && moduleError) break;
            }
        }
        if (!iconsError) {
            this.setPageImage(this.getIconsAppConfigPage().getPageIndex(), null);
        }
        if (!splashError) {
            this.setPageImage(this.getSplashsAppConfigPage().getPageIndex(), null);
        }
        if (!pluginsError) {
            this.setPageImage(this.getPluginsAppConfigPage().getPageIndex(), null);
        }
        if (!moduleError) {
            this.setPageImage(this.getModulesAppConfigPage().getPageIndex(), null);
        }
        if (!basicError) {
            this.setPageImage(this.getBasicInfoAppConfigPage().getPageIndex(), null);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.getSourceEditor() != null && this.getSourceEditor().isDirty() || this.isPropertyChanged;
    }

    public void setDirty(boolean isPropertyChanged) {
        this.isPropertyChanged = isPropertyChanged;
        this.editorDirtyStateChanged();
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isWap2App() {
        try {
            return this.project != null && this.project.hasNature("com.pandora.projects.ui.Wap2AppNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IFile getEditFile() {
        if (this.fileInput != null) {
            return this.fileInput.getFile();
        }
        return null;
    }

    public ManifastConfiguration getManifestConfiguration() {
        return this.manifastConfiguration;
    }

    public Set<String> getChangedPaths() {
        return this.changedPaths;
    }

    public BasicInfoAppConfigPage getBasicInfoAppConfigPage() {
        return this.basicInfoAppConfigPage;
    }

    public IconsAppConfigPage getIconsAppConfigPage() {
        return this.iconsAppConfigPage;
    }

    public SplashsAppConfigPage getSplashsAppConfigPage() {
        return this.splashsAppConfigPage;
    }

    public PluginsAppConfigPage getPluginsAppConfigPage() {
        return this.pluginsAppConfigPage;
    }

    public ModulesAppConfigPage getModulesAppConfigPage() {
        return this.modulesAppConfigPage;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class == adapter) {
            return this.sourceEditor.getAdapter(adapter);
        }
        if (AbstractThemeableEditor.class == adapter && this.currentEditorIndex == this.sourceEditorIndex) {
            return this.sourceEditor;
        }
        return super.getAdapter(adapter);
    }

    public JSONSourceEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public boolean isOpenManualValidator() {
        return this.sourceEditor.isOpenManualValidator();
    }

    public ManifastConfigurationVerification.VerificationPlatform getPlatform() {
        return this.platform;
    }

    private static class StopVisitingException
    extends RuntimeException {
        private StopVisitingException() {
        }
    }
}

