/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.service.impl;

import com.pandora.index.application.IndexApplication;
import com.pandora.index.service.ILinkedBlockingQueueService;
import com.pandora.index.service.IRemoteIndexService;
import com.pandora.index.service.IndexRequest;
import com.pandora.index.service.IndexServicePlugin;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;

public class IndexService
extends UnicastRemoteObject
implements IRemoteIndexService,
ILinkedBlockingQueueService {
    private boolean developmentMode = Platform.inDevelopmentMode();
    private Object fLock = null;
    private LinkedBlockingDeque<IndexRequest> fRequestQueue;
    private static final long serialVersionUID = -7034625285600020631L;

    public IndexService(Object lock, LinkedBlockingDeque<IndexRequest> requestQueue) throws RemoteException {
        this.fLock = lock;
        this.fRequestQueue = requestQueue;
    }

    public void index(IndexRequest request) throws RemoteException {
        if (request.isHighPriority()) {
            this.fRequestQueue.remove(request);
            this.fRequestQueue.addFirst(request);
        } else if (!this.fRequestQueue.contains(request)) {
            this.fRequestQueue.offer(request);
        }
    }

    public void exit() throws RemoteException {
        if (!this.developmentMode) {
            IndexApplication.running = false;
            if (this.fLock == null) {
                System.exit(0);
            } else {
                ((Display)this.fLock).wake();
            }
        } else {
            IndexServicePlugin.getDefault().restartLocalService();
        }
    }

    public void insert(IndexRequest request) {
        this.fRequestQueue.remove(request);
        this.fRequestQueue.addFirst(request);
    }
}

