/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.service.impl;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.internal.build.LazyBuildParticipant;
import com.aptana.core.resources.TaskTag;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.build.BuildContext;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.index.service.BuildRequest;
import com.pandora.index.service.IRemoteBuildService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class BuildService
extends UnicastRemoteObject
implements IRemoteBuildService {
    private static final long serialVersionUID = -5355655094380869899L;
    private static Map<URI, IProgressMonitor> monitors = new HashMap<URI, IProgressMonitor>();
    private static Kryo kryo = new Kryo();
    private boolean debug = Platform.inDebugMode() || Platform.inDevelopmentMode();

    static {
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        kryo.setAutoReset(true);
    }

    public byte[] build(BuildRequest request) throws RemoteException {
        if (request == null) {
            return null;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println(">> build  : " + request.getIndexURI());
        }
        try {
            List<AbstractRemoteBuildParticipant> remoteParticipants;
            List<IBuildParticipant> participants;
            IProgressMonitor m = monitors.remove(request.getIndexURI());
            if (m != null) {
                m.setCanceled(true);
            }
            if (CollectionsUtil.isEmpty(participants = this.getBuildParticipants(request.getContentType()))) {
                return null;
            }
            NullProgressMonitor monitor = new NullProgressMonitor();
            monitors.put(request.getIndexURI(), (IProgressMonitor)monitor);
            IBuildParticipant.BuildType type = IBuildParticipant.BuildType.BUILD;
            if (request.isReconcile()) {
                type = IBuildParticipant.BuildType.RECONCILE;
            }
            if ((remoteParticipants = this.filterEnableRemoteBuild(participants, type, request)).isEmpty()) {
                return null;
            }
            TaskTag.setNeedInit((boolean)false);
            TaskTag.setCaseSensitive((boolean)request.isCaseSensitive());
            if (StringUtil.isEmpty((String)request.getRawTagNames()) || StringUtil.isEmpty((String)request.getRawTagPriorities())) {
                TaskTag.setTaskTags(null);
            } else {
                try {
                    List taskTags = TaskTag.createTaskTags((String)request.getRawTagNames(), (String)request.getRawTagPriorities());
                    TaskTag.setTaskTags((List)taskTags);
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                }
            }
            for (AbstractRemoteBuildParticipant participant : remoteParticipants) {
                participant.buildStart(request);
                if (!monitor.isCanceled()) continue;
                return null;
            }
            BuildContext context = this.request2Context(request);
            for (AbstractRemoteBuildParticipant participant : remoteParticipants) {
                if (monitor.isCanceled()) {
                    return null;
                }
                participant.buildFile(context, (IProgressMonitor)monitor);
            }
            for (AbstractRemoteBuildParticipant participant : remoteParticipants) {
                if (monitor.isCanceled()) {
                    return null;
                }
                participant.buildEnding((IProgressMonitor)monitor);
            }
            if (monitor.isCanceled()) {
                return null;
            }
            Map result = context.getProblems();
            if (result != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Output out = new Output((OutputStream)baos);
                kryo.writeClassAndObject(out, new HashMap(result));
                out.close();
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        finally {
            monitors.remove(request.getIndexURI());
            if (this.debug) {
                System.out.println("<< build  : " + request.getIndexURI() + " " + (System.currentTimeMillis() - time));
            }
        }
        return null;
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        return BuildPathCorePlugin.getDefault().getBuildParticipantManager();
    }

    protected List<IBuildParticipant> getBuildParticipants(String contentType) {
        return this.getBuildParticipantManager().getBuildParticipants(contentType);
    }

    private List<AbstractRemoteBuildParticipant> filterEnableRemoteBuild(List<IBuildParticipant> participants, IBuildParticipant.BuildType type, BuildRequest request) {
        ArrayList<AbstractRemoteBuildParticipant> remoteParticipants = new ArrayList<AbstractRemoteBuildParticipant>();
        for (IBuildParticipant item : participants) {
            if (item == null) continue;
            AbstractRemoteBuildParticipant remoteParticipant = null;
            if (item instanceof LazyBuildParticipant) {
                LazyBuildParticipant lazyBuildParticipant = (LazyBuildParticipant)item;
                IBuildParticipant buildParticipant = lazyBuildParticipant.getParticipant();
                if (buildParticipant instanceof AbstractRemoteBuildParticipant) {
                    remoteParticipant = (AbstractRemoteBuildParticipant)buildParticipant;
                }
            } else if (item instanceof AbstractRemoteBuildParticipant) {
                remoteParticipant = (AbstractRemoteBuildParticipant)item;
            }
            if (remoteParticipant == null || !remoteParticipant.isEnabled() || !request.isOpenManualValidator() && !remoteParticipant.isEnabled(type)) continue;
            remoteParticipants.add(remoteParticipant);
        }
        return remoteParticipants;
    }

    private BuildContext request2Context(final BuildRequest request) {
        BuildContext buildContext = new BuildContext(null){

            public URI getURI() {
                return request.getIndexURI();
            }

            public synchronized String getContents() {
                return request.readContents();
            }

            public InputStream openInputStream(IProgressMonitor monitor) throws CoreException {
                return request.openInputStream();
            }

            public String getContentType() throws CoreException {
                return request.getContentType();
            }
        };
        buildContext.setFullBuild(request.isFullBuild());
        buildContext.setNeedSleep(request.isNeedSleep());
        buildContext.setSave(Boolean.valueOf(request.isSave()));
        buildContext.setOpenManualValidator(request.isOpenManualValidator());
        return buildContext;
    }
}

