/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.application;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.index.application.IndexApplication;
import com.pandora.index.service.ILocalIndexService;
import com.pandora.index.service.IndexServicePlugin;
import java.rmi.RemoteException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class PingJob
extends Job {
    private boolean developmentMode = Platform.inDevelopmentMode();
    private Object fLock;

    public PingJob(Object lock) {
        super("ping...");
        this.fLock = lock;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean first = true;
        while (!monitor.isCanceled()) {
            try {
                ILocalIndexService local = IndexServicePlugin.getDefault().getLocalIndexService(null);
                local.ping();
                if (first) {
                    System.out.println("INDEXER_SERVER_STARTED_SUCESSED");
                }
                first = false;
                Thread.sleep(2000L);
            }
            catch (RemoteException e) {
                if (!this.developmentMode) {
                    IndexApplication.running = false;
                    if (first) {
                        System.out.println("INDEXER_SERVER_STARTED_FAILED");
                    }
                    HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    break;
                }
                IndexServicePlugin.getDefault().restartLocalService();
            }
            catch (Exception e) {
                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.fLock == null) {
            System.exit(0);
        } else {
            ((Display)this.fLock).wake();
        }
        return Status.OK_STATUS;
    }
}

