/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.aptana.projects.internal.wizards.Messages;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.projects.wizards.IWizardProjectCreationPage;
import com.aptana.projects.wizards.PandoraProjectContentsLocationArea;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SelectedTemplateComposite;
import com.aptana.ui.widgets.StepIndicatorComposite;
import com.pandora.core.auth.UserAuth;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class CommonWizardNewProjectCreationPage
extends WizardNewProjectCreationPage
implements IWizardProjectCreationPage,
IStepIndicatorWizardPage {
    private Label warningLabel;
    private IProjectTemplate projectTemplate = null;
    protected StepIndicatorComposite stepIndicatorComposite;
    protected String[] stepNames;

    public CommonWizardNewProjectCreationPage(String pageName, IProjectTemplate projectTemplate) {
        super(pageName);
        this.projectTemplate = projectTemplate;
    }

    @Override
    public boolean isCloneFromGit() {
        return false;
    }

    @Override
    public String getCloneURI() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageLayout = GridLayoutFactory.fillDefaults().spacing(0, 5).create();
        pageComposite.setLayout((Layout)pageLayout);
        pageComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.stepIndicatorComposite = new StepIndicatorComposite(pageComposite, this.stepNames);
        this.stepIndicatorComposite.setSelection(this.getStepName());
        this.createTopArea(pageComposite);
        this.updateControl(pageComposite);
        ((Composite)this.getControl()).setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        ((Composite)this.getControl()).setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1).create());
        this.setControl((Control)pageComposite);
        this.createProjectTemplateSection(pageComposite);
        this.createWarningArea();
    }

    private void updateControl(Composite parent) {
        try {
            Field initialProjectFieldValueField;
            Method getErrorReporterMethod;
            Composite composite = new Composite(parent, 0);
            this.initializeDialogUnits((Control)parent);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            Class<WizardNewProjectCreationPage> superClass = WizardNewProjectCreationPage.class;
            Method createProjectNameGroupMethod = superClass.getDeclaredMethod("createProjectNameGroup", Composite.class);
            if (createProjectNameGroupMethod != null) {
                createProjectNameGroupMethod.setAccessible(true);
                createProjectNameGroupMethod.invoke((Object)this, composite);
            }
            Field locationAreaField = superClass.getDeclaredField("locationArea");
            PandoraProjectContentsLocationArea locationArea = null;
            if (locationAreaField != null && (getErrorReporterMethod = superClass.getDeclaredMethod("getErrorReporter", new Class[0])) != null) {
                locationAreaField.setAccessible(true);
                getErrorReporterMethod.setAccessible(true);
                locationArea = new PandoraProjectContentsLocationArea((ProjectContentsLocationArea.IErrorMessageReporter)getErrorReporterMethod.invoke((Object)this, new Object[0]), composite);
                locationAreaField.set(this, (Object)locationArea);
            }
            if ((initialProjectFieldValueField = superClass.getDeclaredField("initialProjectFieldValue")) != null) {
                initialProjectFieldValueField.setAccessible(true);
                Object obj = initialProjectFieldValueField.get(this);
                if (obj != null && locationArea != null) {
                    locationArea.updateProjectName(obj.toString());
                }
            }
            if (locationArea != null) {
                this.setButtonLayoutData(locationArea.getBrowseButton());
            }
            this.setPageComplete(this.validatePage());
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            if (locationArea != null) {
                locationArea.updateProjectName("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createTopArea(Composite parent) {
    }

    private void createWarningArea() {
        Composite control = (Composite)this.getControl();
        final Font font = new Font((Device)control.getDisplay(), SWTUtils.italicizedFont((Font)this.getFont()));
        this.warningLabel = new Label(control, 0x1000040);
        this.warningLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 1).grab(true, false).create());
        this.warningLabel.setFont(font);
        this.warningLabel.setForeground(UIUtils.getDisplay().getSystemColor(3));
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
    }

    protected void createProjectTemplateSection(Composite parent) {
        if (this.projectTemplate != null) {
            new SelectedTemplateComposite(parent, this.projectTemplate);
        }
    }

    protected boolean validatePage() {
        boolean isValid = super.validatePage();
        if (this.warningLabel != null) {
            this.warningLabel.setText("");
        }
        if (isValid) {
            File locationFile = this.getLocationPath().toFile();
            boolean existing = false;
            if (this.useDefaults()) {
                Object[] files;
                String defaultLocation = TextProcessor.process((String)(String.valueOf(WorkspaceUtil.getCodeDir((String)UserAuth.getUsername())) + File.separator + this.getProjectName()));
                File dir = new File(defaultLocation);
                if (dir.exists() && !ArrayUtil.isEmpty((Object[])(files = dir.list()))) {
                    existing = true;
                }
            } else if (locationFile.exists()) {
                String projectLocation = String.valueOf(locationFile.getAbsolutePath()) + File.separatorChar + this.getProjectName();
                File project = new File(projectLocation);
                if (project.exists() && project.isDirectory()) {
                    Object[] files = project.list();
                    if (!ArrayUtil.isEmpty((Object[])files)) {
                        existing = true;
                    }
                } else if (project.isFile()) {
                    this.warningLabel.setText(Messages.CommonWizardNewProjectCreationPage_1);
                    this.warningLabel.getParent().layout(true);
                    return false;
                }
            }
            if (existing) {
                this.setErrorMessage("\u6307\u5b9a\u7684\u9879\u76ee\u540d\u79f0\u548c\u8be5\u8def\u5f84\u4e0b\u5df2\u6709\u7684\u67d0\u4e2a\u6587\u4ef6\u91cd\u540d\uff0c\u8bf7\u6307\u5b9a\u5176\u4ed6\u540d\u79f0\u3002");
                return false;
            }
        }
        return isValid;
    }

    @Override
    public String getStepName() {
        return Messages.NewProjectWizard_Step_Lbl;
    }

    @Override
    public void initStepIndicator(String[] stepNames) {
        this.stepNames = stepNames;
    }

    public Label getWarningLabel() {
        return this.warningLabel;
    }

    public void setWarningLabel(Label warningLabel) {
        this.warningLabel = warningLabel;
    }

    @Override
    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    @Override
    public URI getLocationURI() {
        return super.getLocationURI();
    }
}

