/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.ProjectsPlugin;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class ProjectUtil {
    public static IProjectDescription getProjectDescription(IPath projectPath, String[] natureIds, String[] builderIds) {
        if (projectPath == null) {
            return null;
        }
        IProjectDescription description = null;
        IPath dotProjectPath = projectPath.append(".project");
        File dotProjectFile = dotProjectPath.toFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (dotProjectFile.exists()) {
            try {
                description = workspace.loadProjectDescription(dotProjectPath);
                if (Platform.getLocation().isPrefixOf(projectPath)) {
                    description.setLocation(null);
                }
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)ProjectsPlugin.getDefault(), (String)"Failed to load the existing .project file.", (Throwable)e);
            }
        }
        if (description == null) {
            description = workspace.newProjectDescription(projectPath.lastSegment());
            if (Platform.getLocation().isPrefixOf(projectPath)) {
                description.setLocation(null);
            } else {
                description.setLocation(projectPath);
            }
        }
        if (!ArrayUtil.isEmpty((Object[])natureIds)) {
            Set natures = CollectionsUtil.newInOrderSet((Object[])natureIds);
            CollectionsUtil.addToSet((Set)natures, (Object[])description.getNatureIds());
            description.setNatureIds(natures.toArray(new String[natures.size()]));
        }
        if (!ArrayUtil.isEmpty((Object[])builderIds)) {
            Object[] existingBuilders = description.getBuildSpec();
            List builders = CollectionsUtil.newList((Object[])existingBuilders);
            String[] stringArray = builderIds;
            int n = builderIds.length;
            int n2 = 0;
            while (n2 < n) {
                String builderId = stringArray[n2];
                if (!ProjectUtil.hasBuilder(builderId, (ICommand[])existingBuilders)) {
                    ICommand newBuilder = description.newCommand();
                    newBuilder.setBuilderName(builderId);
                    builders.add(newBuilder);
                }
                ++n2;
            }
            description.setBuildSpec(builders.toArray(new ICommand[builders.size()]));
        }
        return description;
    }

    private static boolean hasBuilder(String builderName, ICommand[] builders) {
        if (StringUtil.isEmpty((String)builderName)) {
            return false;
        }
        ICommand[] iCommandArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand builder = iCommandArray[n2];
            if (builderName.equals(builder.getBuilderName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAccessible(IProject project) {
        return project != null && project.isAccessible();
    }
}

