/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.templates;

import com.aptana.core.projects.templates.HMobileProjectTemplate;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateAbility;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.templates.IProjectTemplateListener;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.ElementVisibilityListener;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ProjectTemplatesManager {
    private static final String README_FILE_NAME = "readme.txt";
    private static final String OS_NAME = "os.name";
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_MAC = "mac";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_TEMPLATES_DIRECTORY_GENERAL = "/HBuilder settings/Templates/";
    private static final String USER_TEMPLATES_DIRECTORY_MACOSX = "/Documents/HBuilder settings/Templates/";
    public static final String READMES = "/readmes/";
    private static final String EXTENSION_POINT = "projectTemplates";
    private static final String ELEMENT_TEMPLATEINFO = "templateInfo";
    private static final String ELEMENT_LOCAL = "local";
    private static final String ELEMENT_REMOTE = "remote";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ABILITY = "ability";
    private static final String ATTR_ID = "id";
    private static final String ATTR_REPLACE_PARAMETERS = "replaceParameters";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_NATURE_ID = "natureID";
    private Map<TemplateType, List<IProjectTemplate>> projectTemplates;
    private ImageRegistry templateTagsImageRegistry;
    private ElementVisibilityListener elementListener = new ElementVisibilityListener(){

        public void elementBecameHidden(AbstractElement element) {
            if (element instanceof ProjectTemplateElement) {
                ProjectTemplateElement template = (ProjectTemplateElement)element;
                ProjectTemplatesManager.this.removeTemplate((IProjectTemplate)template);
            }
        }

        public void elementBecameVisible(AbstractElement element) {
            if (element instanceof ProjectTemplateElement) {
                ProjectTemplateElement template = (ProjectTemplateElement)element;
                ProjectTemplatesManager.this.addTemplate((IProjectTemplate)template);
            }
        }
    };
    private List<IProjectTemplateListener> templateListeners;

    public ProjectTemplatesManager() {
        this.projectTemplates = new HashMap<TemplateType, List<IProjectTemplate>>();
        this.templateListeners = new ArrayList<IProjectTemplateListener>();
        this.readExtensionRegistry();
        this.loadTemplatesFromBundles();
        BundleManager.getInstance().addElementVisibilityListener(this.elementListener);
    }

    public void dispose() {
        BundleManager.getInstance().removeElementVisibilityListener(this.elementListener);
    }

    public void addListener(IProjectTemplateListener listener) {
        if (!this.templateListeners.contains(listener)) {
            this.templateListeners.add(listener);
        }
    }

    public void removeListener(IProjectTemplateListener listener) {
        this.templateListeners.remove(listener);
    }

    public List<IProjectTemplate> getAllTemplates(TemplateType[] projectTypes) {
        ArrayList<IProjectTemplate> templates = new ArrayList<IProjectTemplate>();
        templates.addAll(this.getTemplates(projectTypes));
        templates.addAll(this.getUserTemplates(projectTypes));
        return templates;
    }

    public List<IProjectTemplate> getUserTemplatesForType(final TemplateType projectType) {
        File path = this.createUserTemplatePath(projectType);
        final ArrayList<IProjectTemplate> list = new ArrayList<IProjectTemplate>();
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                if (!name.equals(ProjectTemplatesManager.README_FILE_NAME) && name.endsWith(".zip")) {
                    if (name.indexOf(".") > 0) {
                        name = pathname.getName().substring(0, pathname.getName().lastIndexOf(46));
                    }
                    list.add(new ProjectTemplate(pathname.getAbsolutePath(), projectType, name, false, "", null, null));
                }
                return false;
            }
        });
        Collections.sort(list, new Comparator<IProjectTemplate>(){

            @Override
            public int compare(IProjectTemplate o1, IProjectTemplate o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return list;
    }

    public List<IProjectTemplate> getUserTemplates(TemplateType[] projectTypes) {
        ArrayList<IProjectTemplate> templates = new ArrayList<IProjectTemplate>();
        TemplateType[] templateTypeArray = projectTypes;
        int n = projectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateType type = templateTypeArray[n2];
            templates.addAll(this.getUserTemplatesForType(type));
            ++n2;
        }
        return templates;
    }

    public List<IProjectTemplate> getTemplatesForType(TemplateType projectType) {
        List<IProjectTemplate> templates = this.projectTemplates.get(projectType);
        if (templates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(templates);
    }

    public List<IProjectTemplate> getTemplates(TemplateType[] projectTypes) {
        ArrayList<IProjectTemplate> templates = new ArrayList<IProjectTemplate>();
        TemplateType[] templateTypeArray = projectTypes;
        int n = projectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateType type = templateTypeArray[n2];
            templates.addAll(this.getTemplatesForType(type));
            ++n2;
        }
        return templates;
    }

    public Image getImageForTag(String tag) {
        ImageRegistry reg = this.getImageRegistry();
        if (reg != null) {
            return reg.get(tag);
        }
        return null;
    }

    public void putImageForTag(String tag, ImageDescriptor imageDescriptor) {
        ImageRegistry reg = this.getImageRegistry();
        if (reg != null) {
            reg.put(tag, imageDescriptor);
        }
    }

    protected ImageRegistry getImageRegistry() {
        try {
            if (this.templateTagsImageRegistry == null) {
                this.templateTagsImageRegistry = new ImageRegistry(UIUtils.getDisplay());
            }
            return this.templateTagsImageRegistry;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.projects", (String)EXTENSION_POINT, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                ProjectTemplatesManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{ProjectTemplatesManager.ELEMENT_TEMPLATEINFO});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        if (ELEMENT_TEMPLATEINFO.equals(element.getName())) {
            String id;
            String description;
            String path = null;
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            IConfigurationElement[] localPaths = element.getChildren(ELEMENT_LOCAL);
            if (localPaths.length > 0) {
                String location = localPaths[0].getAttribute(ATTR_LOCATION);
                URL url = bundle.getEntry(location);
                path = ResourceUtil.resourcePathToString((URL)url);
            } else {
                IConfigurationElement[] remotePaths = element.getChildren(ELEMENT_REMOTE);
                if (remotePaths.length > 0) {
                    path = remotePaths[0].getAttribute(ATTR_LOCATION);
                }
            }
            if (StringUtil.isEmpty(path)) {
                return;
            }
            TemplateType type = TemplateType.valueOf((String)element.getAttribute(ATTR_TYPE).toUpperCase());
            String attrAbility = element.getAttribute(ATTR_ABILITY);
            TemplateAbility ability = attrAbility != null ? TemplateAbility.valueOf((String)attrAbility.toUpperCase()) : TemplateAbility.TEMPLATE;
            String name = element.getAttribute(ATTR_NAME);
            if (name == null) {
                name = "";
            }
            if ((description = element.getAttribute(ATTR_DESCRIPTION)) == null) {
                description = "";
            }
            String icon = element.getAttribute(ATTR_ICON);
            URL iconURL = null;
            if (icon != null) {
                iconURL = bundle.getEntry(icon);
            }
            if ((id = element.getAttribute(ATTR_ID)) == null) {
                id = "";
            }
            String priorityStr = element.getAttribute(ATTR_PRIORITY);
            int priority = Integer.MAX_VALUE;
            if (!StringUtil.isEmpty((String)priorityStr)) {
                try {
                    priority = Integer.parseInt(priorityStr);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            boolean replacingParameters = Boolean.parseBoolean(element.getAttribute(ATTR_REPLACE_PARAMETERS));
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(type.toString());
            String natureID = element.getAttribute(ATTR_NATURE_ID);
            if (TemplateType.APP == type) {
                this.addTemplate((IProjectTemplate)new HMobileProjectTemplate(path, type, ability, name, replacingParameters, description, iconURL, id, priority, tags, natureID));
            } else {
                this.addTemplate((IProjectTemplate)new ProjectTemplate(path, type, ability, name, replacingParameters, description, iconURL, id, priority, tags, natureID));
            }
        }
    }

    private void loadTemplatesFromBundles() {
        List templates = BundleManager.getInstance().getProjectTemplates(new IModelFilter(){

            public boolean include(AbstractElement element) {
                return element instanceof ProjectTemplateElement;
            }
        });
        for (IProjectTemplate template : templates) {
            this.addTemplate(template);
        }
    }

    public void addTemplate(IProjectTemplate template) {
        TemplateType type = template.getType();
        List<IProjectTemplate> templates = this.projectTemplates.get(type);
        if (templates == null) {
            templates = new ArrayList<IProjectTemplate>();
            this.projectTemplates.put(type, templates);
        }
        templates.add(template);
        this.fireTemplateAdded(template);
    }

    public void removeTemplate(IProjectTemplate template) {
        TemplateType type = template.getType();
        List<IProjectTemplate> templates = this.projectTemplates.get(type);
        if (templates != null) {
            templates.remove(template);
            this.fireTemplateRemoved(template);
        }
    }

    private void fireTemplateAdded(IProjectTemplate template) {
        for (IProjectTemplateListener listener : this.templateListeners) {
            listener.templateAdded(template);
        }
    }

    private void fireTemplateRemoved(IProjectTemplate template) {
        for (IProjectTemplateListener listener : this.templateListeners) {
            listener.templateRemoved(template);
        }
    }

    public String getUserTemplatePath(TemplateType type) {
        String OS = null;
        if (Platform.isRunning()) {
            OS = Platform.getOS();
        } else {
            OS = System.getProperty(OS_NAME).toLowerCase();
            if (OS.contains(OS_NAME_MAC)) {
                OS = "macosx";
            } else if (OS.contains(OS_NAME_LINUX)) {
                OS = OS_NAME_LINUX;
            }
        }
        String userHome = System.getProperty(USER_HOME_PROPERTY);
        if (OS.equals("macosx") || OS.equals(OS_NAME_LINUX)) {
            return String.valueOf(userHome) + USER_TEMPLATES_DIRECTORY_MACOSX + type.toString().toLowerCase() + ".project";
        }
        return String.valueOf(userHome) + USER_TEMPLATES_DIRECTORY_GENERAL + type.toString().toLowerCase() + ".project";
    }

    public File createUserTemplatePath(TemplateType type) {
        File readme;
        File path = new File(this.getUserTemplatePath(type));
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!(readme = new File(path, README_FILE_NAME)).exists()) {
            try {
                File systemReadme = this.getReadmeFile(type);
                if (systemReadme.exists()) {
                    FileUtil.copyFile((File)systemReadme, (File)readme);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public File getReadmeFile(TemplateType type) throws IOException {
        URL url = ProjectsPlugin.getDefault().getBundle().getResource(READMES + type.toString().toLowerCase() + "." + README_FILE_NAME);
        return new File(FileLocator.toFileURL((URL)url).getFile());
    }
}

