/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.listeners;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.listeners.IStudioProjectListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class StudioProjectListenersManager {
    private final String EXTENSION_POINT = "projectListeners";
    private final String ELEMENT_PROJECT_LISTENER = "projectListener";
    private final String ELEMENT_CLASS = "class";
    private final String ELEMENT_PRIORITY = "priority";
    private final String ELEMENT_PROJECT_NATURE = "natureId";
    private final Map<String, List<ProjectListenerElement>> listeners = new HashMap<String, List<ProjectListenerElement>>();
    private static StudioProjectListenersManager INSTANCE;

    public static synchronized StudioProjectListenersManager getManager() {
        if (INSTANCE == null) {
            INSTANCE = new StudioProjectListenersManager();
        }
        return INSTANCE;
    }

    private StudioProjectListenersManager() {
        this.readExtensionRegistry();
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.projects", (String)"projectListeners", (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                StudioProjectListenersManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{"projectListener"});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        String listenerClass;
        if ("projectListener".equals(element.getName()) && !StringUtil.isEmpty((String)(listenerClass = element.getAttribute("class")))) {
            try {
                IStudioProjectListener listener = (IStudioProjectListener)element.createExecutableExtension("class");
                String priority = element.getAttribute("priority");
                int priorityValue = 100;
                try {
                    priorityValue = Integer.valueOf(priority);
                }
                catch (Exception exception) {}
                String projectNature = element.getAttribute("natureId");
                List<ProjectListenerElement> values = this.listeners.get(projectNature);
                if (values == null) {
                    values = new ArrayList<ProjectListenerElement>();
                    this.listeners.put(projectNature, values);
                }
                values.add(new ProjectListenerElement(listener, priorityValue));
            }
            catch (CoreException coreException) {}
        }
    }

    public IStudioProjectListener[] getProjectListeners(String ... projectNatures) {
        ArrayList<ProjectListenerElement> listenerElements = new ArrayList<ProjectListenerElement>();
        List<ProjectListenerElement> globalListeners = this.listeners.get(null);
        if (globalListeners != null) {
            listenerElements.addAll(globalListeners);
        }
        if (projectNatures != null) {
            String[] stringArray = projectNatures;
            int n = projectNatures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                List<ProjectListenerElement> values = this.listeners.get(nature);
                if (values != null) {
                    listenerElements.addAll(values);
                }
                ++n2;
            }
        }
        Collections.sort(listenerElements, new Comparator<ProjectListenerElement>(){

            @Override
            public int compare(ProjectListenerElement o1, ProjectListenerElement o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.priority - o2.priority;
            }
        });
        ArrayList<IStudioProjectListener> projectListeners = new ArrayList<IStudioProjectListener>();
        for (ProjectListenerElement element : listenerElements) {
            projectListeners.add(element.projectListener);
        }
        return projectListeners.toArray(new IStudioProjectListener[projectListeners.size()]);
    }

    private class ProjectListenerElement {
        int priority;
        IStudioProjectListener projectListener;

        ProjectListenerElement(IStudioProjectListener listener, int priority) {
            this.projectListener = listener;
            this.priority = priority;
        }
    }
}

