/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public class UpgradeUtil {
    public static void upgradeEclipseJar(URL installURL) {
        try {
            if (installURL == null) {
                return;
            }
            URI installURI = installURL.toURI();
            File installDir = new File(installURI);
            if (!installDir.exists()) {
                return;
            }
            File updateDir = new File(installDir, "/configuration/update");
            if (!updateDir.exists()) {
                return;
            }
            File[] jars = updateDir.listFiles();
            if (jars != null && jars.length > 0) {
                File targetDir = new File(installDir, "/plugins");
                File targetFile = null;
                int i = 0;
                while (i < jars.length) {
                    boolean result;
                    File jar = jars[i];
                    String jarName = jar.getName();
                    if (!jarName.contains("org.eclipse.equinox.launcher_") && (result = UpgradeUtil.copy(jar, targetFile = new File(targetDir, jarName)))) {
                        jar.delete();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean copy(File sourceFile, File targetFile) {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

