/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserWindow;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefRenderHandler;

class CefBrowserWr
extends CefBrowser_N {
    private Canvas canvas_ = null;
    private long window_handle_ = 0L;
    private CefClientHandler clientHandler_;
    private String url_;
    private CefRequestContext context_;
    private CefBrowserWr parent_ = null;
    private CefBrowserWr devTools_ = null;

    CefBrowserWr(CefClientHandler clientHandler, String url, CefRequestContext context) {
        this(clientHandler, url, context, null);
    }

    private CefBrowserWr(CefClientHandler clientHandler, String url, CefRequestContext context, CefBrowserWr parent) {
        this.clientHandler_ = clientHandler;
        this.url_ = url;
        this.context_ = context;
        this.parent_ = parent;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.canvas_ = new Canvas(){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                CefBrowserWr.this.wasResized(width, height);
            }

            @Override
            public void setBounds(Rectangle r) {
                this.setBounds(r.x, r.y, r.width, r.height);
            }

            @Override
            public void setSize(int width, int height) {
                super.setSize(width, height);
                CefBrowserWr.this.wasResized(width, height);
            }

            @Override
            public void setSize(Dimension d) {
                this.setSize(d.width, d.height);
            }

            @Override
            public void paint(Graphics g) {
                if (CefBrowserWr.this.getNativeRef("CefBrowser") == 0L) {
                    if (CefBrowserWr.this.parent_ != null) {
                        CefBrowserWr.this.createDevTools(CefBrowserWr.this.parent_, CefBrowserWr.this.clientHandler_, CefBrowserWr.this.getWindowHandle(), false, CefBrowserWr.this.canvas_);
                    } else {
                        CefBrowserWr.this.createBrowser(CefBrowserWr.this.clientHandler_, CefBrowserWr.this.getWindowHandle(), CefBrowserWr.this.url_, false, CefBrowserWr.this.canvas_, CefBrowserWr.this.context_);
                    }
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
            }
        };
        this.canvas_.setFocusable(true);
        this.canvas_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CefBrowserWr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                CefBrowserWr.this.setFocus(true);
            }
        });
        this.canvas_.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    CefBrowserWr.this.setWindowVisibility(e.getChanged().isVisible());
                }
            }
        });
    }

    @Override
    public Component getUIComponent() {
        return this.canvas_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.context_ != null) {
            this.context_.dispose();
        }
        if (this.parent_ != null) {
            this.parent_.closeDevTools();
            this.parent_.devTools_ = null;
            this.parent_ = null;
        }
        super.close();
    }

    @Override
    public synchronized CefBrowser getDevTools() {
        if (this.devTools_ == null) {
            this.devTools_ = new CefBrowserWr(this.clientHandler_, this.url_, this.context_, this);
        }
        return this.devTools_;
    }

    private long getWindowHandle() {
        if (this.window_handle_ == 0L && OS.isMacintosh()) {
            try {
                Class<?> cls = Class.forName("org.cef.browser.mac.CefBrowserWindowMac");
                CefBrowserWindow browserWindow = (CefBrowserWindow)cls.newInstance();
                if (browserWindow != null) {
                    this.window_handle_ = browserWindow.getWindowHandleOfCanvas(this.canvas_);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.window_handle_;
    }
}

