/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.build.util;

import com.aptana.build.util.ParseContext;
import com.aptana.build.util.TimeoutException;

public class AssistHelper {
    private static ThreadLocal<ParseContext> context = new ThreadLocal();

    public static void checkState() {
        if (AssistHelper.isTimeout()) {
            throw new TimeoutException(1);
        }
        if (context.get() != null && Thread.currentThread().isInterrupted()) {
            throw new TimeoutException(-1);
        }
    }

    public static void start() {
        context.set(new ParseContext());
    }

    public static void stop() {
        context.set(null);
    }

    private static boolean isTimeout() {
        ParseContext con = context.get();
        if (con != null) {
            return System.currentTimeMillis() - con.startTime > con.timeout;
        }
        return false;
    }
}

