/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.run;

import beaver.Parser;
import beaver.Scanner;
import beaver.Symbol;
import beaver.comp.ParserGenerator;
import beaver.comp.io.SrcReader;
import beaver.comp.run.Options;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.parser.GrammarScanner;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntTask
extends Task {
    private Options options = new Options();
    private File grammar_file;

    public void setFile(File file) {
        this.grammar_file = file;
    }

    public void setDestdir(File file) {
        this.options.dest_dir = file;
    }

    public void setExportTables(boolean opt) {
        this.options.exp_parsing_tables = opt;
    }

    public void setExportTerminals(boolean opt) {
        this.options.export_terminals = opt;
    }

    public void setSortTerminals(boolean opt) {
        this.options.sort_terminals = opt;
    }

    public void setReportActions(boolean opt) {
        this.options.report_actions = opt;
    }

    public void setCompress(boolean opt) {
        this.options.no_compression = !opt;
    }

    public void setTerminalNames(boolean opt) {
        this.options.terminal_names = opt;
    }

    public void setAnonymousActions(boolean opt) {
        this.options.name_action_classes = !opt;
    }

    public void setUseSwitch(boolean opt) {
        this.options.use_switch = opt;
    }

    public void execute() throws BuildException {
        if (!this.grammar_file.canRead()) {
            throw new BuildException("Cannot read grammar file " + this.grammar_file);
        }
        if (this.options.dest_dir != null && !this.options.dest_dir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(this.options.dest_dir.getPath()) + " is not a directory.");
        }
        SrcReader src = AntTask.getSrcReader(this.grammar_file);
        try {
            if (this.existsCurrentOutput(AntTask.getOutputFileName(src))) {
                return;
            }
        }
        catch (Exception exception) {}
        src.reset();
        Log log = new Log();
        AntTask.compile(src, this.options, log);
        log.report(this.grammar_file.getName(), src);
    }

    private boolean existsCurrentOutput(String output_file_name) {
        String dir = this.grammar_file.getParent();
        File output_file = new File(dir, String.valueOf(output_file_name) + ".java");
        if (!output_file.canRead() || this.grammar_file.lastModified() > output_file.lastModified()) {
            return false;
        }
        output_file = new File(dir, String.valueOf(output_file_name) + ".spec");
        return !this.options.exp_parsing_tables || output_file.canRead() && this.grammar_file.lastModified() <= output_file.lastModified();
    }

    private static SrcReader getSrcReader(File file) throws BuildException {
        try {
            return new SrcReader(file);
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to read grammar file " + file);
        }
    }

    private static String getOutputFileName(SrcReader src) throws IOException, Scanner.Exception {
        String output_file_name = src.file.getName();
        int dot_index = output_file_name.lastIndexOf(46);
        if (dot_index > 0) {
            output_file_name = output_file_name.substring(0, dot_index);
        }
        GrammarScanner scanner = new GrammarScanner(src);
        Symbol sym = scanner.nextToken();
        while (sym.getId() != 0) {
            String class_name;
            if (sym.getId() == 6 && (sym = scanner.nextToken()).getId() == 20 && (class_name = (String)sym.value) != null && (class_name = class_name.trim()).length() > 0) {
                return class_name;
            }
            sym = scanner.nextToken();
        }
        return output_file_name;
    }

    private static void compile(SrcReader src, Options opt, Log log) {
        try {
            ParserGenerator.compile(src, opt, log);
        }
        catch (Parser.Exception e) {
            System.err.print("Error: ");
            System.err.println(e.getMessage());
        }
        catch (Grammar.Exception e) {
            System.err.print("Error: ");
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.print("System Error: ");
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

