/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.core.inference;

import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.core.ast.ASTUtils;
import com.aptana.ruby.core.ast.ClosestSpanningNodeLocator;
import com.aptana.ruby.core.ast.FirstPrecursorNodeLocator;
import com.aptana.ruby.core.ast.INodeAcceptor;
import com.aptana.ruby.core.ast.NamespaceVisitor;
import com.aptana.ruby.core.ast.OffsetNodeLocator;
import com.aptana.ruby.core.ast.ScopedNodeLocator;
import com.aptana.ruby.core.index.RubyIndexUtil;
import com.aptana.ruby.core.inference.ITypeGuess;
import com.aptana.ruby.core.inference.ITypeInferrer;
import com.aptana.ruby.internal.core.inference.BasicTypeGuess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.Parser;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.ReturnNode;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;

public class TypeInferrer
implements ITypeInferrer {
    private static final Map<String, Collection<ITypeGuess>> TYPICAL_METHOD_RETURN_TYPE_NAMES = new HashMap<String, Collection<ITypeGuess>>();
    private IProject project;

    static {
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("capitalize", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("capitalize!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("ceil", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("center", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("chomp", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("chomp!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("chop", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("chop!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("concat", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("count", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("crypt", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("downcase", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("downcase!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("dump", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("floor", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("gets", TypeInferrer.createSet("String", "NilClass"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("gsub", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("gsub!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("hash", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("index", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("inspect", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("intern", TypeInferrer.createSet("Symbol"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("length", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("now", TypeInferrer.createSet("Time"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("round", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("size", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("slice", TypeInferrer.createSet("String", "Array", "NilClass", "Object", "Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("slice!", TypeInferrer.createSet("String", "Array", "NilClass", "Object", "Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("strip", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("strip!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("sub", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("sub!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("swapcase", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("swapcase!", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_a", TypeInferrer.createSet("Array"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_ary", TypeInferrer.createSet("Array"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_i", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_int", TypeInferrer.createSet("Fixnum"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_f", TypeInferrer.createSet("Float"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_proc", TypeInferrer.createSet("Proc"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_s", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_str", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_string", TypeInferrer.createSet("String"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("to_sym", TypeInferrer.createSet("Symbol"));
        TYPICAL_METHOD_RETURN_TYPE_NAMES.put("unpack", TypeInferrer.createSet("Array"));
    }

    public TypeInferrer(IProject project) {
        this.project = project;
    }

    private static Set<ITypeGuess> createSet(String ... strings) {
        if (strings == null || strings.length == 0) {
            return Collections.emptySet();
        }
        int weight = 100 / strings.length;
        HashSet<ITypeGuess> set = new HashSet<ITypeGuess>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            set.add(new BasicTypeGuess(string, weight, true));
            ++n2;
        }
        return set;
    }

    private Collection<ITypeGuess> createSet(Map<String, Boolean> types) {
        if (types == null || types.isEmpty()) {
            return Collections.emptySet();
        }
        int weight = 100 / types.size();
        HashSet<ITypeGuess> set = new HashSet<ITypeGuess>();
        for (Map.Entry<String, Boolean> entry : types.entrySet()) {
            set.add(new BasicTypeGuess(entry.getKey(), weight, entry.getValue()));
        }
        return set;
    }

    @Override
    public Collection<ITypeGuess> infer(String source, int offset) {
        Parser parser = new Parser();
        BufferedReader reader = new BufferedReader(new StringReader(source));
        Node root = null;
        try {
            root = parser.parse("", (Reader)reader, new ParserConfiguration(0, CompatVersion.BOTH));
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException iOException) {}
        if (root == null) {
            return Collections.emptyList();
        }
        Node atOffset = new OffsetNodeLocator().find(root, offset);
        if (atOffset == null) {
            return Collections.emptyList();
        }
        return this.infer(root, atOffset);
    }

    @Override
    public Collection<ITypeGuess> infer(Node rootNode, Node toInfer) {
        if (toInfer == null) {
            return TypeInferrer.createSet("Object");
        }
        switch (toInfer.getNodeType()) {
            case CONSTNODE: {
                return this.inferConstant(rootNode, (ConstNode)toInfer);
            }
            case CALLNODE: 
            case FCALLNODE: 
            case VCALLNODE: {
                return this.inferMethod(rootNode, (INameNode)toInfer);
            }
            case DSYMBOLNODE: 
            case SYMBOLNODE: {
                return TypeInferrer.createSet("Symbol");
            }
            case ARRAYNODE: 
            case ZARRAYNODE: {
                return TypeInferrer.createSet("Array");
            }
            case BIGNUMNODE: {
                return TypeInferrer.createSet("Bignum");
            }
            case FIXNUMNODE: {
                return TypeInferrer.createSet("Fixnum");
            }
            case FLOATNODE: {
                return TypeInferrer.createSet("Float");
            }
            case HASHNODE: {
                return TypeInferrer.createSet("Hash");
            }
            case DREGEXPNODE: 
            case REGEXPNODE: {
                return TypeInferrer.createSet("Regexp");
            }
            case TRUENODE: {
                return TypeInferrer.createSet("TrueClass");
            }
            case FALSENODE: {
                return TypeInferrer.createSet("FalseClass");
            }
            case NILNODE: {
                return TypeInferrer.createSet("NilClass");
            }
            case DSTRNODE: 
            case DXSTRNODE: 
            case STRNODE: 
            case XSTRNODE: {
                return TypeInferrer.createSet("String");
            }
            case LOCALVARNODE: {
                return this.inferLocal(rootNode, (LocalVarNode)toInfer);
            }
            case INSTVARNODE: {
                return this.inferInstance(rootNode, (InstVarNode)toInfer);
            }
            case CLASSVARNODE: {
                return this.inferClassVar(rootNode, (ClassVarNode)toInfer);
            }
            case COLON2NODE: {
                return this.inferColon2Node((Colon2Node)toInfer);
            }
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case MULTIPLEASGN19NODE: {
                AssignableNode assignable = (AssignableNode)toInfer;
                return this.infer(rootNode, assignable.getValueNode());
            }
        }
        return TypeInferrer.createSet("Object");
    }

    private Collection<ITypeGuess> inferConstant(Node rootNode, ConstNode toInfer) {
        NamespaceVisitor visitor = new NamespaceVisitor();
        String implicitNamespace = visitor.getNamespace(rootNode, toInfer.getPosition().getStartOffset());
        String constantName = toInfer.getName();
        Map<String, Boolean> types = this.matchingTypes(String.valueOf(implicitNamespace) + "::" + constantName);
        if (types.isEmpty() && implicitNamespace.length() > 0) {
            types = this.matchingTypes(constantName);
        }
        if (types.isEmpty()) {
            return TypeInferrer.createSet(constantName);
        }
        return this.createSet(types);
    }

    private Map<String, Boolean> matchingTypes(String fullyQualifiedName) {
        HashMap<String, Boolean> matches = new HashMap<String, Boolean>();
        if (fullyQualifiedName.startsWith("::")) {
            fullyQualifiedName = fullyQualifiedName.substring(2);
        }
        String typeName = fullyQualifiedName;
        String namespace = "";
        int lastNS = typeName.lastIndexOf("::");
        if (lastNS != -1) {
            namespace = typeName.substring(0, lastNS);
            typeName = typeName.substring(lastNS + 2);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('^');
        builder.append(typeName);
        builder.append('/');
        builder.append(namespace);
        builder.append('/');
        builder.append(".+$");
        String key = builder.toString();
        for (Index index : this.getAllIndicesForProject()) {
            if (index == null) continue;
            List results = index.query(new String[]{"typeDecl"}, key, 24);
            if (results == null) continue;
            for (QueryResult result : results) {
                String word = result.getWord();
                String[] parts = word.split(Character.toString('/'));
                StringBuilder fullName = new StringBuilder();
                if (parts[1].length() > 0) {
                    fullName.append(parts[1]);
                    fullName.append("::");
                }
                fullName.append(parts[0]);
                boolean isClass = parts[2].equals(Character.valueOf('C'));
                matches.put(fullName.toString(), isClass);
            }
        }
        return matches;
    }

    private Collection<ITypeGuess> inferInstance(Node rootNode, InstVarNode toInfer) {
        return this.inferClassOrInstanceVar(rootNode, (INameNode)toInfer, NodeType.INSTASGNNODE);
    }

    private Collection<ITypeGuess> inferClassVar(Node rootNode, ClassVarNode toInfer) {
        return this.inferClassOrInstanceVar(rootNode, (INameNode)toInfer, NodeType.CLASSVARASGNNODE, NodeType.CLASSVARDECLNODE);
    }

    private Collection<ITypeGuess> inferClassOrInstanceVar(Node rootNode, INameNode varRefNode, final NodeType ... nodeTypes) {
        List<Node> assigns;
        final String varName = varRefNode.getName();
        Node enclosingTypeNode = this.enclosingType(rootNode, ((Node)varRefNode).getPosition().getStartOffset());
        if (enclosingTypeNode == null) {
            enclosingTypeNode = rootNode;
        }
        if ((assigns = new ScopedNodeLocator().find(enclosingTypeNode, new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                boolean found = false;
                NodeType[] nodeTypeArray = nodeTypes;
                int n = nodeTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeType type = nodeTypeArray[n2];
                    if (node.getNodeType() == type) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    return false;
                }
                return ((INameNode)node).getName().equals(varName);
            }
        })) == null) {
            return TypeInferrer.createSet("Object");
        }
        ArrayList<ITypeGuess> guesses = new ArrayList<ITypeGuess>();
        for (Node assignment : assigns) {
            AssignableNode assignmentNode = (AssignableNode)assignment;
            guesses.addAll(this.infer(rootNode, assignmentNode.getValueNode()));
        }
        return guesses;
    }

    private Node enclosingType(Node rootNode, int startOffset) {
        return new ClosestSpanningNodeLocator().find(rootNode, startOffset, new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node.getNodeType() == NodeType.CLASSNODE || node.getNodeType() == NodeType.MODULENODE;
            }
        });
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<ITypeGuess> inferColon2Node(Colon2Node toInfer) {
        List<Node> decls;
        Node root;
        Reader reader;
        String fullName;
        block25: {
            String constantName;
            block24: {
                fullName = ASTUtils.getFullyQualifiedName(toInfer);
                String namespace = "";
                String typeName = "";
                constantName = fullName;
                int namespaceIndex = fullName.lastIndexOf("::");
                if (namespaceIndex != -1) {
                    typeName = fullName.substring(0, namespaceIndex);
                    constantName = fullName.substring(namespaceIndex + 2);
                    namespaceIndex = typeName.lastIndexOf("::");
                    if (namespaceIndex != -1) {
                        namespace = typeName.substring(0, namespaceIndex);
                        typeName = typeName.substring(namespaceIndex + 2);
                    }
                }
                String key = String.valueOf(constantName) + '/' + typeName + '/' + namespace;
                String matchingDocURI = null;
                for (Index index : this.getAllIndicesForProject()) {
                    List results;
                    if (index == null || (results = index.query(new String[]{"constantDecl"}, key, 8)) == null || results.isEmpty()) continue;
                    Iterator iterator = results.iterator();
                    if (iterator.hasNext()) {
                        QueryResult result = (QueryResult)iterator.next();
                        matchingDocURI = (String)result.getDocuments().iterator().next();
                    }
                    if (matchingDocURI != null) break;
                }
                if (matchingDocURI == null) return TypeInferrer.createSet(fullName);
                reader = null;
                IFileStore store = EFS.getStore((URI)URI.create(matchingDocURI));
                InputStream stream = store.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                reader = new BufferedReader(new InputStreamReader(stream));
                Parser parser = new Parser();
                root = parser.parse("", reader, new ParserConfiguration(0, CompatVersion.BOTH));
                if (root != null) break block24;
                List<ITypeGuess> list = Collections.emptyList();
                if (reader == null) return list;
                try {
                    reader.close();
                    return list;
                }
                catch (IOException iOException) {}
                return list;
            }
            final String theConstantName = constantName;
            decls = new ScopedNodeLocator().find(root, new INodeAcceptor(){

                @Override
                public boolean accepts(Node node) {
                    if (!(node instanceof ConstDeclNode)) {
                        return false;
                    }
                    ConstDeclNode declNode = (ConstDeclNode)node;
                    return declNode.getName().equals(theConstantName);
                }
            });
            if (decls != null && !decls.isEmpty()) break block25;
            List<ITypeGuess> list = Collections.emptyList();
            if (reader == null) return list;
            try {
                reader.close();
                return list;
            }
            catch (IOException iOException) {}
            return list;
        }
        Collection<ITypeGuess> collection = this.infer(root, decls.iterator().next());
        if (reader == null) return collection;
        try {
            reader.close();
            return collection;
        }
        catch (IOException iOException) {}
        return collection;
        catch (SyntaxException syntaxException) {
            if (reader == null) return TypeInferrer.createSet(fullName);
            try {
                reader.close();
                return TypeInferrer.createSet(fullName);
            }
            catch (IOException iOException) {}
            return TypeInferrer.createSet(fullName);
        }
        catch (CoreException e) {
            IdeLog.log((Plugin)RubyCorePlugin.getDefault(), (IStatus)e.getStatus());
            if (reader == null) return TypeInferrer.createSet(fullName);
            {
                catch (Throwable throwable) {
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                reader.close();
                return TypeInferrer.createSet(fullName);
            }
            catch (IOException iOException) {}
            return TypeInferrer.createSet(fullName);
        }
    }

    protected Collection<Index> getAllIndicesForProject() {
        return RubyIndexUtil.allIndices(this.project);
    }

    private Collection<ITypeGuess> inferLocal(Node rootNode, LocalVarNode toInfer) {
        final String varName = toInfer.getName();
        Node precedingAssignment = new FirstPrecursorNodeLocator().find(rootNode, toInfer.getPosition().getStartOffset() - 1, new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node.getNodeType() == NodeType.LOCALASGNNODE && ((INameNode)node).getName().equals(varName);
            }
        });
        if (precedingAssignment != null) {
            LocalAsgnNode assign = (LocalAsgnNode)precedingAssignment;
            return this.infer(rootNode, assign.getValueNode());
        }
        return TypeInferrer.createSet("Object");
    }

    private Collection<ITypeGuess> inferMethod(Node rootNode, INameNode toInfer) {
        final String methodName = toInfer.getName();
        if (methodName.endsWith("?")) {
            return TypeInferrer.createSet("TrueClass", "FalseClass");
        }
        Collection<ITypeGuess> guesses = TYPICAL_METHOD_RETURN_TYPE_NAMES.get(methodName);
        if (guesses == null) {
            if (toInfer instanceof CallNode) {
                if ("new".equals(methodName)) {
                    Node receiver = ((CallNode)toInfer).getReceiverNode();
                    return this.infer(rootNode, receiver);
                }
            } else {
                guesses = new ArrayList<ITypeGuess>();
                Node enclosingType = this.enclosingType(rootNode, ((Node)toInfer).getPosition().getStartOffset());
                List<Node> methods = new ScopedNodeLocator().find(enclosingType, new INodeAcceptor(){

                    @Override
                    public boolean accepts(Node node) {
                        return NodeType.DEFNNODE == node.getNodeType() && methodName.equals(((DefnNode)node).getName());
                    }
                });
                if (!methods.isEmpty()) {
                    for (Node methodNode : methods) {
                        List<Node> returnNodes = new ScopedNodeLocator().find(methodNode, new INodeAcceptor(){

                            @Override
                            public boolean accepts(Node node) {
                                return NodeType.RETURNNODE == node.getNodeType();
                            }
                        });
                        if (returnNodes.isEmpty()) continue;
                        for (Node returnNode : returnNodes) {
                            ReturnNode blah = (ReturnNode)returnNode;
                            guesses.addAll(this.infer(rootNode, blah.getValueNode()));
                        }
                    }
                }
            }
            return Collections.emptySet();
        }
        return guesses;
    }
}

