/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.core.index;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexContainerJob;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.core.RubyProjectNature;
import com.aptana.ruby.internal.core.index.Messages;
import com.aptana.ruby.internal.core.index.RubyFileIndexingParticipant;
import com.aptana.ruby.launching.RubyLaunchingPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class CoreStubber
extends Job {
    private static final String CORE_STUBBER_PATH = "ruby/core_stubber.rb";
    private static final String FINISH_MARKER_FILENAME = "finish_marker";
    private static final String CORE_STUBBER_VERSION = "4";
    protected static boolean fgOutOfDate = false;

    public CoreStubber() {
        super("Generating stubs for Ruby Core");
        this.setPriority(30);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CoreStubber_TaskName, (int)100);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask(Messages.CoreStubber_RubyFilesCheckMsg);
        if (!this.isRubyFileInWorkspace((IProgressMonitor)sub.newChild(10))) {
            RubyFileListener fResourceListener = new RubyFileListener(this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)fResourceListener, 1);
            return Status.CANCEL_STATUS;
        }
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            IndexRubyContainerJob job;
            Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (ArrayUtil.isEmpty((Object[])projects)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.CoreStubber_GatherRubyInstallsMsg);
            Set<IPath> rubyExes = this.gatherRubyExecutables((IProject[])projects, (IProgressMonitor)sub.newChild(20));
            if (CollectionsUtil.isEmpty(rubyExes)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.CoreStubber_GatherLoadpathsMsg);
            Set<IPath> pathsToIndex = this.gatherPathsToIndex((IProject[])projects, (IProgressMonitor)sub.newChild(10));
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            sub.subTask(Messages.CoreStubber_GenerateActualStubsMsg);
            Set<File> stubDirs = this.generateStubs(rubyExes, (IProgressMonitor)sub.newChild(50));
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.checkIndexVersion();
            final ArrayList<IndexRubyContainerJob> jobs = new ArrayList<IndexRubyContainerJob>();
            int totalWorkUnits = 0;
            for (File stubDir : stubDirs) {
                job = this.indexCoreStubs(stubDir);
                if (job == null) continue;
                totalWorkUnits += job.workUnits();
                jobs.add(job);
            }
            for (IPath pathToIndex : pathsToIndex) {
                job = this.indexFiles(pathToIndex.toFile().toURI());
                if (job == null) continue;
                totalWorkUnits += job.workUnits();
                jobs.add(job);
            }
            sub.worked(10);
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                sub.subTask(Messages.CoreStubber_IndexSubTaskName);
                final IProgressMonitor pm = Job.getJobManager().createProgressGroup();
                pm.beginTask(Messages.CoreStubber_IndexingRuby, totalWorkUnits);
                for (IndexRubyContainerJob job2 : jobs) {
                    job2.setProgressGroup(pm, job2.workUnits());
                    job2.schedule();
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (Job job : jobs) {
                            try {
                                job.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (!pm.isCanceled()) {
                            pm.done();
                            CoreStubber.this.storeIndexVersion();
                        }
                    }
                }, "Ruby CoreStubber thread");
                t.start();
            }
            catch (Exception e) {
                Status status = new Status(4, "com.aptana.ruby.core", e.getMessage(), (Throwable)e);
                return status;
            }
        }
        finally {
            sub.done();
        }
        return Status.OK_STATUS;
    }

    private void checkIndexVersion() {
        int currentVersion = Platform.getPreferencesService().getInt("com.aptana.ruby.core", "index_version", -1, null);
        if (currentVersion != 5) {
            fgOutOfDate = true;
        }
    }

    private Set<File> generateStubs(Set<IPath> rubyExes, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)rubyExes.size());
        HashSet<File> stubDirs = new HashSet<File>();
        for (IPath rubyExe : rubyExes) {
            String rubyVersion = RubyLaunchingPlugin.getRubyVersion((IPath)rubyExe);
            File outputDir = CoreStubber.getRubyCoreStubDir(rubyVersion);
            if (outputDir == null) continue;
            stubDirs.add(outputDir);
            File finishMarker = new File(outputDir, FINISH_MARKER_FILENAME);
            if (!finishMarker.exists()) {
                try {
                    this.generateCoreStubs(rubyExe, outputDir, finishMarker);
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (Throwable)e);
                }
            }
            sub.worked(1);
        }
        sub.done();
        return stubDirs;
    }

    private Set<IPath> gatherPathsToIndex(IProject[] projects, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * (projects.length + 1)));
        HashSet<IPath> pathsToIndex = new HashSet<IPath>();
        if (!"win32".equals(Platform.getOS())) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project != null && project.isAccessible()) {
                    pathsToIndex.addAll(CoreStubber.getUniqueLoadpaths(project));
                    sub.worked(1);
                    pathsToIndex.addAll(RubyLaunchingPlugin.getGemPaths((IProject)project));
                    sub.worked(1);
                }
                ++n2;
            }
        }
        sub.setWorkRemaining(2);
        pathsToIndex.addAll(CoreStubber.getUniqueLoadpaths(null));
        pathsToIndex.addAll(RubyLaunchingPlugin.getGemPaths(null));
        sub.done();
        return pathsToIndex;
    }

    private Set<IPath> gatherRubyExecutables(IProject[] projects, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(projects.length + 1));
        HashSet<IPath> rubyExes = new HashSet<IPath>();
        if (!"win32".equals(Platform.getOS())) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project != null && project.isAccessible()) {
                    IPath rubyExe = RubyLaunchingPlugin.rubyExecutablePath((IPath)project.getLocation());
                    if (rubyExe != null) {
                        rubyExes.add(rubyExe);
                    }
                    sub.worked(1);
                }
                ++n2;
            }
        }
        sub.setWorkRemaining(1);
        rubyExes.add(RubyLaunchingPlugin.rubyExecutablePath(null));
        sub.done();
        return rubyExes;
    }

    private boolean isRubyFileInWorkspace(IProgressMonitor monitor) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible()) {
                    RubyFileDetectingVisitor visitor = new RubyFileDetectingVisitor(project);
                    project.accept((IResourceProxyVisitor)visitor, 0);
                    if (visitor.found()) {
                        RubyProjectNature.add(project, (IProgressMonitor)new NullProgressMonitor());
                        return true;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRubyFile(IProject project, String filename) {
        try {
            IContentType[] types;
            IContentType[] iContentTypeArray = types = project.getContentTypeMatcher().findContentTypesFor(filename);
            int n = types.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IContentType type = iContentTypeArray[n2];
                if ("com.aptana.contenttype.ruby".equals(type.getId())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected static File getRubyCoreStubDir(IProject project) {
        String rubyVersion = RubyLaunchingPlugin.getRubyVersionForProject((IProject)project);
        if (rubyVersion == null) {
            return null;
        }
        return CoreStubber.getRubyCoreStubDir(rubyVersion);
    }

    protected static File getRubyCoreStubDir(String rubyVersion) {
        IPath outputPath = RubyCorePlugin.getDefault().getStateLocation().append(Integer.toString(rubyVersion.hashCode())).append(CORE_STUBBER_VERSION);
        return outputPath.toFile();
    }

    protected List<Job> indexGems(IProject project) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (IPath gemPath : RubyLaunchingPlugin.getGemPaths((IProject)project)) {
            jobs.add((Job)this.indexFiles(gemPath.toFile().toURI()));
        }
        return jobs;
    }

    protected List<Job> indexStdLib(Set<IPath> uniqueLoadPaths) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (IPath loadpath : uniqueLoadPaths) {
            IndexRubyContainerJob job = this.indexFiles(loadpath.toFile().toURI());
            if (job == null) continue;
            jobs.add((Job)job);
        }
        return jobs;
    }

    protected IndexRubyContainerJob indexCoreStubs(File outputDir) {
        return this.indexFiles(Messages.CoreStubber_IndexingRubyCore, outputDir.toURI());
    }

    protected void generateCoreStubs(IPath rubyExe, File outputDir, File finishMarker) throws IOException {
        IStatus stubberResult;
        URL url = FileLocator.find((Bundle)RubyCorePlugin.getDefault().getBundle(), (IPath)new Path(CORE_STUBBER_PATH), null);
        File stubberScript = ResourceUtil.resourcePathToFile((URL)url);
        Map env = null;
        if (!"win32".equals(Platform.getOS())) {
            env = ShellExecutable.getEnvironment();
        }
        if ((stubberResult = ProcessUtil.runInBackground((String)(rubyExe == null ? "ruby" : rubyExe.toOSString()), null, (Map)env, (String[])new String[]{stubberScript.getAbsolutePath(), outputDir.getAbsolutePath()})) == null || !stubberResult.isOK()) {
            RubyCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "com.aptana.ruby.core", stubberResult == null ? "" : stubberResult.getMessage(), null));
        } else {
            finishMarker.createNewFile();
        }
    }

    protected IndexRubyContainerJob indexFiles(String message, URI outputDir) {
        return new IndexRubyContainerJob(message, outputDir);
    }

    protected IndexRubyContainerJob indexFiles(URI outputDir) {
        return new IndexRubyContainerJob(outputDir);
    }

    protected void storeIndexVersion() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.ruby.core");
        prefs.putInt("index_version", 5);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (Throwable)e);
        }
    }

    public static Collection<Index> getStdLibIndices(IProject iProject) {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (IPath path : CoreStubber.getUniqueLoadpaths(iProject)) {
            indices.add(CoreStubber.getIndexManager().getIndex(path.toFile().toURI()));
        }
        return indices;
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    private static Collection<IPath> getUniqueLoadpaths(IProject project) {
        ArrayList dupe = new ArrayList(RubyLaunchingPlugin.getLoadpaths((IProject)project));
        Collections.sort(dupe, new Comparator<IPath>(){

            @Override
            public int compare(IPath p1, IPath p2) {
                return p1.segmentCount() - p2.segmentCount();
            }
        });
        HashSet<IPath> uniques = new HashSet<IPath>();
        for (IPath current : dupe) {
            boolean add = true;
            if (!uniques.isEmpty()) {
                for (IPath unique : uniques) {
                    if (!unique.isPrefixOf(current)) continue;
                    add = false;
                    break;
                }
            }
            if (!add) continue;
            uniques.add(current);
        }
        return uniques;
    }

    public static Index getRubyCoreIndex(IProject project) {
        File stubDir = CoreStubber.getRubyCoreStubDir(project);
        if (stubDir == null) {
            return null;
        }
        return CoreStubber.getIndexManager().getIndex(stubDir.toURI());
    }

    private static class IndexRubyContainerJob
    extends IndexContainerJob {
        private Integer fWorkUnits;

        private IndexRubyContainerJob(URI outputDir) {
            super(outputDir, null);
        }

        private IndexRubyContainerJob(String message, URI outputDir) {
            super(message, outputDir, null);
        }

        protected List<IFileStoreIndexingParticipant> getIndexParticipants(IFileStore file) {
            ArrayList<IFileStoreIndexingParticipant> participants = new ArrayList<IFileStoreIndexingParticipant>();
            participants.add((IFileStoreIndexingParticipant)new RubyFileIndexingParticipant());
            return participants;
        }

        protected Set<IFileStore> filterFilesByTimestamp(long indexLastModified, Set<IFileStore> files) {
            Set firstPass = fgOutOfDate ? files : super.filterFilesByTimestamp(indexLastModified, files);
            if (CollectionsUtil.isEmpty(firstPass)) {
                return firstPass;
            }
            IContentTypeManager manager = Platform.getContentTypeManager();
            HashSet<IContentType> types = new HashSet<IContentType>();
            types.add(manager.getContentType("com.aptana.contenttype.ruby"));
            types.add(manager.getContentType("com.aptana.contenttype.ruby.ambiguous"));
            HashSet<IFileStore> filtered = new HashSet<IFileStore>();
            for (IFileStore store : firstPass) {
                if (!this.hasType(store, types)) continue;
                filtered.add(store);
            }
            return filtered;
        }

        protected boolean hasType(IFileStore store, Set<IContentType> types) {
            if (CollectionsUtil.isEmpty(types)) {
                return false;
            }
            String name = store.getName();
            for (IContentType type : types) {
                if (type == null || !type.isAssociatedWith(name)) continue;
                return true;
            }
            return false;
        }

        int workUnits() {
            if (this.fWorkUnits == null) {
                URI uri = this.getContainerURI();
                if (uri.getScheme().equals("file")) {
                    IPath workingDir = Path.fromPortableString((String)uri.getPath());
                    File file = workingDir.toFile();
                    this.fWorkUnits = FileUtil.countFiles((File)file);
                } else {
                    this.fWorkUnits = 100;
                }
            }
            return this.fWorkUnits;
        }
    }

    private static class RubyFileDetectingVisitor
    implements IResourceProxyVisitor {
        private IProject fProject;
        private boolean fFound;

        RubyFileDetectingVisitor(IProject project) {
            this.fProject = project;
            this.fFound = false;
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.fFound) {
                return false;
            }
            if (proxy.getType() == 1 && CoreStubber.isRubyFile(this.fProject, proxy.getName())) {
                this.fFound = true;
                return false;
            }
            return true;
        }

        public boolean found() {
            return this.fFound;
        }
    }

    private static final class RubyFileListener
    implements IResourceChangeListener {
        private CoreStubber stubber;

        private RubyFileListener(CoreStubber stubber) {
            this.stubber = stubber;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                final boolean[] found = new boolean[1];
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (found[0]) {
                            return false;
                        }
                        IResource resource = delta.getResource();
                        if (resource.getType() == 1) {
                            if (CoreStubber.isRubyFile(resource.getProject(), resource.getName())) {
                                found[0] = true;
                            }
                            return false;
                        }
                        if (resource.getType() == 8 || resource.getType() == 2) {
                            return true;
                        }
                        if (resource.getType() == 4) {
                            if (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && resource.isAccessible()) {
                                IProject project = resource.getProject();
                                RubyFileDetectingVisitor visitor = new RubyFileDetectingVisitor(project);
                                project.accept((IResourceProxyVisitor)visitor, 0);
                                if (visitor.found()) {
                                    found[0] = true;
                                    return false;
                                }
                            } else {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                if (found[0]) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                    this.stubber.schedule();
                }
            }
            catch (CoreException e) {
                IdeLog.log((Plugin)RubyCorePlugin.getDefault(), (IStatus)e.getStatus());
            }
        }
    }
}

