/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.core.codeassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.ruby.core.IRubyElement;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.core.ast.ASTUtils;
import com.aptana.ruby.core.ast.ClosestSpanningNodeLocator;
import com.aptana.ruby.core.ast.FirstPrecursorNodeLocator;
import com.aptana.ruby.core.ast.INodeAcceptor;
import com.aptana.ruby.core.ast.NamespaceVisitor;
import com.aptana.ruby.core.codeassist.CodeResolver;
import com.aptana.ruby.core.codeassist.ResolutionTarget;
import com.aptana.ruby.core.codeassist.ResolveContext;
import com.aptana.ruby.core.index.RubyIndexUtil;
import com.aptana.ruby.core.inference.ITypeGuess;
import com.aptana.ruby.internal.core.NamedMember;
import com.aptana.ruby.internal.core.RubyScript;
import com.aptana.ruby.internal.core.inference.TypeInferrer;
import com.aptana.ruby.launching.RubyLaunchingPlugin;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.Colon2MethodNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.lexer.SyntaxException;

public class RubyCodeResolver
extends CodeResolver {
    private static final String RB_SUFFIX = ".rb";
    private static final String LOAD = "load";
    private static final String REQUIRE = "require";
    private static final String NAMESPACE_DELIMITER = "::";
    private ResolveContext fContext;

    @Override
    public void resolve(ResolveContext context) {
        this.fContext = context;
        try {
            Node atOffset = context.getSelectedNode();
            if (atOffset == null) {
                return;
            }
            try {
                switch (atOffset.getNodeType()) {
                    case FCALLNODE: 
                    case VCALLNODE: {
                        this.addAll(this.noReceiverMethodCallLink((INameNode)atOffset));
                        break;
                    }
                    case CALLNODE: {
                        this.addAll(this.methodCallLink((CallNode)atOffset));
                        break;
                    }
                    case COLON3NODE: 
                    case CONSTNODE: {
                        this.addAll(this.constNode(atOffset));
                        break;
                    }
                    case COLON2NODE: {
                        this.addAll(this.typeName((Colon2Node)atOffset));
                        break;
                    }
                    case LOCALVARNODE: {
                        this.addAll(this.localVariableDeclaration(atOffset));
                        break;
                    }
                    case INSTVARNODE: {
                        this.addAll(this.instanceVariableDeclaration(atOffset));
                        break;
                    }
                    case CLASSVARNODE: {
                        this.addAll(this.classVariableDeclaration(atOffset));
                        break;
                    }
                    case STRNODE: {
                        this.addAll(this.requireOrLoad(atOffset));
                        break;
                    }
                }
            }
            catch (SyntaxException syntaxException) {}
        }
        finally {
            this.fContext = null;
        }
    }

    private void addAll(Collection<ResolutionTarget> targets) {
        if (targets != null) {
            this.fContext.addResolved(targets);
        }
    }

    private Collection<ResolutionTarget> noReceiverMethodCallLink(INameNode atOffset) {
        String methodName = atOffset.getName();
        return this.findMethods(methodName);
    }

    private Collection<ResolutionTarget> localVariableDeclaration(Node atOffset) {
        return this.variableDeclaration(atOffset, NodeType.LOCALASGNNODE);
    }

    private Collection<ResolutionTarget> instanceVariableDeclaration(Node atOffset) {
        return this.variableDeclaration(atOffset, NodeType.INSTASGNNODE);
    }

    private Collection<ResolutionTarget> classVariableDeclaration(Node atOffset) {
        return this.variableDeclaration(atOffset, NodeType.CLASSVARASGNNODE);
    }

    private Collection<ResolutionTarget> variableDeclaration(Node atOffset, final NodeType nodeType) {
        Node decl = new FirstPrecursorNodeLocator().find(this.getRoot(), atOffset.getPosition().getStartOffset() - 1, new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node.getNodeType() == nodeType;
            }
        });
        if (decl != null) {
            ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
            links.add(new ResolutionTarget(this.fContext.getURI(), (IRange)new Range(decl.getPosition().getStartOffset(), decl.getPosition().getEndOffset())));
            return links;
        }
        return Collections.emptyList();
    }

    private Collection<ResolutionTarget> constNode(Node atOffset) {
        String namespace = new NamespaceVisitor().getNamespace(this.getRoot(), atOffset.getPosition().getStartOffset());
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        String constantName = ((INameNode)atOffset).getName();
        links.addAll(this.findConstant(constantName));
        if (namespace.length() > 0) {
            constantName = String.valueOf(namespace) + NAMESPACE_DELIMITER + constantName;
        }
        links.addAll(this.findType(constantName));
        return links;
    }

    private Collection<ResolutionTarget> typeName(Colon2Node atOffset) {
        if (atOffset instanceof Colon2MethodNode) {
            return this.noReceiverMethodCallLink((INameNode)atOffset);
        }
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        String fullyQualifiedTypeName = ASTUtils.getFullyQualifiedName(atOffset);
        links.addAll(this.findType(fullyQualifiedTypeName));
        return links;
    }

    private Collection<ResolutionTarget> findConstant(String constantName) {
        Index index = this.getIndex();
        if (index == null) {
            return Collections.emptyList();
        }
        List results = index.query(new String[]{"constantDecl"}, String.valueOf(constantName) + '/', 9);
        return this.getMatchingElementHyperlinks(results, constantName, 7);
    }

    private Index getIndex() {
        return RubyIndexUtil.getIndex(this.getProject());
    }

    private IRange createRange(IRubyElement p) {
        if (p instanceof NamedMember) {
            NamedMember nm = (NamedMember)p;
            return nm.getNameNode().getNameRange();
        }
        return new Range(p.getStartingOffset(), p.getEndingOffset());
    }

    private RubyScript parseURI(String doc) {
        try {
            IFileStore store = EFS.getStore((URI)URI.create(doc));
            return (RubyScript)ParserPoolFactory.parse((String)"com.aptana.contenttype.ruby", (String)IOUtil.read((InputStream)store.openInputStream(0, (IProgressMonitor)new NullProgressMonitor()))).getRootNode();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private Collection<ResolutionTarget> methodCallLink(CallNode callNode) {
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        String methodName = callNode.getName();
        if ("new".equals(methodName)) {
            Node receiver = callNode.getReceiverNode();
            Collection<ITypeGuess> guesses = new TypeInferrer(this.getProject()).infer(this.getRoot(), receiver);
            for (ITypeGuess guess : guesses) {
                links.addAll(this.findType(guess.getType()));
            }
        } else {
            links.addAll(this.findMethods(methodName));
        }
        return links;
    }

    private Node getRoot() throws SyntaxException {
        return this.fContext.getAST();
    }

    private Collection<ResolutionTarget> findMethods(String methodName) {
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        for (Index index : RubyIndexUtil.allIndices(this.getProject())) {
            if (index == null) continue;
            List results = index.query(new String[]{"methodDecl"}, String.valueOf(methodName) + '/', 9);
            links.addAll(this.getMatchingElementHyperlinks(results, methodName, 3));
        }
        return links;
    }

    private Collection<ResolutionTarget> findType(String typeName) {
        String namespace = "";
        int separatorIndex = typeName.indexOf(NAMESPACE_DELIMITER);
        if (separatorIndex != -1) {
            namespace = typeName.substring(0, separatorIndex);
            typeName = typeName.substring(separatorIndex + 2);
        }
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        for (Index index : RubyIndexUtil.allIndices(this.getProject())) {
            if (index == null) continue;
            List results = index.query(new String[]{"typeDecl"}, String.valueOf(typeName) + '/' + namespace + '/', 9);
            links.addAll(this.getMatchingElementHyperlinks(results, typeName, 2));
        }
        return links;
    }

    protected IProject getProject() {
        URI uri = this.fContext.getURI();
        if ("file".equals(uri.getScheme())) {
            IPath path = Path.fromOSString((String)uri.getPath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (file != null) {
                return file.getProject();
            }
        }
        return null;
    }

    private Collection<ResolutionTarget> getMatchingElementHyperlinks(List<QueryResult> results, String elementName, int elementType) {
        if (results == null) {
            return Collections.emptyList();
        }
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        for (QueryResult result : results) {
            Set docs = result.getDocuments();
            for (String doc : docs) {
                RubyScript root = this.parseURI(doc);
                if (root == null) continue;
                List<IRubyElement> possible = root.getChildrenOfTypeRecursive(elementType);
                for (IRubyElement p : possible) {
                    if (!elementName.equals(p.getName())) continue;
                    links.add(new ResolutionTarget(URI.create(doc), this.createRange(p)));
                }
            }
        }
        return links;
    }

    private Collection<ResolutionTarget> requireOrLoad(Node atOffset) {
        Node spanningMethod = new ClosestSpanningNodeLocator().find(this.getRoot(), atOffset.getPosition().getStartOffset(), new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return NodeType.FCALLNODE == node.getNodeType();
            }
        });
        if (spanningMethod == null) {
            return Collections.emptyList();
        }
        String methodName = ((FCallNode)spanningMethod).getName();
        if (!REQUIRE.equals(methodName) && !LOAD.equals(methodName)) {
            return Collections.emptyList();
        }
        StrNode string = (StrNode)atOffset;
        String value = string.getValue();
        if (!value.endsWith(RB_SUFFIX)) {
            value = String.valueOf(value) + RB_SUFFIX;
        }
        ArrayList<ResolutionTarget> links = new ArrayList<ResolutionTarget>();
        for (IPath path : RubyLaunchingPlugin.getLoadpaths((IProject)this.getProject())) {
            IPath possible = path.append(value);
            if (!possible.toFile().exists()) continue;
            links.add(new ResolutionTarget(possible.toFile().toURI(), (IRange)new Range(0, 0)));
            return links;
        }
        for (IPath path : RubyLaunchingPlugin.getGemPaths((IProject)this.getProject())) {
            File[] fileArray = path.toFile().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File gemDir = fileArray[n2];
                IPath possible = Path.fromOSString((String)gemDir.getAbsolutePath()).append("lib").append(value);
                if (possible.toFile().exists()) {
                    links.add(new ResolutionTarget(possible.toFile().toURI(), (IRange)new Range(0, 0)));
                }
                ++n2;
            }
        }
        return links;
    }
}

