/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core.index;

import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.ruby.internal.core.index.CoreStubber;
import com.aptana.ruby.launching.RubyLaunchingPlugin;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class RubyIndexUtil {
    private RubyIndexUtil() {
    }

    public static synchronized Collection<Index> allIndices(IProject project) {
        ArrayList<Index> indices = new ArrayList<Index>();
        Index index = RubyIndexUtil.getIndex(project);
        if (index != null) {
            indices.add(index);
        }
        indices.add(CoreStubber.getRubyCoreIndex(project));
        indices.addAll(RubyIndexUtil.getStdLibIndices(project));
        indices.addAll(RubyIndexUtil.getGemIndices(project));
        return indices;
    }

    public static Index getIndex(IProject project) {
        if (project == null) {
            return null;
        }
        return RubyIndexUtil.getIndexManager().getIndex(project.getLocationURI());
    }

    public static Collection<Index> getStdLibIndices(IProject project) {
        return CoreStubber.getStdLibIndices(project);
    }

    protected static Collection<Index> getGemIndices(IProject project) {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (IPath path : RubyLaunchingPlugin.getGemPaths((IProject)project)) {
            indices.add(RubyIndexUtil.getIndexManager().getIndex(path.toFile().toURI()));
        }
        return indices;
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }
}

