/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core.codeassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.core.RubySourceParser;
import com.aptana.ruby.core.ast.ASTUtils;
import com.aptana.ruby.core.ast.ClosestSpanningNodeLocator;
import com.aptana.ruby.core.ast.INodeAcceptor;
import com.aptana.ruby.core.ast.NamespaceVisitor;
import com.aptana.ruby.core.ast.OffsetNodeLocator;
import com.aptana.ruby.core.ast.ScopedNodeLocator;
import com.aptana.ruby.core.inference.ITypeGuess;
import com.aptana.ruby.core.inference.ITypeInferrer;
import com.aptana.ruby.internal.core.inference.TypeInferrer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.parser.ParserResult;

public class CompletionContext {
    private int offset;
    private boolean isMethodInvokation = false;
    private String correctedSource;
    private String partialPrefix;
    private String fullPrefix;
    private int replaceStart;
    private boolean isAfterDoubleSemiColon = false;
    private Node fRootNode;
    private List<CommentNode> fCommentNodes;
    private boolean inComment;
    private String src;
    private Node enclosingScopeNode;
    private IProject project;

    public CompletionContext(IProject project, String src, int offset) {
        this.project = project;
        this.src = src;
        if (offset < 0) {
            offset = 0;
        }
        this.offset = offset;
        this.replaceStart = offset + 1;
        try {
            this.run(src);
        }
        catch (RuntimeException e) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void run(String src) {
        source = new StringBuilder(src);
        if (this.offset >= source.length()) {
            this.offset = source.length() - 1;
            this.replaceStart = this.offset + 1;
        }
        tmpPrefix = new StringBuffer();
        setOffset = false;
        i = this.offset;
        block5: while (i >= 0) {
            curChar = source.charAt(i);
            if (this.offset != i) ** GOTO lbl-1000
            switch (curChar) {
                case '@': {
                    if (i - 1 >= 0 && source.charAt(i - 1) == '@') {
                        source.deleteCharAt(i);
                        source.deleteCharAt(i - 1);
                        tmpPrefix.append('@');
                        --i;
                    } else {
                        source.deleteCharAt(i);
                    }
                    ** GOTO lbl51
                }
                case '$': 
                case ',': 
                case '.': {
                    source.deleteCharAt(i);
                    ** GOTO lbl51
                }
                case ':': {
                    if (i > 0 && (previous = source.charAt(i - 1)) == ':') {
                        this.isAfterDoubleSemiColon = true;
                        source.deleteCharAt(i);
                        source.deleteCharAt(i - 1);
                        tmpPrefix.insert(0, "::");
                        this.partialPrefix = "";
                        --i;
                        if (this.offset < source.length()) break;
                        this.offset = source.length() - 1;
                        break;
                    }
                    if (i + 1 < source.length()) {
                        next = source.charAt(i + 1);
                        if (!Character.isLetterOrDigit(next)) {
                            source.insert(i + 1, 's');
                        }
                    } else {
                        source.insert(i + 1, 's');
                    }
                }
lbl51:
                // 6 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (curChar == '.') {
                        this.isMethodInvokation = true;
                        if (this.partialPrefix == null) {
                            this.partialPrefix = tmpPrefix.toString();
                        }
                        if (!setOffset) {
                            this.offset = this.offset - 1 == i ? i : i - 1;
                            setOffset = true;
                        }
                    } else if (curChar == ':' && i > 0 && (previous = source.charAt(i - 1)) == ':') {
                        this.isAfterDoubleSemiColon = true;
                        if (this.partialPrefix == null) {
                            this.partialPrefix = tmpPrefix.toString();
                        }
                        tmpPrefix.insert(0, ":");
                        if (!setOffset) {
                            this.offset = i + 1;
                            setOffset = true;
                        }
                        --i;
                    }
                    if (Character.isWhitespace(curChar) || curChar == ',' || curChar == '(' || curChar == '[' || curChar == '{') {
                        if (setOffset) break block5;
                        this.offset = i + 1;
                        setOffset = true;
                        break block5;
                    }
                    tmpPrefix.insert(0, curChar);
                }
            }
            --i;
        }
        this.fullPrefix = tmpPrefix.toString();
        if (this.partialPrefix == null) {
            this.partialPrefix = this.fullPrefix;
        }
        if (this.partialPrefix != null) {
            this.replaceStart -= this.partialPrefix.length();
        }
        this.correctedSource = source.toString();
        spanningLocator = new ClosestSpanningNodeLocator();
        selected = spanningLocator.find(this.getRootNode(), this.offset, new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return true;
            }
        });
        if (selected == null && this.fCommentNodes != null) {
            for (CommentNode comment : this.fCommentNodes) {
                if (!spanningLocator.spansOffset((Node)comment, this.offset)) continue;
                this.inComment = true;
                break;
            }
        }
    }

    public boolean isExplicitMethodInvokation() {
        return this.isMethodInvokation;
    }

    public boolean isMethodInvokationOrLocal() {
        return !this.isExplicitMethodInvokation() && (this.emptyPrefix() || this.getPartialPrefix().length() > 0 && Character.isLowerCase(this.getPartialPrefix().charAt(0)));
    }

    public boolean isConstant() {
        String partial = this.getPartialPrefix();
        return partial != null && partial.length() > 0 && Character.isUpperCase(partial.charAt(0));
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public String getCorrectedSource() {
        return this.correctedSource;
    }

    public boolean isBroken() {
        return !this.getCorrectedSource().equals(this.getSource());
    }

    public boolean hasReceiver() {
        return this.getFullPrefix().indexOf(46) > 1;
    }

    public String getSource() {
        return this.src;
    }

    public String getFullPrefix() {
        return this.fullPrefix;
    }

    public String getPartialPrefix() {
        return this.partialPrefix;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean emptyPrefix() {
        return this.getFullPrefix() == null || this.getFullPrefix().length() == 0;
    }

    public boolean prefixStartsWith(String name) {
        return name != null && this.getPartialPrefix() != null && name.startsWith(this.getPartialPrefix());
    }

    public boolean isGlobal() {
        return !this.emptyPrefix() && !this.isExplicitMethodInvokation() && this.getPartialPrefix().length() > 0 && this.getPartialPrefix().charAt(0) == '$';
    }

    public boolean isDoubleColon() {
        return this.isAfterDoubleSemiColon && !this.isMethodInvokation;
    }

    public boolean fullPrefixIsConstant() {
        String full = this.getFullPrefix();
        if (full == null || full.length() == 0) {
            return false;
        }
        if (full.endsWith("\".") || full.endsWith("'.")) {
            return false;
        }
        return Character.isUpperCase(full.charAt(0));
    }

    public boolean inTypeDefinition() {
        if (this.getRootNode() == null) {
            return false;
        }
        Node spanner = new ClosestSpanningNodeLocator().find(this.getRootNode(), this.getOffset(), new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node instanceof MethodDefNode || node instanceof ClassNode || node instanceof ModuleNode;
            }
        });
        return spanner instanceof ClassNode || spanner instanceof ModuleNode;
    }

    public synchronized Node getRootNode() {
        ParserResult result;
        if (this.fRootNode != null) {
            return this.fRootNode;
        }
        RubySourceParser parser = new RubySourceParser(CompatVersion.BOTH);
        if (!this.isBroken()) {
            try {
                result = parser.parse(this.getSource());
                this.fRootNode = result.getAST();
                this.fCommentNodes = result.getCommentNodes();
            }
            catch (RuntimeException runtimeException) {}
        }
        if (this.fRootNode == null) {
            try {
                result = parser.parse(this.getCorrectedSource());
                this.fRootNode = result.getAST();
                this.fCommentNodes = result.getCommentNodes();
            }
            catch (RuntimeException runtimeException) {}
        }
        return this.fRootNode;
    }

    public boolean inComment() {
        return this.inComment;
    }

    public boolean isInstanceOrClassVariable() {
        return this.getPartialPrefix() != null && this.getPartialPrefix().length() == 1 && this.getPartialPrefix().charAt(0) == '@';
    }

    public boolean isInstanceVariable() {
        return this.getPartialPrefix() != null && this.getPartialPrefix().length() > 1 && this.getPartialPrefix().charAt(0) == '@' && !this.isClassVariable();
    }

    public boolean isClassVariable() {
        return this.getPartialPrefix() != null && this.getPartialPrefix().startsWith("@@");
    }

    public String getEnclosingType() {
        Node typeNode = new ClosestSpanningNodeLocator().find(this.getRootNode(), this.getOffset(), new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node instanceof ClassNode || node instanceof ModuleNode;
            }
        });
        if (typeNode == null) {
            return "Object";
        }
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0) {
            return String.valueOf(namespace) + "::" + ASTUtils.getName(typeNode);
        }
        return ASTUtils.getName(typeNode);
    }

    public String getNamespace() {
        return new NamespaceVisitor().getNamespace(this.getRootNode(), this.getOffset());
    }

    public synchronized Node getEnclosingTypeNode() {
        if (this.enclosingScopeNode == null) {
            Node typeNode = new ClosestSpanningNodeLocator().find(this.getRootNode(), this.getOffset(), new INodeAcceptor(){

                @Override
                public boolean accepts(Node node) {
                    return node instanceof ClassNode || node instanceof ModuleNode;
                }
            });
            this.enclosingScopeNode = typeNode == null ? this.getRootNode() : typeNode;
        }
        return this.enclosingScopeNode;
    }

    public Set<String> getLocalsInScope() {
        if (this.getRootNode() == null) {
            return Collections.emptySet();
        }
        TreeSet<String> locals = new TreeSet<String>();
        Node enclosingMethod = new ClosestSpanningNodeLocator().find(this.getRootNode(), this.getOffset(), new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node instanceof MethodDefNode;
            }
        });
        StaticScope scope = null;
        if (enclosingMethod == null) {
            scope = ((RootNode)this.getRootNode()).getStaticScope();
        } else {
            MethodDefNode methodDef = (MethodDefNode)enclosingMethod;
            scope = methodDef.getScope();
        }
        while (scope != null) {
            String[] stringArray = scope.getAllNamesInScope();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                locals.add(var);
                ++n2;
            }
            scope = scope.getEnclosingScope();
        }
        return locals;
    }

    public Node getReceiver() {
        return new OffsetNodeLocator().find(this.getRootNode(), this.offset);
    }

    public Collection<ITypeGuess> inferReceiver() {
        return this.getTypeInferrer().infer(this.getRootNode(), this.getReceiver());
    }

    protected ITypeInferrer getTypeInferrer() {
        return new TypeInferrer(this.project);
    }

    public boolean isNotParseable() {
        return this.getRootNode() == null;
    }

    public boolean isSymbol() {
        return this.getPartialPrefix().length() > 0 && this.getPartialPrefix().charAt(0) == ':';
    }

    public Set<String> getSymbolsInAST() {
        TreeSet<String> symbols = new TreeSet<String>();
        if (this.getRootNode() == null) {
            Pattern p = Pattern.compile(":(\\w+)\\b");
            Matcher m = p.matcher(this.src);
            while (m.find()) {
                symbols.add(m.group(1));
            }
            return symbols;
        }
        List<Node> symbolNodes = new ScopedNodeLocator().find(this.getRootNode(), new INodeAcceptor(){

            @Override
            public boolean accepts(Node node) {
                return node instanceof SymbolNode;
            }
        });
        for (Node node : symbolNodes) {
            if (node.getPosition().getStartOffset() <= this.getOffset() && node.getPosition().getEndOffset() >= this.getOffset()) continue;
            SymbolNode symbolNode = (SymbolNode)node;
            symbols.add(symbolNode.getName());
        }
        return symbols;
    }
}

