/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core.ast;

import com.aptana.core.util.ArrayUtil;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.FalseNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.ast.ZArrayNode;

public class ASTUtils {
    private static final String EMPTY_STRING = "";
    private static final String NAMESPACE_DELIMETER = "::";

    public static String[] getArgs(ArgsNode argsNode, StaticScope scope) {
        if (argsNode == null) {
            return ArrayUtil.NO_STRINGS;
        }
        List<String> arguments = ASTUtils.getArguments(argsNode.getPre());
        if (argsNode.getOptionalCount() > 0) {
            arguments.addAll(ASTUtils.getArguments(argsNode.getOptional()));
        }
        if (argsNode.getRest() != null) {
            arguments.add("*" + argsNode.getRest().getName());
        }
        if (argsNode.getBlock() != null) {
            arguments.add("&" + scope.getVariables()[argsNode.getBlock().getCount()]);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public static List<String> getArguments(ListNode argList) {
        if (argList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        List childNodes = argList.childNodes();
        for (Node node : childNodes) {
            if (node instanceof ArgumentNode) {
                arguments.add(((ArgumentNode)node).getName());
                continue;
            }
            if (!(node instanceof LocalAsgnNode)) continue;
            LocalAsgnNode local = (LocalAsgnNode)node;
            arguments.add(MessageFormat.format("{0} = {1}", local.getName(), ASTUtils.getStringRepresentation(local.getValueNode())));
        }
        return arguments;
    }

    public static List<String> getArgumentsFromFunctionCall(IArgumentNode iVisited) {
        ArrayList<String> arguments = new ArrayList<String>();
        List<Node> nodes = ASTUtils.getArgumentNodesFromFunctionCall(iVisited);
        for (Node node : nodes) {
            if (node instanceof DAsgnNode) {
                arguments.add(((DAsgnNode)node).getName());
                continue;
            }
            arguments.add(ASTUtils.getStringRepresentation(node));
        }
        return arguments;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Node> getArgumentNodesFromFunctionCall(IArgumentNode iVisited) {
        arguments = new ArrayList<Node>();
        argsNode = iVisited.getArgsNode();
        iter = null;
        if (argsNode != null) {
            iter = argsNode.childNodes().iterator();
        } else {
            iterNode = null;
            if (iVisited instanceof FCallNode) {
                iterNode = ((FCallNode)iVisited).getIterNode();
            } else if (iVisited instanceof CallNode) {
                iterNode = ((CallNode)iVisited).getIterNode();
            }
            if (iterNode == null) {
                return arguments;
            }
            if (iterNode instanceof IterNode) {
                yeah = (IterNode)iterNode;
                varNode = yeah.getVarNode();
                if (varNode instanceof DAsgnNode) {
                    arguments.add(varNode);
                } else if (varNode instanceof MultipleAsgnNode) {
                    multi = (MultipleAsgnNode)varNode;
                    list = multi.getHeadNode();
                    if (list != null) {
                        iter = list.childNodes().iterator();
                    } else {
                        multiArgsNode = multi.getArgsNode();
                        if (multiArgsNode instanceof DAsgnNode) {
                            arguments.add(multiArgsNode);
                        }
                    }
                }
            }
        }
        if (iter != null) ** GOTO lbl36
        return arguments;
lbl-1000:
        // 1 sources

        {
            arguments.add((Node)iter.next());
lbl36:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl37:
        // 1 sources

        return arguments;
    }

    public static String getFullyQualifiedName(Node node) {
        if (node == null) {
            return EMPTY_STRING;
        }
        if (node instanceof ConstNode) {
            return ((ConstNode)node).getName();
        }
        if (node instanceof Colon2Node) {
            Colon2Node colonNode = (Colon2Node)node;
            String prefix = ASTUtils.getFullyQualifiedName(colonNode.getLeftNode());
            if (prefix.length() > 0) {
                prefix = String.valueOf(prefix) + NAMESPACE_DELIMETER;
            }
            return String.valueOf(prefix) + colonNode.getName();
        }
        return ASTUtils.getName(node);
    }

    public static String getFullyQualifiedName(Colon2Node node) {
        StringBuilder name = new StringBuilder();
        Node left = node.getLeftNode();
        if (left instanceof Colon2Node) {
            name.append(ASTUtils.getFullyQualifiedName((Colon2Node)left));
        } else if (left instanceof ConstNode) {
            name.append(((ConstNode)left).getName());
        }
        name.append(NAMESPACE_DELIMETER).append(node.getName());
        return name.toString();
    }

    public static String getName(Node node) {
        if (node == null) {
            return EMPTY_STRING;
        }
        if (node instanceof ClassNode) {
            return ASTUtils.getName((Node)((ClassNode)node).getCPath());
        }
        if (node instanceof ModuleNode) {
            return ASTUtils.getName((Node)((ModuleNode)node).getCPath());
        }
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        if (node instanceof LiteralNode) {
            return ((LiteralNode)node).getName();
        }
        try {
            Method getNameMethod = node.getClass().getMethod("getName", new Class[0]);
            Object name = getNameMethod.invoke((Object)node, ArrayUtil.NO_OBJECTS);
            return (String)name;
        }
        catch (Exception exception) {
            return EMPTY_STRING;
        }
    }

    public static String getStringRepresentation(Node node) {
        if (node == null) {
            return EMPTY_STRING;
        }
        if (node instanceof HashNode) {
            return "{}";
        }
        if (node instanceof SelfNode) {
            return "self";
        }
        if (node instanceof NilNode) {
            return "nil";
        }
        if (node instanceof TrueNode) {
            return "true";
        }
        if (node instanceof FalseNode) {
            return "false";
        }
        if (node instanceof SymbolNode) {
            return String.valueOf(':') + ((SymbolNode)node).getName();
        }
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        if (node instanceof ZArrayNode) {
            return "[]";
        }
        if (node instanceof FixnumNode) {
            return String.valueOf(((FixnumNode)node).getValue());
        }
        if (node instanceof StrNode) {
            return String.valueOf('\"') + ((StrNode)node).getValue() + '\"';
        }
        if (node instanceof DStrNode) {
            List children = node.childNodes();
            StringBuilder text = new StringBuilder();
            text.append('\"');
            for (Node child : children) {
                text.append(ASTUtils.getStringRepresentation(child));
            }
            text.append('\"');
            return text.toString();
        }
        return node.toString();
    }
}

