/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ruby.core.IImportContainer;
import com.aptana.ruby.core.IRubyElement;
import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.core.ISourceElementRequestor;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.internal.core.RubyBlock;
import com.aptana.ruby.internal.core.RubyClassVariable;
import com.aptana.ruby.internal.core.RubyConstant;
import com.aptana.ruby.internal.core.RubyDynamicVariable;
import com.aptana.ruby.internal.core.RubyElement;
import com.aptana.ruby.internal.core.RubyField;
import com.aptana.ruby.internal.core.RubyGlobal;
import com.aptana.ruby.internal.core.RubyImport;
import com.aptana.ruby.internal.core.RubyImportContainer;
import com.aptana.ruby.internal.core.RubyInstanceVariable;
import com.aptana.ruby.internal.core.RubyLocalVariable;
import com.aptana.ruby.internal.core.RubyMethod;
import com.aptana.ruby.internal.core.RubyModule;
import com.aptana.ruby.internal.core.RubyScript;
import com.aptana.ruby.internal.core.RubyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;

public class RubyStructureBuilder
implements ISourceElementRequestor {
    private RubyScript script;
    private Stack<RubyElement> modelStack;

    public RubyStructureBuilder(RubyScript script) {
        this.script = script;
        this.modelStack = new Stack();
        this.modelStack.push(script);
    }

    @Override
    public void enterBlock(int startOffset, int endOffset) {
        RubyElement parent = this.modelStack.peek();
        RubyBlock block = new RubyBlock(startOffset, endOffset);
        parent.addChild(block);
        this.modelStack.push(block);
    }

    @Override
    public void acceptConstructorReference(String name, int argCount, int offset) {
    }

    @Override
    public void acceptFieldReference(String name, int offset) {
    }

    @Override
    public void acceptImport(String value, int startOffset, int endOffset) {
        IImportContainer importContainer = this.script.getImportContainer();
        if (importContainer instanceof RubyImportContainer) {
            ((RubyImportContainer)importContainer).addChild(new RubyImport(value, startOffset, endOffset));
        }
    }

    @Override
    public void acceptMethodReference(String name, int argCount, int offset) {
    }

    @Override
    public void acceptMethodVisibilityChange(String methodName, IRubyMethod.Visibility visibility) {
        IRubyMethod[] methods;
        RubyElement element = this.getCurrentType();
        if (!(element instanceof RubyType)) {
            return;
        }
        RubyType parentType = (RubyType)element;
        IRubyMethod[] iRubyMethodArray = methods = parentType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IRubyMethod method = iRubyMethodArray[n2];
            if (method.getName().equals(methodName) && method instanceof RubyMethod) {
                ((RubyMethod)method).setVisibility(visibility);
            }
            ++n2;
        }
    }

    @Override
    public void acceptMixin(String string) {
        RubyElement element = this.getCurrentType();
        if (!(element instanceof RubyType)) {
            return;
        }
        RubyType parentType = (RubyType)element;
        LinkedList<String> moduleNames = new LinkedList<String>();
        moduleNames.addAll(Arrays.asList(parentType.getIncludedModuleNames()));
        moduleNames.add(string);
        parentType.setIncludedModuleNames(moduleNames.toArray(new String[moduleNames.size()]));
    }

    @Override
    public void acceptModuleFunction(String function) {
        IRubyMethod[] methods;
        RubyElement element = this.getCurrentType();
        if (!(element instanceof RubyType)) {
            return;
        }
        RubyType parentType = (RubyType)element;
        IRubyMethod[] iRubyMethodArray = methods = parentType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IRubyMethod method = iRubyMethodArray[n2];
            if (method.getName().equals(function) && method instanceof RubyMethod) {
                ((RubyMethod)method).setIsSingleton(true);
            }
            ++n2;
        }
    }

    @Override
    public void acceptTypeReference(String name, int startOffset, int endOffset) {
    }

    @Override
    public void acceptYield(String name) {
        RubyElement element;
        if (!this.modelStack.isEmpty() && (element = this.modelStack.peek()) instanceof RubyMethod) {
            ((RubyMethod)element).addBlockVar(name);
        }
    }

    @Override
    public void enterConstructor(ISourceElementRequestor.MethodInfo constructor) {
        this.enterMethod(constructor);
    }

    @Override
    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        RubyField handle;
        if (fieldInfo == null || fieldInfo.name == null || fieldInfo.name.length() == 0) {
            return;
        }
        RubyElement parent = this.getCurrentType();
        if (fieldInfo.name.startsWith("@@")) {
            handle = new RubyClassVariable(fieldInfo.name, fieldInfo.declarationStart, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd);
        } else if (fieldInfo.name.length() > 0 && fieldInfo.name.charAt(0) == '@') {
            handle = new RubyInstanceVariable(fieldInfo.name, fieldInfo.declarationStart, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd);
        } else if (fieldInfo.name.length() > 0 && fieldInfo.name.charAt(0) == '$') {
            parent = this.script;
            handle = new RubyGlobal(fieldInfo.name, fieldInfo.declarationStart, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd);
        } else if (Character.isUpperCase(fieldInfo.name.charAt(0))) {
            handle = new RubyConstant(fieldInfo.name, fieldInfo.declarationStart, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd);
        } else {
            parent = this.modelStack.peek();
            handle = fieldInfo.isDynamic ? new RubyDynamicVariable(fieldInfo.name, fieldInfo.declarationStart, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd) : new RubyLocalVariable(fieldInfo.name, fieldInfo.declarationStart, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd);
        }
        if (!RubyStructureBuilder.hasChild(parent, handle)) {
            parent.addChild(handle);
        }
        this.modelStack.push(handle);
    }

    @Override
    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        RubyMethod method = new RubyMethod(methodInfo.name, methodInfo.parameterNames, methodInfo.declarationStart, methodInfo.nameSourceStart, methodInfo.nameSourceEnd);
        method.setVisibility(methodInfo.visibility);
        method.setIsSingleton(methodInfo.isClassLevel);
        this.getCurrentType().addChild(method);
        this.modelStack.push(method);
    }

    @Override
    public void enterScript() {
    }

    @Override
    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        RubyType handle = typeInfo.isModule ? new RubyModule(typeInfo.name, typeInfo.declarationStart, typeInfo.nameSourceStart, typeInfo.nameSourceEnd) : new RubyType(typeInfo.name, typeInfo.declarationStart, typeInfo.nameSourceStart, typeInfo.nameSourceEnd);
        handle.setSuperclassName(typeInfo.superclass);
        handle.setIncludedModuleNames(typeInfo.modules);
        RubyElement parent = this.modelStack.peek();
        RubyType existing = (RubyType)RubyStructureBuilder.findChild(parent, 2, typeInfo.name);
        if (existing != null) {
            handle.incrementOccurrence();
        }
        parent.addChild(handle);
        this.modelStack.push(handle);
    }

    @Override
    public void exitConstructor(int endOffset) {
        this.exitMethod(endOffset);
    }

    @Override
    public void exitField(int endOffset) {
        if (this.modelStack.isEmpty()) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)"AST stack was empty upon exiting field declaration, but should have contained the field.");
            return;
        }
        RubyElement element = this.modelStack.pop();
        if (!(element instanceof RubyField)) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)("Expected field decl on top of stack, but was: " + element));
        }
        element.setLocation(element.getStartingOffset(), endOffset + 1);
    }

    @Override
    public void exitMethod(int endOffset) {
        if (this.modelStack.isEmpty()) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)"AST stack was empty upon exiting method declaration, but should have contained the method.");
            return;
        }
        RubyElement element = this.modelStack.pop();
        if (!(element instanceof RubyMethod)) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)("Expected method decl on top of stack, but was: " + element));
        }
        element.setLocation(element.getStartingOffset(), endOffset + 1);
    }

    @Override
    public void exitScript(int endOffset) {
        if (this.modelStack.isEmpty()) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)"AST stack was empty upon exiting script, but should have contained the script.");
            return;
        }
        RubyElement element = this.modelStack.pop();
        if (!(element instanceof RubyScript)) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)("Expected script on top of stack, but was: " + element.getClass().getName()));
        }
        element.setLocation(element.getStartingOffset(), endOffset + 1);
    }

    @Override
    public void exitType(int endOffset) {
        if (this.modelStack.isEmpty()) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)"AST stack was empty upon exiting type declaration, but should have contained the type.");
            return;
        }
        RubyElement element = this.modelStack.pop();
        if (!(element instanceof RubyType)) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)("Expected type decl on top of stack, but was: " + element));
        }
        element.setLocation(element.getStartingOffset(), endOffset + 1);
    }

    @Override
    public void exitBlock(int endOffset) {
        if (this.modelStack.isEmpty()) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)"AST stack was empty upon exiting block, but should have contained the block.");
            return;
        }
        RubyElement element = this.modelStack.pop();
        if (!(element instanceof RubyBlock)) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)("Expected block on top of stack, but was: " + element));
        }
        element.setLocation(element.getStartingOffset(), endOffset);
    }

    private static IRubyElement findChild(RubyElement parent, int type, String name) {
        IRubyElement[] elements;
        IRubyElement[] iRubyElementArray = elements = parent.getChildrenOfType(type);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IRubyElement element = iRubyElementArray[n2];
            if (element.getName().equals(name)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private RubyElement getCurrentType() {
        ArrayList<RubyElement> extras = new ArrayList<RubyElement>();
        RubyElement element = null;
        if (!this.modelStack.isEmpty()) {
            element = this.modelStack.peek();
            while (!(element instanceof RubyType)) {
                extras.add(this.modelStack.pop());
                if (this.modelStack.isEmpty()) break;
                element = this.modelStack.peek();
            }
        }
        Collections.reverse(extras);
        for (RubyElement extra : extras) {
            this.modelStack.push(extra);
        }
        if (element == null) {
            return this.script;
        }
        return element;
    }

    private static boolean hasChild(RubyElement parent, IRubyElement child) {
        IParseNode[] nodes;
        IParseNode[] iParseNodeArray = nodes = parent.getChildren();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode node = iParseNodeArray[n2];
            IRubyElement element = (IRubyElement)node;
            if (element.getName().equals(child.getName()) && element.getNodeType() == child.getNodeType()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

