/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.core.NullParserResult;
import com.aptana.ruby.core.RubyCorePlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.Plugin;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.Parser;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.ParserResult;
import org.jrubyparser.parser.ParserSupport;
import org.jrubyparser.parser.ParserSupport19;
import org.jrubyparser.parser.Ruby18Parser;
import org.jrubyparser.parser.Ruby19Parser;
import org.jrubyparser.parser.RubyParser;

public class RubySourceParser {
    private IRubyWarnings warnings;
    private RubyParser parser;
    private ParserConfiguration config;
    private CompatVersion compatVersion;

    public RubySourceParser(CompatVersion compatVersion, IRubyWarnings warnings) {
        this.compatVersion = compatVersion;
        this.warnings = warnings;
    }

    public RubySourceParser(CompatVersion compatVersion) {
        this(compatVersion, (IRubyWarnings)new Parser.NullWarnings());
    }

    public ParserResult parse(String source) {
        return this.parse(null, source);
    }

    public ParserResult parse(String fileName, String source) {
        return this.parse(fileName, source, false);
    }

    private ParserResult parse(String fileName, String source, boolean bypassCache) {
        ParserResult ast;
        block14: {
            if (source == null) {
                return new NullParserResult();
            }
            ast = null;
            BufferedReader reader = new BufferedReader(new StringReader(source));
            try {
                try {
                    ast = this.parse(fileName, reader);
                }
                catch (Exception e) {
                    if (IdeLog.isInfoEnabled((Plugin)RubyCorePlugin.getDefault(), null)) {
                        IdeLog.logInfo((Plugin)RubyCorePlugin.getDefault(), (String)"Unable to parse ruby file", (Throwable)e, null);
                    }
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        if (ast == null) {
            return new NullParserResult();
        }
        return ast;
    }

    private ParserResult parse(String fileName, Reader content) throws IOException {
        if (fileName == null) {
            fileName = "";
        }
        if (this.parser == null) {
            ParserSupport support;
            this.config = this.getParserConfig();
            if (this.compatVersion == CompatVersion.RUBY1_8) {
                support = new ParserSupport();
                support.setConfiguration(this.config);
                this.parser = new Ruby18Parser(support);
            } else {
                support = new ParserSupport19();
                support.setConfiguration(this.config);
                this.parser = new Ruby19Parser((ParserSupport19)support);
            }
        }
        this.parser.setWarnings(this.warnings);
        LexerSource lexerSource = LexerSource.getSource((String)fileName, (Reader)content, (ParserConfiguration)this.config);
        ParserResult result = this.parser.parse(this.config, lexerSource);
        this.postProcessResult(result);
        return result;
    }

    protected void postProcessResult(ParserResult result) {
    }

    protected ParserConfiguration getParserConfig() {
        return new ParserConfiguration(0, this.compatVersion);
    }
}

