/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core;

import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.ParseError;
import java.util.ArrayList;
import java.util.Collection;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;

class CollectingRubyWarnings
implements IRubyWarnings {
    private String filename;
    private Collection<IParseError> warnings;

    public CollectingRubyWarnings(String fileName) {
        this.filename = fileName;
        this.warnings = new ArrayList<IParseError>();
    }

    public void warn(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
        int length = position.getEndOffset() - position.getStartOffset();
        this.warnings.add(this.createWarning(message, position.getStartLine(), position.getStartOffset(), length, this.filename));
    }

    public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        this.warnings.add(this.createWarning(message, lineNumber, 0, 1, this.filename));
    }

    public boolean isVerbose() {
        return true;
    }

    public void warn(IRubyWarnings.ID id, String message, Object ... data) {
        this.warnings.add(this.createWarning(message, 1, 0, 1, this.filename));
    }

    public void warning(IRubyWarnings.ID id, String message, Object ... data) {
        this.warn(id, message, data);
    }

    public void warning(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
        this.warn(id, position, message, data);
    }

    public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        this.warn(id, fileName, lineNumber, message, data);
    }

    private IParseError createWarning(String message, int lineNumber, int offset, int length, String path) {
        return new ParseError("com.aptana.contenttype.ruby", offset, length, message, IParseError.Severity.WARNING);
    }

    public Collection<IParseError> getWarnings() {
        return this.warnings;
    }
}

