/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.OutputType;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SnippetElement
extends CommandElement {
    private String _expansion;
    private String _category;
    private List<String> _tags;
    private String _iconPath;
    private URL _iconURL;
    private String _description;
    private String _locationType;
    protected boolean _needApplyReContentAssist;
    private String _version;

    public SnippetElement(String path) {
        super(path);
        this.setInputType(InputType.NONE);
        this.setOutputType(OutputType.INSERT_AS_SNIPPET);
    }

    @Override
    public CommandResult execute() {
        return this.execute(null);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        context.setOutputType(this.getOutputType());
        CommandResult result = new CommandResult(this, context);
        result.setOutputString(this.getExpansion());
        result.setExecutedSuccessfully(true);
        String inputTypeString = (String)context.get("input_type");
        InputType inputType = InputType.get(inputTypeString);
        result.setInputType(inputType);
        return result;
    }

    @Override
    protected String getElementName() {
        return "snippet";
    }

    public String getExpansion() {
        return this._expansion;
    }

    public void setExpansion(String expansion) {
        this._expansion = expansion;
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public List<String> getTags() {
        return CollectionsUtil.getListValue(this._tags);
    }

    public void setTags(List<String> tags) {
        this._tags = tags != null ? new ArrayList<String>(tags) : null;
    }

    public void setIconPath(String iconPath) {
        this._iconPath = iconPath;
    }

    public String getIconPath() {
        return this._iconPath;
    }

    public URL getIconURL() {
        if (this._iconURL != null) {
            return this._iconURL;
        }
        this._iconURL = this.getURLFromPath(this._iconPath);
        return this._iconURL;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    public String getLocationType() {
        return this._locationType;
    }

    public void setLocationType(String locationType) {
        this._locationType = locationType;
    }

    public boolean isNeedApplyReContentAssist() {
        return this._needApplyReContentAssist;
    }

    public void setNeedApplyReContentAssist(boolean needApplyReContentAssist) {
        this._needApplyReContentAssist = needApplyReContentAssist;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }
}

