/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.LibraryCrossReference;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractElement
implements Comparable<AbstractElement> {
    private static final Map<String, List<AbstractElement>> ELEMENTS_BY_PATH = new HashMap<String, List<AbstractElement>>();
    private String _path;
    private String _displayName;
    private Map<String, Object> _customProperties;
    private Object propertyLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AbstractElement> getElementsByDirectory(String path) {
        Set<String> keys;
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        Map<String, List<AbstractElement>> map = ELEMENTS_BY_PATH;
        synchronized (map) {
            keys = ELEMENTS_BY_PATH.keySet();
        }
        for (String key : keys) {
            List<AbstractElement> elements;
            if (!key.startsWith(path) || (elements = ELEMENTS_BY_PATH.get(key)) == null) continue;
            result.addAll(elements);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AbstractElement> getElementsByPath(String path) {
        List<AbstractElement> result;
        Map<String, List<AbstractElement>> map = ELEMENTS_BY_PATH;
        synchronized (map) {
            List<AbstractElement> elements = ELEMENTS_BY_PATH.get(path);
            result = elements != null ? new ArrayList<AbstractElement>(elements) : Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerElement(AbstractElement element) {
        String path;
        if (element != null && (path = element.getPath()) != null && path.length() > 0) {
            Map<String, List<AbstractElement>> map = ELEMENTS_BY_PATH;
            synchronized (map) {
                AbstractElement.showRegistration("Register", element);
                List<AbstractElement> elements = ELEMENTS_BY_PATH.get(path);
                if (elements == null) {
                    elements = new ArrayList<AbstractElement>();
                    ELEMENTS_BY_PATH.put(path, elements);
                }
                elements.add(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterElement(AbstractElement element) {
        String path;
        if (element != null && (path = element.getPath()) != null && path.length() > 0) {
            Map<String, List<AbstractElement>> map = ELEMENTS_BY_PATH;
            synchronized (map) {
                AbstractElement.showRegistration("Unregister", element);
                List<AbstractElement> elements = ELEMENTS_BY_PATH.get(path);
                if (elements != null) {
                    elements.remove(element);
                    if (elements.size() == 0) {
                        ELEMENTS_BY_PATH.remove(path);
                    }
                }
            }
            LibraryCrossReference.getInstance().unregisterPath(path);
        }
    }

    private static void showRegistration(String message, AbstractElement element) {
        if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_element_registration")) {
            String name = element.getDisplayName();
            String path = element.getPath();
            String fullClassName = element.getClass().getName();
            String[] classParts = fullClassName.split("\\.");
            String className = classParts[classParts.length - 1];
            IdeLog.logTrace((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format("{0}: {1}, {2}, {3}", message, className, name, path), (String)"com.aptana.scripting/debug/show_element_registration");
        }
    }

    public AbstractElement(String path) {
        this._path = BundleManager.getInstance().sharedString(path);
        AbstractElement.registerElement(this);
    }

    @Override
    public int compareTo(AbstractElement o) {
        return this._displayName.compareToIgnoreCase(o._displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String property) {
        Object result = null;
        Object object = this.propertyLock;
        synchronized (object) {
            if (this._customProperties != null) {
                result = this._customProperties.get(property);
            }
        }
        return result;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    protected abstract String getElementName();

    public String getPath() {
        return this._path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(String property) {
        boolean result;
        Object object = this.propertyLock;
        synchronized (object) {
            result = this._customProperties != null && this._customProperties.containsKey(property);
        }
        return result;
    }

    protected abstract void printBody(SourcePrinter var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String property, Object value) {
        if (!StringUtil.isEmpty((String)property)) {
            property = BundleManager.getInstance().sharedString(property);
            Object object = this.propertyLock;
            synchronized (object) {
                if (this._customProperties == null) {
                    this._customProperties = new HashMap<String, Object>(1);
                }
                this._customProperties.put(property, value);
            }
        }
    }

    public Map<String, Object> getCustomProperties() {
        if (this._customProperties == null) {
            return null;
        }
        return new HashMap<String, Object>(this._customProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomProperties(Map<String, Object> props) {
        Object object = this.propertyLock;
        synchronized (object) {
            this._customProperties = null;
            if (props != null) {
                this._customProperties = new HashMap<String, Object>(props.size());
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    String property = BundleManager.getInstance().sharedString(entry.getKey());
                    this._customProperties.put(property, entry.getValue());
                }
            }
        }
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setPath(String path) {
        if (ObjectUtil.areNotEqual((Object)this._path, (Object)path)) {
            AbstractElement.unregisterElement(this);
            this._path = BundleManager.getInstance().sharedString(path);
            AbstractElement.registerElement(this);
        }
    }

    public String toSource() {
        return this.toSource(true);
    }

    public String toSource(boolean includeBlocks) {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer, includeBlocks);
        return printer.toString();
    }

    protected void toSource(SourcePrinter printer, boolean includeBlocks) {
        printer.printWithIndent(this.getElementName());
        printer.print(" \"").print(this.getDisplayName()).println("\" {").increaseIndent();
        this.printBody(printer, includeBlocks);
        if (this._customProperties != null) {
            for (Map.Entry<String, Object> entry : this._customProperties.entrySet()) {
                Object value = entry.getValue();
                String valueAsString = value.toString();
                if (value.getClass().isArray()) {
                    List<Object> list = Arrays.asList((Object[])value);
                    valueAsString = list.toString();
                }
                printer.printWithIndent(entry.getKey()).print(": ").println(valueAsString);
            }
        }
        printer.decreaseIndent().printlnWithIndent("}");
    }

    public String toString() {
        return this.toSource();
    }
}

