/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ObjectUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.MatchAnyScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractBundleElement
extends AbstractElement {
    private static final String ALL_SCOPES = "all";
    private String _scope;
    private IScopeSelector _scopeSelector;
    protected BundleElement owningBundle;

    public AbstractBundleElement(String path) {
        super(path);
    }

    public BundleElement getOwningBundle() {
        return this.owningBundle;
    }

    public String getScope() {
        return this._scope;
    }

    public IScopeSelector getScopeSelector() {
        if (this._scopeSelector == null) {
            this._scopeSelector = this._scope == null || this._scope.length() == 0 ? new MatchAnyScopeSelector() : new ScopeSelector(this._scope);
        }
        return this._scopeSelector;
    }

    public boolean matches(String scope) {
        IScopeSelector selector = this.getScopeSelector();
        boolean result = true;
        if (selector != null) {
            result = selector.matches(scope);
        }
        return result;
    }

    public boolean matches(String[] scopes) {
        IScopeSelector selector = this.getScopeSelector();
        boolean result = true;
        if (selector != null) {
            result = selector.matches(scopes);
        }
        return result;
    }

    void setOwningBundle(BundleElement bundle) {
        this.owningBundle = bundle;
    }

    public void setScope(String scope) {
        if (scope != null && scope.equals(ALL_SCOPES)) {
            scope = null;
        }
        if (ObjectUtil.areNotEqual((Object)this._scope, (Object)scope)) {
            this._scope = BundleManager.getInstance().sharedString(scope);
            this._scopeSelector = null;
        }
    }

    protected URL getURLFromPath(String path) {
        if (path == null) {
            return null;
        }
        URL iconURL = null;
        try {
            iconURL = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            IPath iconPath = new Path(this.getDirectory().getAbsolutePath()).append(path);
            try {
                iconURL = iconPath.toFile().toURI().toURL();
            }
            catch (Exception exception) {
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format("Unable to convert {0} into an URL for bundle element {1}", path, this.getDisplayName()));
            }
        }
        return iconURL;
    }

    private File getDirectory() {
        return this.getOwningBundle().getBundleDirectory();
    }
}

