/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.scripting.BundleConverter;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.OutputType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CommandConverter {
    public static void main(String[] args) throws Exception {
        String userHome = System.getProperty("user.home");
        if (args == null || args.length == 0) {
            args = new String[]{String.valueOf(userHome) + "/Documents/Aptana Rubles/sass/commands"};
        }
        String outputFilePath = args.length < 2 ? String.valueOf(userHome) + "/Documents/Aptana Rubles/sass/commands" : args[1];
        CommandConverter.convert(new File(args[0]), outputFilePath);
    }

    private static File[] gatherCommands(File commandDirectory) {
        return commandDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("plist") || name.endsWith("tmCommand");
            }
        });
    }

    private static String convert(File commandFile) {
        String trigger;
        String scope;
        Map<String, Object> properties = BundleConverter.parse(commandFile);
        if (properties == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("require 'ruble'\n\n");
        buffer.append("command '").append(BundleConverter.sanitize(properties, "name")).append("' do |cmd|\n");
        String keyBinding = BundleConverter.sanitize(properties, "keyEquivalent");
        if (keyBinding != null) {
            keyBinding = BundleConverter.convertKeyBinding(keyBinding);
            buffer.append("  cmd.key_binding = '").append(keyBinding).append("'\n");
        }
        if ((scope = BundleConverter.sanitize(properties, "scope")) != null) {
            buffer.append("  cmd.scope = '").append(scope).append("'\n");
        }
        if ((trigger = BundleConverter.sanitize(properties, "tabTrigger")) != null) {
            buffer.append("  cmd.trigger = '").append(trigger).append("'\n");
        }
        String outputType = CommandConverter.convertOutputTypes(CommandConverter.camelcaseToUnderscores(BundleConverter.sanitize(properties, "output")));
        buffer.append("  cmd.output = :").append(outputType).append("\n");
        String inputType = CommandConverter.convertInputTypes(BundleConverter.sanitize(properties, "input"));
        buffer.append("  cmd.input = :").append(inputType);
        String fallbackInput = CommandConverter.convertInputTypes(BundleConverter.sanitize(properties, "fallbackInput"));
        if (fallbackInput != null) {
            buffer.append(", :").append(fallbackInput);
        }
        buffer.append("\n");
        buffer.append("  cmd.invoke =<<-EOF\n").append(properties.get("command")).append("\nEOF\n");
        buffer.append("end\n");
        return buffer.toString();
    }

    protected static String convertFilename(File commandFile) {
        String name = commandFile.getName().toLowerCase();
        int lastDot = (name = name.replace(' ', '_')).lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(0, lastDot);
        }
        return String.valueOf(name) + ".rb";
    }

    private static String convertOutputTypes(String outputType) {
        if (outputType.equals("replace_selected_text")) {
            return OutputType.REPLACE_SELECTION.getName().toLowerCase();
        }
        if (outputType.equals("after_selected_text")) {
            return OutputType.INSERT_AS_TEXT.getName().toLowerCase();
        }
        if (outputType.equals("open_as_new_document")) {
            return OutputType.CREATE_NEW_DOCUMENT.getName().toLowerCase();
        }
        return outputType;
    }

    private static String convertInputTypes(String inputType) {
        if (inputType == null) {
            return null;
        }
        if (inputType.equals("character")) {
            return InputType.RIGHT_CHAR.getName().toLowerCase();
        }
        return inputType;
    }

    private static String camelcaseToUnderscores(String outputType) {
        boolean lastWasCaps = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < outputType.length()) {
            char c = outputType.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!lastWasCaps) {
                    builder.append("_");
                }
                builder.append(Character.toLowerCase(c));
                lastWasCaps = true;
            } else {
                builder.append(c);
                lastWasCaps = false;
            }
            ++i;
        }
        return builder.toString();
    }

    public static void convert(File textmateCommandsDir, String outputCommandsDir) {
        File[] commandFiles = CommandConverter.gatherCommands(textmateCommandsDir);
        if (commandFiles == null) {
            return;
        }
        File[] fileArray = commandFiles;
        int n = commandFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File commandFile = fileArray[n2];
            CommandConverter.convertSingleFile(commandFile, String.valueOf(outputCommandsDir) + File.separator + CommandConverter.convertFilename(commandFile));
            ++n2;
        }
    }

    private static void convertSingleFile(File commandFile, String outFilePath) {
        String output = CommandConverter.convert(commandFile);
        if (output == null) {
            return;
        }
        try {
            BundleConverter.writeToFile(output, outFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> uuidNameMap(File commandsDir) {
        HashMap<String, String> uuidNameMap = new HashMap<String, String>();
        File[] commandFiles = CommandConverter.gatherCommands(commandsDir);
        if (commandFiles == null) {
            return uuidNameMap;
        }
        File[] fileArray = commandFiles;
        int n = commandFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File commandFile = fileArray[n2];
            Map<String, Object> properties = BundleConverter.parse(commandFile);
            if (properties != null) {
                String name = BundleConverter.sanitize(properties, "name");
                String uuid = (String)properties.get("uuid");
                uuidNameMap.put(uuid, name);
            }
            ++n2;
        }
        return uuidNameMap;
    }
}

