/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scope;

import beaver.Symbol;
import com.aptana.core.epl.util.LRUCache;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ISelectorNode;
import com.aptana.scope.MatchContext;
import com.aptana.scope.SelectorNode;
import com.aptana.scope.parsing.ScopeParser;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.AbstractBundleElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class ScopeSelector
extends Symbol
implements IScopeSelector {
    private final ISelectorNode _root;
    private List<Integer> matchResults;
    private String fString;
    private static final LRUCache<String, ISelectorNode> cacheParse = new LRUCache(200);
    private static final Object lock = new Object();
    private static final SelectorNode NULL_SELECTOR = new SelectorNode();

    public static IScopeSelector bestMatch(Collection<IScopeSelector> selectors, String scope) {
        IScopeSelector bestMatch = null;
        if (!CollectionsUtil.isEmpty(selectors)) {
            ArrayList<IScopeSelector> reversed = new ArrayList<IScopeSelector>(selectors);
            Collections.reverse(reversed);
            for (IScopeSelector selector : reversed) {
                if (selector == null || !selector.matches(scope)) continue;
                if (bestMatch == null) {
                    bestMatch = selector;
                    continue;
                }
                if (selector.compareTo(bestMatch) <= 0) continue;
                bestMatch = selector;
            }
        }
        return bestMatch;
    }

    private static int compare(List<Integer> results, List<Integer> matchResults) {
        while (results.size() > matchResults.size()) {
            if (matchResults.isEmpty()) {
                matchResults = new ArrayList<Integer>();
            }
            matchResults.add(0);
        }
        while (matchResults.size() > results.size()) {
            if (results.isEmpty()) {
                results = new ArrayList<Integer>();
            }
            results.add(0);
        }
        int i = results.size() - 1;
        while (i >= 0) {
            int secondVal;
            int firstVal = results.get(i);
            if (firstVal != (secondVal = matchResults.get(i).intValue())) {
                return firstVal - secondVal;
            }
            --i;
        }
        return 0;
    }

    public static void sort(List<? extends AbstractBundleElement> bundleElements) {
        if (!CollectionsUtil.isEmpty(bundleElements)) {
            Collections.sort(bundleElements, new Comparator<AbstractBundleElement>(){

                @Override
                public int compare(AbstractBundleElement o1, AbstractBundleElement o2) {
                    return o1.getScopeSelector().compareTo(o2.getScopeSelector());
                }
            });
        }
    }

    ScopeSelector(ISelectorNode root) {
        this._root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScopeSelector(String selector) {
        Object object = lock;
        synchronized (object) {
            ISelectorNode node = (ISelectorNode)cacheParse.get((Object)selector);
            if (node == null) {
                node = ScopeSelector.parse(selector);
                if (node == null) {
                    node = NULL_SELECTOR;
                }
                cacheParse.put((Object)selector, (Object)node);
            }
            if (node == NULL_SELECTOR) {
                node = null;
            }
            this._root = node;
        }
    }

    @Override
    public int compareTo(IScopeSelector o) {
        return ScopeSelector.compare(this.matchResults, o.getMatchResults());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScopeSelector) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    @Override
    public List<Integer> getMatchResults() {
        if (this.matchResults == null) {
            return Collections.emptyList();
        }
        return this.matchResults;
    }

    public ISelectorNode getRoot() {
        return this._root;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean matches(String scope) {
        this.matchResults = new ArrayList<Integer>();
        boolean result = false;
        if (this._root != null && scope != null) {
            MatchContext context = new MatchContext(scope);
            int i = 0;
            while (i < context.getLength()) {
                context.pushCurrentStep();
                if (this._root.matches(context)) {
                    List<Integer> tmpResults = this._root.getMatchResults();
                    int toRemove = tmpResults.size() - 1;
                    int x = 0;
                    while (x < toRemove) {
                        this.matchResults.remove(0);
                        ++x;
                    }
                    this.matchResults.addAll(0, tmpResults);
                    while (this.matchResults.size() < context.getLength()) {
                        this.matchResults.add(0, 0);
                    }
                    result = true;
                    break;
                }
                this.matchResults.add(0, 0);
                context.popCurrentStep();
                context.backup();
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean matches(String[] scopes) {
        boolean result = false;
        if (this._root != null && scopes != null) {
            String[] stringArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                if (this.matches(scope)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private static ISelectorNode parse(String selector) {
        ScopeParser parser = new ScopeParser();
        ISelectorNode root = null;
        if (!StringUtil.isEmpty((String)selector)) {
            try {
                root = parser.parse(selector);
            }
            catch (Exception e) {
                String message = MessageFormat.format("An error occurred while parsing scope ''{0}'' : {1}", selector, e.getMessage());
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)message);
            }
        }
        return root;
    }

    public String toString() {
        if (this.fString == null) {
            this.fString = this._root == null ? "" : this._root.toString();
        }
        return this.fString;
    }
}

