/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.filter.ISDocMLFileIndexingFilter;
import com.aptana.index.core.filter.IndexFilterManager;
import com.pandora.core.utils.RegularUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SDocMLFileIndexingFilter
implements ISDocMLFileIndexingFilter {
    public static Set<BuildPathEntry> buildPathEntrys;
    public static HashMap<String[], String> displayNames;
    public static HashMap<String, BuildPathEntry> buildPathEntryMap;
    static String SPLIT;
    public static String ZEPTO_REG_KEY;
    public static String WX_REG_KEY;
    public static String MUI_REG_KEY;
    public static String JQ_REG_KEY;
    public static HashMap<String, String> REG_MAP;
    private HashMap<String, String> buildPathCache = new HashMap();
    private IProject project;

    static {
        SPLIT = " ";
        ZEPTO_REG_KEY = "zepto";
        WX_REG_KEY = "weixin";
        MUI_REG_KEY = "mui";
        JQ_REG_KEY = "jquery";
        REG_MAP = new HashMap();
        SDocMLFileIndexingFilter.init();
    }

    public static void init() {
        buildPathEntrys = BuildPathManager.getInstance().getBuildPaths();
        displayNames = new HashMap();
        buildPathEntryMap = new HashMap();
        for (BuildPathEntry buildPathEntry : buildPathEntrys) {
            if (buildPathEntry == null || StringUtil.isBlank((String)buildPathEntry.getDisplayName())) continue;
            String displayName = buildPathEntry.getDisplayName();
            displayName = displayName.toLowerCase();
            buildPathEntryMap.put(displayName, buildPathEntry);
            String[] nv = displayName.split(SPLIT);
            if (nv.length <= 1) continue;
            displayNames.put(nv, displayName);
        }
        SDocMLFileIndexingFilter.loadConfig();
    }

    public static void loadConfig() {
        block16: {
            InputStream in = null;
            Properties p = new Properties();
            try {
                try {
                    in = SDocMLFileIndexingFilter.class.getResourceAsStream("sdocml_reg.properties");
                    if (in != null) {
                        p.load(in);
                    }
                    Set<Object> keys = p.keySet();
                    for (Object key : keys) {
                        REG_MAP.put(key.toString(), p.get(key).toString());
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean filterFile(IFileStore fStore, IProject project) {
        while (buildPathEntrys == null || buildPathEntrys.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            SDocMLFileIndexingFilter.init();
        }
        if (fStore == null || project == null) {
            return false;
        }
        this.project = project;
        try {
            IndexFilterManager manager = IndexFilterManager.getInstance();
            File file = fStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
            String fname = file.getName();
            fname = fname.toLowerCase();
            boolean isRemove = false;
            String md5 = "";
            String disPlayName = "";
            BuildPathManager buildPathManager = BuildPathManager.getInstance();
            String reg = "\\d+\\.?(\\d*\\.?)\\d*";
            String jqKey = "jquery";
            String jqDisplayName = "jquery 2.0";
            String muiKey = "mui";
            String zeptoKey = "zepto";
            if (StringUtil.isNotBlank((String)fname) && (fname.endsWith(".js") || fname.endsWith(".jsx") || fname.endsWith(".htc"))) {
                Set<String[]> keySet = displayNames.keySet();
                for (String[] nv : keySet) {
                    String key = nv[0];
                    if (!fname.contains(key = key.toLowerCase())) continue;
                    boolean isJQKey = jqKey.equals(key);
                    if (!isJQKey) {
                        disPlayName = displayNames.get(nv);
                        if (key.equals(muiKey)) {
                            isRemove = SDocMLFileIndexingFilter.checkIsMuiJS(file);
                            break;
                        }
                        if (key.equals(zeptoKey)) {
                            isRemove = SDocMLFileIndexingFilter.checkIsZeptoJS(fname);
                            break;
                        }
                        isRemove = SDocMLFileIndexingFilter.checkSpecJS(fname);
                        break;
                    }
                    if (StringUtil.isBlank((String)md5)) {
                        md5 = SDocMLFileIndexingFilter.getMD5(file);
                    }
                    isRemove = SDocMLFileIndexingFilter.checkIsJQ(fname);
                    if (StringUtil.isBlank((String)md5)) break;
                    Object o = buildPathManager.properties.get(md5);
                    if (o == null) {
                        this.buildPathCache.put(jqDisplayName, jqKey);
                    } else {
                        String jsName = o.toString();
                        if (StringUtil.isBlank((String)jsName) || !(jsName = jsName.toLowerCase()).contains(key)) break;
                    }
                    String v = RegularUtils.match((String)reg, (String)fname, (int)0);
                    if (StringUtil.isBlank((String)v)) break;
                    String[] vs = v.split("\\.");
                    String lv = vs[0];
                    boolean isR = false;
                    if (lv.equals("2")) {
                        isR = true;
                    } else if (lv.equals("1")) {
                        isR = true;
                    }
                    if (!isR) continue;
                    isRemove = isR;
                    if (nv[1].startsWith(lv)) {
                        disPlayName = displayNames.get(nv);
                        break;
                    }
                    boolean isexist = false;
                    for (String[] nvs : keySet) {
                        if (!nvs[0].equals(key) || !nvs[1].startsWith(lv)) continue;
                        disPlayName = displayNames.get(nvs);
                        isexist = true;
                        break;
                    }
                    if (isexist) break;
                }
            }
            if (StringUtil.isNotBlank((String)disPlayName)) {
                BuildPathEntry buildPathEntry = buildPathEntryMap.get(disPlayName);
                Set<BuildPathEntry> buildPathEntrySet = buildPathManager.getBuildPaths(project);
                if (!buildPathEntrySet.contains(buildPathEntry)) {
                    buildPathEntrySet.add(buildPathEntry);
                    Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
                    ArrayList<BuildPathEntry> list = new ArrayList<BuildPathEntry>();
                    buildPathEntrySet.toArray(bea);
                    CollectionsUtil.addToList(list, (Object[])bea);
                    buildPathManager.setBuildPaths(project, list);
                }
            }
            if (isRemove) {
                manager.addFilterItem(fStore);
                manager.commitFilteredItems();
            }
            return isRemove;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkIsZeptoJS(String fname) {
        String zeptoReg = REG_MAP.get(ZEPTO_REG_KEY);
        if (StringUtil.isBlank((String)zeptoReg)) {
            zeptoReg = "^zepto(([\\.\\-\\_\\s]{0,1}\\d{1}\\.\\d{1,2}\\.\\d{1,2})?([\\.\\_\\-]min)?)?\\.js$";
        }
        return SDocMLFileIndexingFilter.isMatch(fname, zeptoReg);
    }

    public static boolean checkSpecJS(String fname) {
        for (Map.Entry<String, String> entry : REG_MAP.entrySet()) {
            if (!SDocMLFileIndexingFilter.isMatch(fname, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(String fname, String reg) {
        boolean isRemove = false;
        if (StringUtil.isNotBlank((String)fname) && RegularUtils.isMatch((String)reg, (String)fname.toLowerCase())) {
            isRemove = true;
        }
        return isRemove;
    }

    public static boolean checkIsWXJS(String fname) {
        String wxReg = REG_MAP.get(WX_REG_KEY);
        if (StringUtil.isBlank((String)wxReg)) {
            wxReg = "^jweixin(([\\.\\-\\_\\s]{0,1}\\d{1}\\.\\d{1,2}\\.\\d{1,2})?([\\.\\_\\-]min)?)?\\.js$";
        }
        return SDocMLFileIndexingFilter.isMatch(fname, wxReg);
    }

    public static boolean checkIsMuiJS(String fname) {
        String muiReg = REG_MAP.get(MUI_REG_KEY);
        if (StringUtil.isBlank((String)muiReg)) {
            muiReg = "^mui(([\\.\\-\\_\\s]{0,1}\\d{1}\\.\\d{1,2}\\.\\d{1,2})?([\\.\\_\\-]min)?)?\\.js$";
        }
        return SDocMLFileIndexingFilter.isMatch(fname, muiReg);
    }

    public static boolean checkIsJQ(String fname) {
        String jqReg = REG_MAP.get(JQ_REG_KEY);
        if (StringUtil.isBlank((String)jqReg)) {
            jqReg = "^jquery(([\\.\\-\\_\\s]{0,1}\\d{1}\\.\\d{1,2}\\.\\d{1,2})?([\\.\\_\\-]min)?)?\\.js$";
        }
        return SDocMLFileIndexingFilter.isMatch(fname, jqReg);
    }

    public static boolean checkIsMuiJS(File iFile) throws CoreException {
        String content;
        StringBuilder sb;
        boolean isRemove;
        String muiSP;
        block19: {
            muiSP = "(https://github.com/dcloudio/mui)";
            isRemove = false;
            sb = new StringBuilder();
            FileInputStream inputStream = null;
            BufferedReader reader = null;
            try {
                try {
                    inputStream = new FileInputStream(iFile);
                    reader = new BufferedReader(new InputStreamReader(inputStream));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        break block19;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (StringUtil.isNotBlank((String)(content = sb.toString())) && content.indexOf(muiSP) > 0) {
            isRemove = true;
        }
        return isRemove;
    }

    /*
     * Exception decompiling
     */
    public static String getMD5(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearCache() {
        if (this.project == null) {
            return;
        }
        BuildPathManager buildPathManager = BuildPathManager.getInstance();
        Set<BuildPathEntry> buildPathEntrySet = buildPathManager.getBuildPaths(this.project);
        Set<String> keys = this.buildPathCache.keySet();
        for (String key : keys) {
            BuildPathEntry buildPathEntry = buildPathEntryMap.get(key);
            if (buildPathEntrySet.contains(buildPathEntry)) break;
            boolean isAdded = false;
            for (BuildPathEntry bpe : buildPathEntrySet) {
                if (!bpe.getDisplayName().toLowerCase().contains(this.buildPathCache.get(key))) continue;
                isAdded = true;
                break;
            }
            if (isAdded) break;
            buildPathEntrySet.add(buildPathEntry);
            Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
            ArrayList<BuildPathEntry> list = new ArrayList<BuildPathEntry>();
            buildPathEntrySet.toArray(bea);
            CollectionsUtil.addToList(list, (Object[])bea);
            buildPathManager.setBuildPaths(this.project, list);
            this.buildPathCache.clear();
            this.buildPathCache = new HashMap();
        }
    }
}

