/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.index.core.build.BuildContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ReconcileContext
extends BuildContext {
    private String contents;
    private String contentType;
    private URI uri;
    private boolean fInitialReconcile = false;

    public ReconcileContext(String contentType, IFile file, String contents) {
        super(file);
        this.contents = contents == null ? "" : contents;
        this.contentType = contentType;
    }

    public ReconcileContext(String contentType, URI uri, String contents) {
        this(contentType, (IFile)null, contents);
        this.uri = uri;
    }

    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        return Path.fromPortableString((String)this.getURI().getPath()).lastSegment();
    }

    public String getContents() {
        return this.contents;
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws CoreException {
        try {
            String charset = this.getCharset();
            if (charset == null) {
                charset = "UTF-8";
            }
            return new ByteArrayInputStream(this.getContents().getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.buildpath.core", "Failed to open input stream on editor contents due to unsupported encoding exception", (Throwable)e));
        }
    }

    public String getContentType() throws CoreException {
        return this.contentType;
    }

    public boolean isReconcile() {
        return true;
    }

    public boolean isInitialReconcile() {
        return this.fInitialReconcile;
    }

    public void setInitialReconcile(boolean initialReconcile) {
        this.fInitialReconcile = initialReconcile;
    }
}

